/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.store;

import jp.co.connectone.eai.exch2k.user.Exch2kAccountData;
import jp.co.connectone.service.ServiceInfo;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class Exch2kServiceInfo extends ServiceInfo
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected String casAddress=null;
	protected String protocolPrefix=EAIExch2kBase.DEFAULT_PROTOCOL_PREFIX;
	
	public String getAccountClassName()
	{
		return Exch2kAccountData.class.getName();
	}

	/**
	 * @param storeID
	 * @param type
	 * @param name
	 */
	public Exch2kServiceInfo(IStoreID storeID, String name)
	{
		super(storeID, name);
	}

	public String getCasAddress()
	{
		return casAddress;
	}

	public void setCasAddress(String casAddress)
	{
		this.casAddress = casAddress;
	}

	public String getProtocolPrefix()
	{
		return protocolPrefix;
	}

	public void setProtocolPrefix(String protocolPrefix)
	{
		this.protocolPrefix = protocolPrefix;
	}

	public String getStandbyADAddress()
	{
		return serverAddress2;
	}

	public void setStandbyADAddress(String standbyADAddress)
	{
		serverAddress2 = standbyADAddress;
	}

	public void setParam1(String param)
	{
		super.setParam1(param);
		this.casAddress=param;
	}
}
