/**
 * Copyright (C) 2006/05/22 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.store;

import java.io.*;
import java.lang.reflect.Method;
import java.util.*;

import javax.activation.DataHandler;
import javax.mail.*;
import javax.mail.internet.*;

import jp.co.connectone.eai.exch2k.dav.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.client.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;

public class Exch2kMailStoreImpl extends EAIExch2kBase implements IMailStore
{
	public static final int DEST_TYPE_OLD_MAIL_FOLDER=11;

	private static final String DEFAULT_EXCHANGE_INBOX_PATH_ELEMENT = "MgC";

	private static final String OLD_EXCHANGE_INBOX_PATH_ELEMENT = "Mڲ";

	private static final String DEFAULT_EXCHANGE_SENTBOX_PATH_ELEMENT = "Mς݃ACe";

	private static final String DEFAULT_EXCHANGE_SENDINGBOX_PATH_ELEMENT = "MgC";

	private IFolderIndex inboxElement = new Exch2kFolderIndex(DEFAULT_EXCHANGE_INBOX_PATH_ELEMENT);

	private IFolderIndex oldInboxElement = new Exch2kFolderIndex(OLD_EXCHANGE_INBOX_PATH_ELEMENT);

	private IFolderIndex sentboxElement = new Exch2kFolderIndex(DEFAULT_EXCHANGE_SENTBOX_PATH_ELEMENT);

	private IFolderIndex sendingboxElement = new Exch2kFolderIndex(DEFAULT_EXCHANGE_SENDINGBOX_PATH_ELEMENT);

	public static final IStoreID storeID = new SimpleStoreID(Exch2kMailStoreImpl.class.getName());

	public static final String storeName = "Exchange2K mail store";

	public String getName() throws Exception
	{
		return storeName;
	}
	
	public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception
	{
		return super.getServiceInfo(storeID, storeName, serviceData);
	}
	
	public IServiceInfo getServiceInfo() throws Exception
	{
		return new Exch2kServiceInfo(storeID, storeName);
	}

	public IStoreID getStoreID() throws Exception
	{
		return storeID;
	}

	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		deleteMail(acc, oid);
	}

	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception
	{
		return getMailsByDate(acc, dest, new Date());
	}

	public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception
	{
		return getMailFolders(acc, dest);
	}

	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		return getMail(acc, dest, oid);
	}

	public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception
	{
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("IStore.search is not yet supported.");
	}

	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws Exception
	{
		return getMailsByDate(acc, dest, startDate);
	}

	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception
	{
		return sendMail(acc, (IMailDTO) data);
	}

	protected static Exch2kMailStoreImpl store = null;

	public static Exch2kMailStoreImpl getInstance()
	{
		store = new Exch2kMailStoreImpl();
		return store;
	}

	private Exch2kMailDTO populateHeaderDTO(HashMap<String,Object> itemList) throws ServerDown, DataNotFound
	{
		HeaderDTO l_headerDTOObj = new HeaderDTO();
		l_headerDTOObj.setHeaderUIDL((String) itemList.get("id"));
		l_headerDTOObj.setOid(new Exch2kObjectIndex(itemList.get("permanenturl")));
		l_headerDTOObj.setHeaderFrom((String) itemList.get("from"));
		l_headerDTOObj.setHeaderSubject((String) itemList.get("subject"));
		int pri = 0;// 0=normal
		String priStr = (String) itemList.get("importance");
		try {
			pri = Integer.parseInt(priStr);
		}
		catch (Exception e) {
		}
		;
		l_headerDTOObj.setHeaderPriority(pri);
		l_headerDTOObj.setHeaderReplyTo((String) itemList.get("reply-to"));
		int length = 0;
		String strLength = (String) itemList.get("getcontentlength");
		try {
			length = Integer.parseInt(strLength);
		}
		catch (Exception e) {
		}
		;
		l_headerDTOObj.setHeaderSize(length);
		String strDate = (String) itemList.get("date");
		l_headerDTOObj.setHeaderSendDate(davDateStr2JavaDate(strDate));
		strDate = (String) itemList.get("datereceived");
		l_headerDTOObj.setHeaderReceivedDate(davDateStr2JavaDate(strDate));

		String CCs = (String) itemList.get("cc");
		l_headerDTOObj.setHeaderCC(parseAddresses(CCs));
		String TOs = (String) itemList.get("to");
		l_headerDTOObj.setHeaderTo(parseAddresses(TOs));
		String BCCs = (String) itemList.get("bcc");
		l_headerDTOObj.setHeaderBCC(parseAddresses(BCCs));

		Exch2kMailDTO rc = new Exch2kMailDTO(l_headerDTOObj);
		rc.setNew(false);
		String hasAttachment = (String) itemList.get("hasattachment");
		Log.debug("hasattachment=" + hasAttachment);
		if (hasAttachment == null) return rc;
		if ("1".equals(hasAttachment)) {
			AttachmentDTO atts[] = new AttachmentDTO[1];
			atts[0] = new AttachmentDTO();

			rc.setAttachments(atts);

		}

		return rc;
	} // end populateHeaderDTO

	private MailAddress[] parseAddresses(String src)
	{
		MailAddress[] ret = null;
		try {
			ret = MailAddress.parseAddressLine(MimeUtility.decodeText(src));
		}
		catch (Exception e) {
		}
		;
		return ret;
	}

	private Exch2kMailDTO setExch2kElements(Exch2kMailDTO src, HashMap<String,Object> itemList)
	{
		Class<? extends Exch2kMailDTO> c = src.getClass();
		Method[] f = c.getDeclaredMethods();
		for (int i = 0; i < f.length; i++) {
			String fieldName = f[i].getName();
			if (!(fieldName.startsWith("set"))) continue;
			fieldName = fieldName.substring(3).toLowerCase().replaceAll("_", "-");
			// Log.debug("fieldName:"+fieldName);
			Object o = itemList.get(fieldName);
			if (o != null && !"".equals(o)) {
				// Log.debug("value:"+(String)o);
				String valueType = o.getClass().getName();
				if ("java.lang.String".equalsIgnoreCase(valueType)) {
					String fieldType = (f[i].getParameterTypes())[0].getName();
					// Log.debug("fieldType:"+fieldType);
					Object[] oa = new Object[1];
					if ("java.lang.String".equalsIgnoreCase(fieldType)) {
						oa[0] = (String) o;
					}
					else if ("long".equalsIgnoreCase(fieldType)) {
						oa[0] = new Long((String) o);
					}
					else if ("int".equalsIgnoreCase(fieldType)) {
						oa[0] = new Integer((String) o);
					}
					else if ("boolean".equalsIgnoreCase(fieldType)) {
						boolean b = false;
						if ("1".equals(o)) {
							b = true;
						}
						else if ("true".equals(o)) {
							b = true;
						}
						oa[0] = new Boolean(b);
					}
					else if ("java.util.Date".equalsIgnoreCase(fieldType)) {
						oa[0] = davDateStr2JavaDate((String) o);
					}
					try {
						f[i].invoke(src, oa);
					}
					catch (Exception e) {
						Log.error("", e);
					}
				}
			}
		}
		return src;
	}

	@SuppressWarnings("unchecked")
	private IMailDTO populateMailDTO(HashMap<String,Object> itemList) throws ServerDown, StoreNotFound, DataNotFound, HandleException
	{
		Exch2kMailDTO l_IMailDTOObj = populateHeaderDTO(itemList);

		l_IMailDTOObj.setBody((String) itemList.get("textdescription"));
		HashMap<String,Object> files = null;
		try {
			Object o = itemList.get("attachmentfile");
			if (o instanceof HashMap<?,?>) {
				files = (HashMap<String,Object>)o;
			}
		}
		catch (ClassCastException e) {
		}
		;
		if (files != null) {
			AttachmentDTO atts[] = new AttachmentDTO[files.size()];
			String[] keys = new String[0];
			keys = (String[]) files.keySet().toArray(keys);
			for (int i = 0; i < files.size(); i++) {
				atts[i] = new AttachmentDTO();
				atts[i].setFileName(keys[i]);
				atts[i].setFileBody((byte[]) files.get(keys[i]));
			}
			l_IMailDTOObj.setAttachments(atts);
		}

		return setExch2kElements(l_IMailDTOObj, itemList);
	}

	private MimeMessage populateMail(IMailDTO dto) throws NoSuchRights, HandleException, IncorrectData
	{
		MimeMessage mail = super.getMessageInstance();
		HeaderDTO header = dto.getHeader();
		try {
			mail.setSubject(header.getHeaderSubject(), "ISO-2022-JP");
			// mail.setFrom(populateAddress(header.getHeaderFrom()));
			mail.setFrom(new InternetAddress(super.getMailAddress()));
			MailAddress replyTo = dto.getHeader().getHeaderReplyTo();
			if (replyTo != null) {
				Log.debug("replyTo:" + replyTo);
				if (replyTo.getRawAddress().length() > 0) {
					Address[] replyAddress = new Address[1];
					replyAddress[0] = populateAddress(replyTo);
					mail.setReplyTo(replyAddress);
				}
			}
			MailAddress[] toAddress = header.getHeaderTo();
			if (toAddress != null) {
				if (toAddress.length > 0) {
					Address[] to = new Address[toAddress.length];
					for (int i = 0; i < to.length; i++) {
						to[i] = populateAddress(toAddress[i]);
					}
					mail.setRecipients(Message.RecipientType.TO, to);
				}
			}
			MailAddress[] ccAddress = header.getHeaderCC();
			if (ccAddress != null) {
				if (ccAddress.length > 0) {
					Address[] cc = new Address[ccAddress.length];
					for (int i = 0; i < cc.length; i++) {
						cc[i] = populateAddress(ccAddress[i]);
					}
					mail.setRecipients(Message.RecipientType.CC, cc);
				}
			}
			MailAddress[] bccAddress = header.getHeaderBCC();
			if (bccAddress != null) {
				if (bccAddress.length > 0) {
					Address[] bcc = new Address[bccAddress.length];
					for (int i = 0; i < bcc.length; i++) {
						bcc[i] = populateAddress(bccAddress[i]);
					}
					mail.setRecipients(Message.RecipientType.BCC, bcc);
				}
			}
			if (dto.getNumberOfAttachments() > 0) {
				Log.debug("having attachments");
				MimeMultipart part1 = new MimeMultipart();
				MimeBodyPart body1 = new MimeBodyPart();

				body1.setText(dto.getBody(), "ISO-2022-JP");
				part1.addBodyPart(body1);

				for (int i = 0; i < dto.getNumberOfAttachments(); i++) {
					AttachmentDTO att = dto.getAttachment(i);
					// att.setFileBody(getFileBody(new
					// String(att.getFileBody())));
					MimeBodyPart attach = new MimeBodyPart();
					attach.setDataHandler(new DataHandler(new AttachmentDataSource(att)));
					String attName = att.getFileName();
					try {
						attName = MimeUtility.encodeText(attName, "ISO-2022-JP", "B");
					}
					catch (Exception e) {
						Log.error("Exception on encoding Japanese Filename", e);
					}
					Log.debug("attName=" + attName);
					attach.setFileName(attName);
					part1.addBodyPart(attach);
				}

				mail.setContent(part1);
			}
			else {
				try {
					ByteArrayOutputStream bao = new ByteArrayOutputStream();
					OutputStream out = MimeUtility.encode(bao, "base64");
					out.write(dto.getBody().getBytes("ISO-2022-JP"));
					out.close();

					mail.setText(bao.toString(), "ISO-2022-JP");
				}
				catch (Exception e) {
					Log.error("Exception on encoding Japanese Body", e);
				}
				mail.setHeader("Content-transfer-encoding", "base64");
			}
			mail.saveChanges();
		}
		catch (MessagingException e) {
			Log.error("", e);
		}
		return mail;
	}

	public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		FolderMetadata[] l_strFolderlist = new FolderMetadata[0];
		setAccountData((PasswordBasedAccountDataImpl) acc);
		IFolderIndex path = null;
		if (dest != null) {
			path = dest.getFolder();
		}
		if (path == null) path = inboxElement;
		Vector<Object> lists = super.getAllSubFolders((String) path.getIndex());
		if (lists == null) return null;
		if (lists.size() == 0) return null;
		String root = (String) lists.get(0);
		root = root.substring(0, root.length() - 1);
		ArrayList<FolderMetadata> arrFolderlist = populateFolderList(0, root, lists);
		l_strFolderlist = (FolderMetadata[]) arrFolderlist.toArray(l_strFolderlist);
		for (int i = 0; i < l_strFolderlist.length; i++) {
			// l_strFolderlist[i].setTid(i);
			if (l_strFolderlist[i].getFolderName().length() == 0) {
				l_strFolderlist[i].setFolderName((String) path.getIndex());
			}
		}
		return l_strFolderlist;
	}// end getMailFolders

	public int getNumberOfMessages(IAccountData acc, IFolderIndex folder) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("getNumberOfMessages is not yet supported.");
	}

	public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		IMailDTO[] headers = null;
		IFolderIndex folder = dest.getFolder();

		setAccountData((PasswordBasedAccountDataImpl) acc);
		Vector<HashMap<String,Object>> col = super.getList(folder, makeItemList());
		int len = col.size();
		headers = new IMailDTO[len];
		for (int i = 0; i < len; i++) {
			headers[i] = populateHeaderDTO(col.elementAt(i));
		}

		return headers;
	} // end getHeaders

	public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, java.util.Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		IMailDTO[] headers = null;
		IFolderIndex folder = dest.getFolder();

		setAccountData((PasswordBasedAccountDataImpl) acc);
		Vector<HashMap<String,Object>> col = super.exGetListByDate(DEPTH_1, folder, makeItemList(), date, "urn:schemas:httpmail:datereceived");
		int len = col.size();
		headers = new IMailDTO[len];
		for (int i = 0; i < len; i++) {
			headers[i] = populateHeaderDTO(col.elementAt(i));
		}

		return headers;
	} // end getHeadersByDate

	public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		IMailDTO l_IMailDTOObj = null;
		Log.debug("getMail::oid=" + oid);

		setAccountData((PasswordBasedAccountDataImpl) acc);
		HashMap<String,Object> mail = super.getProps((String) oid.getIndex(), makeItemList());

		l_IMailDTOObj = populateMailDTO(mail);

		return l_IMailDTOObj;
	} // end getMail

	public IObjectIndex[] getUIDLsByDate(IAccountData arg0, ISearchDestination arg1, Date arg2) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("getUIDLsByDate is not yet supported.");
	}

	public IObjectIndex[] getUIDLs(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		throw new UnsupportedOperationException("getUIDLs is not yet supported.");
	}

	private Vector<String> makeItemList()
	{
		Vector<String> v = new Vector<String>();
		v.add("DAV:id");
		v.add("DAV:href");
		v.add("DAV:getcontentlength");

		/* urn:schemas:httpmail */
		v.add("urn:schemas:httpmail:attachmentfilename");
		v.add("urn:schemas:httpmail:bcc");
		v.add("urn:schemas:httpmail:calendar");
		v.add("urn:schemas:httpmail:cc");
		v.add("urn:schemas:httpmail:contacts");
		v.add("urn:schemas:httpmail:content-disposition-type");
		v.add("urn:schemas:httpmail:content-media-type");
		v.add("urn:schemas:httpmail:date");
		v.add("urn:schemas:httpmail:datereceived");
		v.add("urn:schemas:httpmail:deleteditems");
		// X v.add("urn:schemas:httpmail:displaybcc"); make 422 error
		v.add("urn:schemas:httpmail:displaycc");
		v.add("urn:schemas:httpmail:displayto");
		v.add("urn:schemas:httpmail:drafts");
		v.add("urn:schemas:httpmail:expiry_date");
		v.add("urn:schemas:httpmail:flagcompleted");
		v.add("urn:schemas:httpmail:from");
		v.add("urn:schemas:httpmail:fromemail");
		v.add("urn:schemas:httpmail:fromname");
		v.add("urn:schemas:httpmail:hasattachment");
		v.add("urn:schemas:httpmail:htmldescription");
		v.add("urn:schemas:httpmail:importance");
		v.add("urn:schemas:httpmail:inbox");
		v.add("urn:schemas:httpmail:journal");
		v.add("urn:schemas:httpmail:messageflag");
		v.add("urn:schemas:httpmail:msgfolderroot");
		v.add("urn:schemas:httpmail:normalizedsubject");
		v.add("urn:schemas:httpmail:notes");
		v.add("urn:schemas:httpmail:outbox");
		v.add("urn:schemas:httpmail:priority");
		v.add("urn:schemas:httpmail:read");
		v.add("urn:schemas:httpmail:reply-by");
		v.add("urn:schemas:httpmail:reply-to");
		v.add("urn:schemas:httpmail:savedestination");
		v.add("urn:schemas:httpmail:saveinsent");
		v.add("urn:schemas:httpmail:sender");
		v.add("urn:schemas:httpmail:senderemail");
		v.add("urn:schemas:httpmail:sendername");
		v.add("urn:schemas:httpmail:sendmsg");
		v.add("urn:schemas:httpmail:sentitems");
		v.add("urn:schemas:httpmail:subject");
		v.add("urn:schemas:httpmail:submitted");
		v.add("urn:schemas:httpmail:tasks");
		v.add("urn:schemas:httpmail:textdescription");
		v.add("urn:schemas:httpmail:thread_topic");
		v.add("urn:schemas:httpmail:to");
		v.add("urn:schemas:httpmail:unreadcount");
		v.add("http://schemas.microsoft.com/exchange/permanenturl");

		return v;
	}

	public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		IMailDTO l_mailArray[] = null;

		setAccountData((PasswordBasedAccountDataImpl) acc);
		Vector<HashMap<String,Object>> col = super.exGetListByDate(DEPTH_1, dest.getFolder(), makeItemList(), date, "urn:schemas:httpmail:datereceived");
		int len = col.size();
		l_mailArray = new IMailDTO[len];
		for (int i = 0; i < len; i++) {
			l_mailArray[i] = populateMailDTO(col.elementAt(i));
		}

		return l_mailArray;
	} // end getMailsByDate

	private Hashtable<String,String> populateMailProps(Exch2kMailDTO src)
	{
		Hashtable<String,String> rc = new Hashtable<String,String>();
		final String prefix = "urn:schemas:httpmail:";

		Class<? extends Exch2kMailDTO> c = src.getClass();
		Method[] f = c.getDeclaredMethods();
		for (int i = 0; i < f.length; i++) {
			String fieldName = f[i].getName();
			if (!(fieldName.startsWith("get"))) continue;
			fieldName = fieldName.substring(3).toLowerCase().replaceAll("_", "-");
			Log.debug("fieldName:" + fieldName);
			// these fields made errors with propPatch on Exch2k server
			if ("htmldescription".equals(fieldName)) continue;
			if ("from".equals(fieldName)) continue;
			if ("unreadcount".equals(fieldName)) continue;
			if ("reply-to".equals(fieldName)) continue;

			String fieldType = f[i].getReturnType().getName();
			Log.debug("fieldType:" + fieldType);
			Object value = null;
			try {
				value = f[i].invoke(src, (Object[])null);
			}
			catch (Exception e) {
				Log.error("", e);
			}
			if (value == null) continue;

			if ("java.lang.String".equalsIgnoreCase(fieldType)) {
				String v2 = (String) value;
				if (v2.length() == 0) continue;
				rc.put(prefix + fieldName, v2);
			}
			else if ("long".equalsIgnoreCase(fieldType)) {
				Long v2 = (Long) value;
				rc.put(prefix + fieldName, v2.toString());
			}
			else if ("int".equalsIgnoreCase(fieldType)) {
				Integer v2 = (Integer) value;
				rc.put(prefix + fieldName, v2.toString());
			}
			else if ("boolean".equalsIgnoreCase(fieldType)) {
				Boolean v2 = (Boolean) value;
				if (v2.booleanValue()) {
					rc.put(prefix + fieldName, "1");
				}
				else {
					rc.put(prefix + fieldName, "0");
				}
			}
			else if ("java.util.Date".equalsIgnoreCase(fieldType)) {
				Date v2 = (Date) value;
				rc.put(prefix + fieldName, super.javaDate2MSDavDateStr(v2));
			}

		}

		return rc;
	}

	public IObjectIndex sendMail(IAccountData acc, IMailDTO IMailDTOobj) throws NoSuchRights, ServerDown, IncorrectData, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl) acc);
		IObjectIndex oid = null;
		if (IMailDTOobj instanceof Exch2kMailDTO) {
			Exch2kMailDTO dto = (Exch2kMailDTO) IMailDTOobj;
			dto.copyExch2kElements2Header();
			oid = super.saveData(sendingboxElement.getIndex().toString(), populateMail(IMailDTOobj));
			Hashtable<String,String> table = populateMailProps(dto);
			super.saveData((String) oid.getIndex(), table);
			
		}
		else {
			oid = super.saveData(sendingboxElement.getIndex().toString(), populateMail(IMailDTOobj));
		}
		super.sendSavedMsg((String) oid.getIndex());
		return oid;
	}

	public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException
	{
		return getMailsByDate(acc, getPresetDestination(acc, DEST_TYPE_SENT_FOLDER), new Date());
	}

	public IMailDTO[] getSentMailsByDate(IAccountData acc, Date dateObj) throws ServerDown, HandleException
	{
		return getMailsByDate(acc, getPresetDestination(acc, DEST_TYPE_SENT_FOLDER), dateObj);
	} // end getMailsByDate

	public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl) acc);
		super.delete(oid);
	}

	protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException
	{
		throw new HandleException("Not yet implemented");
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.eai.exch2k.store.EAIExch2kBase#getElmentName()
	 */
	protected String getElmentName()
	{
		return DEFAULT_EXCHANGE_INBOX_PATH_ELEMENT;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.IStore#getPresetDestination(int)
	 */
	public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException
	{
		super.setAccountData((PasswordBasedAccountDataImpl) acc);
		IFolderIndex folder = null;
		IDatabaseIndex db = null;
		switch (type) {
		case DEST_TYPE_DEFAULT_MAIL_FOLDER:
			folder = (IFolderIndex) populateFolder(inboxElement).getOid();
			break;
		case DEST_TYPE_OLD_MAIL_FOLDER:
			folder = (IFolderIndex) populateFolder(oldInboxElement).getOid();
			break;
		case DEST_TYPE_SENT_FOLDER:
			folder = (IFolderIndex) populateFolder(sentboxElement).getOid();
			break;
		default:
			throw new IncorrectData("illegal folderType");
		}
		return (ISearchDestination) new BasicSearchDestination(db, folder);
	}

}
