/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav.ms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.util.WebdavStatus;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;


public class XmsEnumattsMethod extends XMLResponseMethodBase {


    /**
     * Method constructor.
     */
    public XmsEnumattsMethod() {
    }


    /**
     * Method constructor.
     */
    public XmsEnumattsMethod(String path) {
        super(path);
    }



    // ----------------------------------------------------- Instance Variables


    /**
     * The namespace abbreviation that prefixes DAV tags
     */
    protected String prefix = null;


    // ------------------------------------------------------------- Properties


    // --------------------------------------------------- WebdavMethod Methods

    public String getName() {
        return "X-MS-ENUMATTS";
    }

    public void recycle() {
        super.recycle();
        prefix = null;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn)
    throws IOException, HttpException {

        // set the default utf-8 encoding, if not already present
        if (getRequestHeader("Content-Type") == null ) super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        super.addRequestHeaders(state, conn);

    }

    protected String generateRequestBody() {
    	return "";
    }

    @SuppressWarnings("unchecked")
	public Enumeration getAllResponseURLs() {
        checkUsed();
        return getResponseURLs().elements();
    }


    @SuppressWarnings("unchecked")
	public Enumeration getResponseProperties(String urlPath) {
        checkUsed();

        Response response = (Response) getResponseHashtable().get(urlPath);
        if (response != null) {
            return response.getProperties();
        } else {
            return (new Vector()).elements();
        }

    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn)
        throws IOException, HttpException {
        try
        {
            int code = getStatusLine().getStatusCode();
            if (code == WebdavStatus.SC_BAD_REQUEST ||
                code == WebdavStatus.SC_MULTI_STATUS ||
                code == WebdavStatus.SC_FORBIDDEN ||
                code == WebdavStatus.SC_CONFLICT ) {
                parseXMLResponse(input);
            }
        }
        catch (IOException e) {
                // FIX ME:  provide a way to deliver non xml data
        }
    }

}





