/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.user;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map.Entry;

import jp.co.connectone.store.BasicRecordObject;

public class BasicUserImpl extends BasicRecordObject implements IUser,Serializable
{
	private static final long serialVersionUID = 1L;

	private IUserKey key;

	private Hashtable<String,Object> authParams = null;

	private Hashtable<String,IAccountData> accountDatas = new Hashtable<String,IAccountData>();

	private UserInfo primaryUserInfo;

	protected BasicUserImpl()
	{
		this.key = new BasicUserKey("Object");
		this.key.setKeyValue(this);
	}

	public static IUser getInstance()
	{
		return new BasicUserImpl();
	}

	public void addAccountData(IAccountData newAccData)
	{
		accountDatas.put(newAccData.getServiceInfo().getServiceCode(), newAccData);
	}
	
	public IAccountData getAccountData(String code)
	{
		if (code == null)
			return null;
		return (IAccountData) accountDatas.get(code);
	}

	public Iterator<Entry<String, IAccountData>> getAllAcountDatas()
	{
		return accountDatas.entrySet().iterator();
	}

	/**
	 * @return authParams ߂܂B
	 */
	public Hashtable<String,Object> getAuthParams()
	{
		return authParams;
	}

	/**
	 * @param authParams
	 *            ݒ肷 authParamsB
	 */
	public void setAuthParams(Hashtable<String,Object> authParams)
	{
		this.authParams = authParams;
	}

	/**
	 * @return key ߂܂B
	 */
	public IUserKey getKey()
	{
		return key;
	}

	/**
	 * @param key
	 *            ݒ肷 keyB
	 */
	public void setKey(IUserKey key)
	{
		this.key = key;
	}

	public UserInfo getPrimaryUserInfo()
	{
		return primaryUserInfo;
	}

	public void setPrimaryUserInfo(UserInfo primaryAddressInfo)
	{
		this.primaryUserInfo = primaryAddressInfo;
	}
}
