/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.user;

import java.lang.reflect.Constructor;

import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.store.BasicRecordObject;

public abstract class AccountData extends BasicRecordObject implements IAccountData
{
	private static final long serialVersionUID = 1L;
	protected IServiceInfo serviceInfo;
	private IUserKey uid;
	
	@SuppressWarnings("unchecked")
	public static IAccountData getInstance(IUserKey uid,IServiceInfo serviceInfo)
	{
		IAccountData rc = null;
		String className=serviceInfo.getAccountClassName();
		Object[] param = {uid,serviceInfo};
		Class<?>[] paramTypes = {IUserKey.class,IServiceInfo.class};
		try {
			Class<IAccountData> cl = (Class<IAccountData>) Class.forName(className);
			Constructor<IAccountData> c = cl.getConstructor(paramTypes);
			rc = c.newInstance(param);
		}
		catch (Exception e) {
			Log.error("failed to make instance of "+className,e);
		}
		return rc;
	}
	
	protected AccountData()
	{
		throw new NullPointerException("serviceInfo must not be null");
	}
	public AccountData(IUserKey uid,IServiceInfo serviceInfo)
	{
		setServiceInfo(serviceInfo);
		setUid(uid);
	}

	/**
	 * @return serviceInfo ߂܂B
	 */
	public IServiceInfo getServiceInfo()
	{
		return serviceInfo;
	}

	/**
	 * @param serviceInfo ݒ肷 serviceInfoB
	 */
	public void setServiceInfo(IServiceInfo serviceInfo)
	{
		this.serviceInfo = serviceInfo;
	}
	public IUserKey getUid() {
		return uid;
	}
	public void setUid(IUserKey uid) {
		this.uid = uid;
		super.oid = uid;
	}

}
