/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;
import java.io.*;
import java.util.*;

import javax.activation.DataHandler;
import javax.mail.Session;
import javax.mail.internet.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.client.AttachmentDataSource;



public class MailParseHelper extends BasicRecordObject
{
	private static final long serialVersionUID = 1L;
	protected HeaderDTO mHeader = null;
	protected IMailDTO mMail = null;
	
	public IObjectIndex getOid()
	{
		return mHeader.getOid();
	}
	
	public void setOid(IObjectIndex oid)
	{
		mHeader.setOid(oid);
	}
	
	public MailParseHelper()
	{
	}
	
	public MailParseHelper(MailParseHelper org)
	{
		mHeader = org.mHeader;
		mMail = org.mMail;
	}
	
	public MailParseHelper(HeaderDTO header)
	{
		setHeaderDTO(header);
	}
	
	public MailParseHelper(IMailDTO mail)
	{
		setMailDTO(mail);
	}

    public void setHeaderDTO(HeaderDTO header)
    {
    	mMail = null;
    	mHeader = header;
    }
    
    public void setMailDTO(IMailDTO mail)
    {
    	mMail = mail;
    	mHeader = mail.getHeader();
    }
    
    public String   getUIDL()
    {
    	return mHeader.getHeaderUIDL();
    }
    public Date getSentDate()
    {
    	return mHeader.getHeaderSendDate();
    }
    public Date getReceivedDate()
    {
    	return mHeader.getHeaderReceivedDate();
    }
    public String getSize()
    {
    	return "" + mHeader.getHeaderSize();
    }

    public MailAddress[] getTO()
    {
    	if (mHeader==null) return null;
    	return mHeader.getHeaderTo();
    }
    
    public void setTO(MailAddress[] to)
    {
    	if (mHeader!=null) {
    		mHeader.setHeaderTo(to);
    	}
    }
    
    public void setCC(MailAddress[] cc)
    {
    	if (mHeader!=null) {
    		mHeader.setHeaderCC(cc);
    	}
    }
    
    public void setBCC(MailAddress[] bcc)
    {
    	if (mHeader!=null) {
    		mHeader.setHeaderBCC(bcc);
    	}
    }

    public Collection<MailAddress> getTOCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = mHeader.getHeaderTo();
    	for (int i=0;i<array.length;i++) {
    		list.add(array[i]);
    	}
    	return list;
    }
    public MailAddress[] getCC()
    {
    	return mHeader.getHeaderCC();
    }
    public MailAddress[] getBCC()
    {
    	return mHeader.getHeaderBCC();
    }

    public Collection<MailAddress> getCCCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = mHeader.getHeaderCC();
    	for (int i=0;i<array.length;i++) {
    		list.add(array[i]);
    	}
    	return list;
    }

    public Collection<MailAddress> getBCCCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = mHeader.getHeaderBCC();
    	for (int i=0;i<array.length;i++) {
    		list.add(array[i]);
    	}
    	return list;
    }
    public MailAddress   getFrom()
    {
    	return mHeader.getHeaderFrom();
    }
    public MailAddress   getReplyTo()
    {
    	return mHeader.getHeaderReplyTo();
    }
    public String   getSubject()
    {
    	return mHeader.getHeaderSubject();
    }
    public String   getPriority()
    {
    	return "" + mHeader.getHeaderPriority();
    }

//  need to set IMailDTO instead of HeaderDTO
    public String   getBody()
    {
    	return mMail.getBody();
    }
    public String   getBodyHtml()
    {
    	String html = mMail.getBody();
    	if (html!=null) html.replaceFirst("\n","<BR>\n");
    	return html;
    }
    public int      getNumberOfAttachments()
    {
    	return mMail.getNumberOfAttachments();
    }
    
    public AttachmentDTO getAttachment(int number)
    {
    	return mMail.getAttachment(number);
    }
    
    public byte[]   getAttachmentBody(int number)
    {
    	return mMail.getAttachment(number).getFileBody();
    }
    
    public AttachmentDTO[] getAttachments()
    {
    	return mMail.getAttachments();
    }

    public Collection<AttachmentDTO> getAttachmentCollection()
    {
    	ArrayList<AttachmentDTO> list = new ArrayList<AttachmentDTO>();
    	AttachmentDTO[] array = mMail.getAttachments();
    	if (list==null) return list;
    	for (int i=0;i<array.length;i++) {
    		list.add(array[i]);
    	}
    	return list;
    }
    
    public String getAttachmentName(int number)
    {
    	return mMail.getAttachment(number).getFileName();
    }

    public String   getMailBinary() throws Exception
    {
    	String retStr = "";
		retStr = retStr + getHeaderBinary();
		retStr = retStr + getBodyBinary();
		return retStr;
    }

	public String   getHeaderBinary() throws Exception
	{
		String retStr = "";
		retStr = retStr + "Date: " + this.getSentDate() + "\n";
		retStr = retStr + "Message-ID: " + this.getUIDL() + "\n";
		retStr = retStr + "From: " + this.getFrom() + "\n";
		String strTo="";
		MailAddress[] tmpAddress = this.getTO();
		if (tmpAddress != null) {
			for (int i=0;i<tmpAddress.length;i++) {
				strTo = strTo + tmpAddress[i];
			}
			if (strTo.length()>0) retStr = retStr + "To: " + strTo + "\n";
		}
		String strCC = "";
		tmpAddress = this.getCC();
		if (tmpAddress != null) {
			for (int i=0;i<tmpAddress.length;i++) {
				strCC = strCC + tmpAddress[i];
			}
			if (strTo.length()>0) retStr = retStr + "Cc: " + strCC + "\n";
		}
		retStr = retStr + "Subject: " + this.getSubject() + "\n";
		return retStr;
	}

	public String   getBodyBinary() throws Exception
	{
		String rc = "";
		String bodyStr = mMail.getBody();
		AttachmentDTO[] attachments = mMail.getAttachments();
		if (attachments==null) {
			return "\n" + bodyStr;//wb_I[+body
		}
		try {
			MimeMessage msg = new MimeMessage((Session)null);
			MimeMultipart part = new MimeMultipart();
			MimeBodyPart body = new MimeBodyPart();
			body.setText(bodyStr,"ISO-2022-JP");
			part.addBodyPart(body);
			
			for (int i=0;i<attachments.length;i++) {
				MimeBodyPart attach = new MimeBodyPart();
				attach.setDataHandler(new DataHandler(new AttachmentDataSource(attachments[i])));
				attach.setFileName(MimeUtility.encodeText(attachments[i].getFileName(),"ISO-2022-JP","B"));
				part.addBodyPart(attach);
			}
			
			msg.setContent(part);
			msg.saveChanges();

			rc = "MIME-Version: 1.0\nContent-Type: " + msg.getHeader("Content-Type",null) + "\n\n";//Mimegwb_+wb_I[+MimeBody
			InputStream is = msg.getInputStream();
			BufferedReader b = new BufferedReader(new InputStreamReader(is));
			String tmp;
			while ((tmp = b.readLine())!=null) {
				rc = rc + tmp + "\r\n";
			}
			
		}
		catch (Exception e) {
			Log.error("Exception on creating MimeMessage",e);
		}
		return rc;
	}
	/**
	 * @return mHeader ߂܂B
	 */
	protected HeaderDTO getMHeader() {
		return mHeader;
	}
	/**
	 * @param header mHeader ݒB
	 */
	protected void setMHeader(HeaderDTO header) {
		mHeader = header;
	}
	/**
	 * @return mMail ߂܂B
	 */
	protected IMailDTO getMMail() {
		return mMail;
	}
	/**
	 * @param mail mMail ݒB
	 */
	protected void setMMail(IMailDTO mail) {
		mMail = mail;
	}
	/* ( Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if (mMail==null) return super.toString();
		return mMail.toString();
	}
}
