/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Comparator;


public class IAddressDTOComparator implements Comparator<IAddressDTO>
{
	public static final int DISPLAYNAME=0;
	private int sortKey=0;
	private boolean reverce=false;
	public IAddressDTOComparator(int sortKey,boolean isReverce)
	{
		this.sortKey = sortKey;
		this.reverce = isReverce;
	}

	public int compare(IAddressDTO o1, IAddressDTO o2)
	{
		
		if (o1==null) {
			return 0;
		}
		if (o2==null) {
			return 0;
		}
		IAddressDTO src = o1;
		IAddressDTO dst = o2;
		switch (sortKey) {
		case DISPLAYNAME:
			String s1 = src.getDisplayName();
			String s2 = dst.getDisplayName();
			int diff = s1.length() - s2.length();
			if (reverce) {
				if(diff != 0) {
					return -diff;
				}
				return s2.compareTo(s1);
			}
			else {
				if(diff != 0) {
					return diff;
				}
				return s1.compareTo(s2);
			}
		}
		
		return 0;
	}

}
