/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;
import java.util.*;
import java.io.*;

import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.IObjectIndex;

public class HeaderDTO implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * This method gets size from the header.
	 * @return size int
	 */
	public int getHeaderSize()
	{
		return size;
	}

	/**
	 * This method gets UIDL value from Header.
	 * @return UIDL String
	 */
	public String getHeaderUIDL()
	{
		return UIDL;
	}

	/**
	 * This method gets To address of the Header.
	 * @return toList MailAddress array
	 */
	public MailAddress[] getHeaderTo()
	{
		if (toList==null) return null;
//		return (MailAddress[])toList.toArray(new MailAddress[0]);
		return toList;
	}
	
	/**
	 * This method gets CC address of the Header.
	 * @return ccList MailAddress array
	 */
	public MailAddress[] getHeaderCC()
	{
		if (ccList==null) return null;
//		return (MailAddress[])ccList.toArray(new MailAddress[0]);
		return ccList;
	}


	/**
	 * This method gets BCC address of the Header.
	 * @return bccList MailAddress array
	 */
	public MailAddress[] getHeaderBCC()
	{
		if (bccList==null) return null;
//		return (MailAddress[])bccList.toArray(new MailAddress[0]);
		return bccList;
	}


	/**
	 * This method gets From address of the Header.
	 * @return from String
	 */
	public MailAddress getHeaderFrom()
	{
		return from;
	}

	/**
	 * This method gets replyTo address of the Header.
	 * @return replyTo String
	 */
	public MailAddress getHeaderReplyTo()
	{
		return replyTo;
	}

	/**
	 * This method gets subject of the Header.
	 * @return subject String
	 */
	public String getHeaderSubject()
	{
		return subject;
	}

	/**
	 * This method gets priority of the Header.
	 * @return priority int
	 */
	public int getHeaderPriority()
	{
		return priority;
	}

	/**
	 * This method gets message sendDate from Header.
	 * @return sendDate Date object
	 */
	public Date getHeaderSendDate()
	{
		return sendDate;
	}

	public Date getHeaderReceivedDate()
	{
		return receivedDate;
	}

	public void setHeaderReceivedDate(Date receivedDate)
	{
		this.receivedDate = receivedDate;
	}

	/**
	 * This method sets message size.
	 * @param size int size of the message
	 */
	public void setHeaderSize(int size)
	{
		this.size = size;
	}

	/**
	 * This method sets the UIDL value.
	 * @param UIDL UIDL of the message
	 */
	public void setHeaderUIDL(String UIDL)
	{
		this.UIDL = UIDL;
	}

	/**
	 * This method sets toList address.
	 * @param toList String array of To address.
	 */
	public void setHeaderTo(MailAddress[] toList)
	{
		if (toList==null) {
			this.toList = null;
		}
		else {
//			this.toList = new ArrayList();
//			for (int i=0;i<toList.length;i++) {
//				this.toList.add(toList[i]);
//			}
			this.toList = toList;
		}
	}

	public void setHeaderTo(String[] toList)
	{
		if (toList==null) {
			this.toList = null;
		}
		else {
			this.toList = new MailAddress[toList.length];
			for (int i=0;i<toList.length;i++) {
				this.toList[i] = new MailAddress(toList[i]);
			}
		}
	}

	/**
	 * This method sets ccList address.
	 * @param ccList String array of CC address
	 */

	public void setHeaderCC(String[] ccList)
	{
		if (ccList==null) {
			this.ccList = null;
		}
		else {
//			this.ccList = new ArrayList();
//			for (int i=0;i<ccList.length;i++) {
//				this.ccList.add(new MailAddress(ccList[i]));
//			}
			this.ccList = new MailAddress[ccList.length];
			for (int i=0;i<ccList.length;i++) {
				this.ccList[i] = new MailAddress(ccList[i]);
			}
		}
	}

	/**
	 * This method sets ccList address.
	 * @param ccList String array of CC address
	 */

	public void setHeaderCC(MailAddress[] ccList)
	{
		if (ccList==null) {
			this.ccList = null;
		}
		else {
			this.ccList = ccList;
		}
	}


	/**
	 * This method sets bccList address.
	 * @param ccList String array of BCC address
	 */

	public void setHeaderBCC(String[] bccList)
	{
		if (bccList==null) {
			this.bccList = null;
		}
		else {
//			this.bccList = new ArrayList();
//			for (int i=0;i<bccList.length;i++) {
//				this.bccList.add(new MailAddress(bccList[i]));
//			}
			this.bccList = new MailAddress[bccList.length];
			for (int i=0;i<bccList.length;i++) {
				this.bccList[i] = new MailAddress(bccList[i]);
			}
		}
	}

	/**
	 * This method sets bccList address.
	 * @param ccList String array of BCC address
	 */

	public void setHeaderBCC(MailAddress[] bccList)
	{
		if (bccList==null) {
			this.bccList = null;
		}
		else {
//			this.bccList = new ArrayList();
//			for (int i=0;i<bccList.length;i++) {
//				this.bccList.add(bccList[i]);
//			}
			this.bccList = bccList;
		}
	}


	/**
	 * This method sets from address.
	 * @param from String from-address of message
	 */
	public void setHeaderFrom(String from)
	{
		this.from=new MailAddress(from);
	}

	/**
	 * This method sets from address.
	 * @param from String from-address of message
	 */
	public void setHeaderFrom(MailAddress from)
	{
		this.from=from;
	}

	/**
	 * This method sets replyTo address.
	 * @param replyTo String replyTo address
	 */

	public void setHeaderReplyTo(String replyTo)
	{
		this.replyTo=new MailAddress(replyTo);
	}

	/**
	 * This method sets replyTo address.
	 * @param replyTo String replyTo address
	 */

	public void setHeaderReplyTo(MailAddress replyTo)
	{
		this.replyTo=replyTo;
	}

	/**
	 * This method sets subject.
	 * @param subject subject of the message
	 */
	public void setHeaderSubject(String subject)
	{
		this.subject = subject;
	}

	/**
	 * This method sets priority value.
	 * @param priority int priority of message
	 */
	public void setHeaderPriority(int priority)
	{
		this.priority = priority;
	}

	/**
	 * This method sets sendDate.
	 * @param sendDate sendDate of message
	 */
	public void setHeaderSendDate(Date sendDate)
	{
		this.sendDate = sendDate;
	}
	private 	int 			size      = 0;
	private	IObjectIndex	oid		  = new BasicObjectIndex();
	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.HeaderDTO#getObjectIndex()
	 */
	public IObjectIndex getOid() {
		return oid;
	}
	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.HeaderDTO#setObjectIndex(IObjectIndex oid)
	 */
	public void setOid(IObjectIndex oid) {
		this.oid = oid;
	}
	private 	String 			UIDL      = null;
	private 	MailAddress[]	toList    = null;
	private 	MailAddress[] 	ccList	  = null;
	private 	MailAddress[] 	bccList	  = null;
	private 	MailAddress		from	  = null;
	private	MailAddress		replyTo	  = null;
	private		String		subject	  = null;
	private		int			priority  = 0;
	private		Date		sendDate  = null;
	private		Date		receivedDate  = null;

}//end HeaderDTO class
