/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Date;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class BasicTaskDTO extends BasicRecordObject implements ITaskDTO
{
	private static final long serialVersionUID = 1L;
	private String tid;
	private IObjectIndex oid=new BasicObjectIndex();
	private String senderName;
	private Date date;
	private String subject;
	private String body;
	private int priority;
/*
id		tid			DAV:id
oid		oid			DAV:href
o^	senderName	sendername
o^	date		datereceived
薼	subject		subject
dvx	priority	importance
e	body		textdescription

ix
 */
	public BasicTaskDTO(){};
	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#copy(jp.co.connectone.store.client.BasicTaskDTO)
	 */
	public void copy(ITaskDTO src)
	{
		tid = src.getTid();
		oid = src.getOid();
		senderName = src.getSenderName();
		date = src.getDate();
		subject = src.getSubject();
		body = src.getBody();
		priority = src.getPriority();
	}

	public BasicTaskDTO(ITaskDTO src)
	{
		copy(src);
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getBody()
	 */
	public String getBody() {
		return body;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setBody(java.lang.String)
	 */
	public void setBody(String body) {
		this.body = body;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getDate()
	 */
	public Date getDate() {
		return date;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		this.date = date;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getOid()
	 */
	public IObjectIndex getOid() {
		return oid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setOid(java.lang.Object)
	 */
	public void setOid(IObjectIndex oid) {
		this.oid = oid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getPriority()
	 */
	public int getPriority() {
		return priority;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setPriority(int)
	 */
	public void setPriority(int priority) {
		this.priority = priority;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getSenderName()
	 */
	public String getSenderName() {
		return senderName;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setSenderName(java.lang.String)
	 */
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getSubject()
	 */
	public String getSubject() {
		return subject;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#getTid()
	 */
	public String getTid() {
		return tid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.ITaskDTO#setTid(java.lang.String)
	 */
	public void setTid(String tid) {
		this.tid = tid;
	}

}
