/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Date;

import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.*;

public class BasicScheduleDTO extends BasicRecordObject implements IScheduleDTO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected String userId=null;
	protected String subject=null;
	protected String body=null;
	protected Date startDate=null;
	protected Date endDate=null;
	protected String location=null;
	protected IObjectIndex boid=new BasicObjectIndex();
	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}
	public Date getEndDate() {
		return endDate;
	}
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IScheduleDTO#getObjectIndex()
	 */
	public IObjectIndex getOid() {
		return boid;
	}
	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IScheduleDTO#setObjectIndex(IObjectIndex)
	 */
	public void setOid(IObjectIndex oid) {
		this.boid = oid;
	}
	public Date getStartDate() {
		return startDate;
	}
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
