/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Date;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class BasicMemoDTO extends BasicRecordObject implements IMemoDTO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String tid;
	private IObjectIndex oid=new BasicObjectIndex();
	private String senderName;
	private Date date;
	private String subject;
	private String body;
/*
id		tid			DAV:id
oid		oid			DAV:href
o^	senderName	sendername
o^	date		datereceived
薼	subject		subject
e	body		textdescription
 */
	public BasicMemoDTO(){};
	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#copy(jp.co.connectone.store.client.BasicMemoDTO)
	 */
	public void copy(IMemoDTO src)
	{
		tid = src.getTid();
		oid = src.getOid();
		senderName = src.getSenderName();
		date = src.getDate();
		subject = src.getSubject();
		body = src.getBody();
	}

	public BasicMemoDTO(IMemoDTO src)
	{
		copy(src);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getBody()
	 */
	public String getBody() {
		return body;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setBody(java.lang.String)
	 */
	public void setBody(String body) {
		this.body = body;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getDate()
	 */
	public Date getDate() {
		return date;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		this.date = date;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getOid()
	 */
	public IObjectIndex getOid() {
		return oid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setOid(java.lang.Object)
	 */
	public void setOid(IObjectIndex oid) {
		this.oid = oid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getSenderName()
	 */
	public String getSenderName() {
		return senderName;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setSenderName(java.lang.String)
	 */
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getSubject()
	 */
	public String getSubject() {
		return subject;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#getTid()
	 */
	public String getTid() {
		return tid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.IMemoDTO#setTid(java.lang.String)
	 */
	public void setTid(String tid) {
		this.tid = tid;
	}
}
