/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import jp.co.connectone.store.*;


/**
 * @author amanot
 *
 */
public class BasicAddressDTO extends BasicRecordObject implements IAddressDTO 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String tid;
	private IObjectIndex oid=new BasicObjectIndex();
	private String firstName;
	private String familyName;
	private String displayName;
	private String email;
	private String companyPhone;
	private String homePhone;
	private String mobilePhone;
	private String companyName;
	private String companyAddress;
/*
id				tid				DAV:id
oid				oid				DAV:href
			displayName		sn+givenname
[AhX	email			email1
Tel			companyphone	telephoneNumber
Tel			homePhone		homePhone
gTel			mobilePhone		mobile
Ж			companyName		o
ЏZ		companyAddress	workaddress
 */

	public BasicAddressDTO(){};

	public BasicAddressDTO(IAddressDTO src)
	{
		copy(src);
	}

	public void copy(IAddressDTO src) {
		tid = src.getTid();
		oid = src.getOid();
		firstName=src.getFirstName();
		familyName=src.getFamilyName();
		email=src.getEmail();
		companyPhone=src.getCompanyPhone();
		homePhone=src.getHomePhone();
		mobilePhone=src.getMobilePhone();
		companyName=src.getCompanyName();
		displayName=src.getDisplayName();
		companyAddress=src.getCompanyAddress();
	}

	/**
	 * @return email ߂܂B
	 */
	public String getEmail() {
		return email;
	}
	/**
	 * @param email email ݒB
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	/**
	 * @return companyAddress ߂܂B
	 */
	public String getCompanyAddress() {
		return companyAddress;
	}
	/**
	 * @param companyAddress companyAddress ݒB
	 */
	public void setCompanyAddress(String companyAddress) {
		this.companyAddress = companyAddress;
	}
	/**
	 * @return companyName ߂܂B
	 */
	public String getCompanyName() {
		return companyName;
	}
	/**
	 * @param companyName companyName ݒB
	 */
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}
	/**
	 * @return companyPhone ߂܂B
	 */
	public String getCompanyPhone() {
		return companyPhone;
	}
	/**
	 * @param companyPhone companyPhone ݒB
	 */
	public void setCompanyPhone(String companyPhone) {
		this.companyPhone = companyPhone;
	}
	/**
	 * @return familyName ߂܂B
	 */
	public String getFamilyName() {
		return familyName;
	}
	/**
	 * @param familyName familyName ݒB
	 */
	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}
	/**
	 * @return firstName ߂܂B
	 */
	public String getFirstName() {
		return firstName;
	}
	/**
	 * @param firstName firstName ݒB
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	/**
	 * @return homePhone ߂܂B
	 */
	public String getHomePhone() {
		return homePhone;
	}
	/**
	 * @param homePhone homePhone ݒB
	 */
	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}
	/**
	 * @return mobilePhone ߂܂B
	 */
	public String getMobilePhone() {
		return mobilePhone;
	}
	/**
	 * @param mobilePhone mobilePhone ݒB
	 */
	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}
	/**
	 * @return oid ߂܂B
	 */
	public IObjectIndex getOid() {
		return oid;
	}
	/**
	 * @param oid oid ݒB
	 */
	public void setOid(IObjectIndex oid) {
		this.oid = oid;
	}
	/**
	 * @return tid ߂܂B
	 */
	public String getTid() {
		return tid;
	}
	/**
	 * @param tid tid ݒB
	 */
	public void setTid(String tid) {
		this.tid = tid;
	}
	public String getDisplayName() {
		if (displayName==null) return "";
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
}
