/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.db;

import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.SearchCondition;

public class DBSearchCondition extends SearchCondition
{
	@SuppressWarnings("unused")
	private DBSearchCondition(){}
	public enum CONDITION implements ISearchType {
		TYPE_STRING,TYPE_DATE,TYPE_INTEGER
	}


	public DBSearchCondition(ColumnDescriptor col)
	{
		super(col.getType(), col);
	}

	protected String getTypeName()
	{
		if (type==CONDITION.TYPE_STRING) return "CONDITION_TYPE_STRING";
		if (type==CONDITION.TYPE_DATE) return "CONDITION_TYPE_DATE";
		if (type==CONDITION.TYPE_INTEGER) return "CONDITION_TYPE_INTEGER";
		return "UNKNOWN TYPE";
	}

	protected boolean typeValidation(ISearchType type)
	{
		return true;
	}
	protected boolean valueValidation(Object value)
	{
		if (value instanceof ColumnDescriptor) return true;
		return false;
	}

}
