/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

import java.util.HashMap;


public class SimpleStoreID extends BasicRecordObject implements IStoreID
{
	private static final long serialVersionUID = 1L;
	private String id;
	private IObjectIndex	oid;
	
	/**
	 * @param id
	 */
	public SimpleStoreID(String id)
	{
		this.id = id;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStoreID#getIndex()
	 */
	public String getStoreID()
	{
		return id;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStoreID#setIndex(java.lang.Object)
	 */
	public void setStoreID(String oid)
	{
		id = oid;
	}

	/* ( Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(SimpleStoreID obj)
	{
		if (obj==null) return false;
		if (this.id.equalsIgnoreCase(obj.id)) return true;
		return false;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getFieldSet()
	 */
	public HashMap<String,Object> getFieldSet()
	{
		HashMap<String,Object> map = new HashMap<String,Object>();
		map.put("storeID",id);
		return map;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getOid()
	 */
	public IObjectIndex getOid()
	{
		return oid;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return false;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#setFieldSet(java.util.HashMap)
	 */
	public void setFieldSet(HashMap<String,Object> h)
	{
		if (h==null) {
			id=null;
		}
		else {
			id=(String)h.get("storeID");
		}
		
	}

}
