/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

import java.util.*;

/**
 * @author amanot
 *
 */
public class SearchConditionCollection implements Iterable<ISearchConditionElement>, ISearchConditionElement
{
	private ArrayList<ISearchConditionElement> v;
	public SearchConditionCollection()
	{
		v = new ArrayList<ISearchConditionElement>();
	}
	/* ( Javadoc)
	 * @see java.util.Collection#size()
	 */
	public int size() {
		return v.size();
	}

	/* ( Javadoc)
	 * @see java.util.Collection#clear()
	 */
	public void clear() {
		v.clear();
	}

	/* ( Javadoc)
	 * @see java.util.Collection#isEmpty()
	 */
	public boolean isEmpty() {
		return v.isEmpty();
	}

	/* ( Javadoc)
	 * @see java.util.Collection#toArray()
	 */
	public ISearchConditionElement[] toArray() {
		return v.toArray(new ISearchConditionElement[0]);
	}

	public boolean add(ISearchConditionElement o) {
		return v.add(o);
	}

	public boolean contains(ISearchConditionElement o) {
		return v.contains(o);
	}

	/* ( Javadoc)
	 * @see java.util.Collection#remove(java.lang.Object)
	 */
	public boolean remove(ISearchConditionElement o) {
		return v.remove(o);
	}

	/* ( Javadoc)
	 * @see java.util.Collection#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection<ISearchConditionElement> c) {
		return v.containsAll(c);
	}

	/* ( Javadoc)
	 * @see java.util.Collection#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection<ISearchConditionElement> c) {
		return v.removeAll(c);
	}

	/* ( Javadoc)
	 * @see java.util.Collection#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection<ISearchConditionElement> c) {
		return v.retainAll(c);
	}

	/* ( Javadoc)
	 * @see java.util.Collection#iterator()
	 */
	public Iterator<ISearchConditionElement> iterator() {
		return v.iterator();
	}

}
