/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

/**
 * @author amanot
 *
 */
public abstract class SearchCondition implements ISearchCondition
{
	protected SearchCondition(){};
	
	protected ISearchType type;
	protected Object value;
	public SearchCondition(ISearchType type,Object value)
	{
		if (typeValidation(type)==false) throw new IllegalArgumentException("this module cannot accept condition type "+type);
		if (valueValidation(value)==false) throw new IllegalArgumentException("this module cannot accept value class "+value.getClass().getName());
		this.type = type;
		this.value = value;
	}
	/**
	 * @return type ߂܂B
	 */
	public ISearchType getType() {
		return type;
	}
	/**
	 * @return value ߂܂B
	 */
	public Object getValue() {
		return value;
	}
	
	protected boolean valueValidation(Object value)
	{
		return true;
	}
	
	abstract protected String getTypeName();
	abstract protected boolean typeValidation(ISearchType type);
}
