/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.*;
import javax.crypto.*;
import javax.crypto.spec.*;

import org.apache.commons.codec.binary.Hex;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;

public class BasicRecordObject implements IRecordObject,Serializable
{
	private static final long serialVersionUID = 1L;
	protected IObjectIndex oid=null;
	protected HashMap<String , Object> fieldSet=null;
	protected boolean isnew=true;
	protected boolean caseSensitive=true;
	private static final char[] code = {'c','1','v','2','s','9','9'};
	private static final String code2="PBEWithMD5AndDES";
    private static final byte[] salt = {'c','1','v','2','s','a','l','t'};
    private static final int iteration = 10;
	
	public BasicRecordObject(IRecordObject src)
	{

		oid = src.getOid();
		isnew = src.isNew();
		if (src instanceof BasicRecordObject) {
			BasicRecordObject check = (BasicRecordObject) src;
			caseSensitive = check.caseSensitive;
		}
		try {
			setFieldSet(src.getFieldSet());
		}
		catch (Exception e){
			Log.error("BasicRecordObject copy error.",e);
		}
		
	}
	
	public String getDecryptedValue(String fieldName) throws Exception
	{
		String cval = (String)fieldSet.get(fieldName);
		return decrypt(cval);
	}
	
	public void setValueWithEncrypt(String fieldName,String value) throws Exception
	{
		fieldSet.put(fieldName, encrypt(value));
	}
	
	private static byte[] crypt(int mode,byte[] datas) throws Exception
	{
        Cipher cipher = Cipher.getInstance(code2);
        PBEKeySpec keySpec = new PBEKeySpec(code);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(code2);
        SecretKey key = keyFac.generateSecret(keySpec);
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iteration);
        cipher.init(mode, key, paramSpec);
        byte[] ptextByte = datas;
        return cipher.doFinal(ptextByte);
		
	}

	public static String encrypt(String plainText) throws Exception
	{
        byte[] datas = plainText.getBytes();
        byte[] out = crypt(Cipher.ENCRYPT_MODE, datas);
        
        Log.trace("length of crypted bytes:"+out.length);

        String ns = new String(Hex.encodeHex(out));
        return ns;
   }

	public static String decrypt(String crypted) throws Exception
	{
        byte[] datas = Hex.decodeHex(crypted.toCharArray());
        Log.trace("length of bytes to decrypt:"+datas.length);

        byte[] out = crypt(Cipher.DECRYPT_MODE, datas);
        return new String(out);
   }
	
	/**
	 * @return caseSensitive ߂܂B
	 */
	public boolean isCaseSensitive()
	{
		return caseSensitive;
	}
	/**
	 * @param caseSensitive ݒ肷 caseSensitiveB
	 */
	public void setCaseSensitive(boolean caseSensitive)
	{
		this.caseSensitive = caseSensitive;
	}
	
	public BasicRecordObject()
	{
		fieldSet = new HashMap<String, Object>();
	}
	
	public IObjectIndex getOid()
	{
		return oid;
	}

	public HashMap<String, Object> getFieldSet() throws Exception
	{
//		fieldSet = generateHashMap();
		return fieldSet;
	}

	public void setFieldSet(HashMap<String, Object> h) throws IllegalAccessException
	{
		fieldSet = h;
		try {
			getBean(this);
		}
		catch (Exception e) {
			Log.error("error on building bean-properties from fieldSet.",e);
		}
	}

	public boolean isNew()
	{
		return isnew;
	}
	
	public void setNew(boolean isnew)
	{
		this.isnew = isnew;
	}

	public void setOid(IObjectIndex oid)
	{
		this.oid = oid;
	}
	
	public void setBeanData() throws Exception
	{
		fieldSet = generateHashMap();
	}
	
	protected HashMap<String, Object> generateHashMap() throws Exception
	{
		Class<?> c = this.getClass();
		HashMap<String, Object> h = new HashMap<String, Object>();
		while (c != null) {
			if (c.equals(BasicRecordObject.class)) {
				break;
			}
			Method[] m = c.getDeclaredMethods();
			for (int i=0;i<m.length;i++) {
				String name = m[i].getName();
				if (name.startsWith("get")) {
					Object param[] = m[i].getParameterTypes();
					if (param.length==0) {
						if ("getFieldSet".equalsIgnoreCase(name)) continue;
						Log.trace("found getter:"+name);
						String fName = name.substring(3,4).toLowerCase() + name.substring(4);
						if (caseSensitive==false)fName = fName.toUpperCase();
						Object value = m[i].invoke(this,(Object[])null);
						h.put(fName,value);
					}
				}
			}
			c = c.getSuperclass();
		}
		return h;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getBean(java.lang.Object)
	 */
	public IRecordObject getBean(IRecordObject beanToBuild) throws Exception
	{
		if (!(beanToBuild instanceof BasicRecordObject)) {
			throw new HandleException("beanToBuild must be an instance of BasicRecordObject.");
		}
		BasicRecordObject bro = (BasicRecordObject)beanToBuild;
//		bro.caseSensitive = this.caseSensitive;
		bro.isnew = this.isnew;
		bro.oid = this.oid;
		bro.fieldSet = this.fieldSet;
		Class<?> c = beanToBuild.getClass();
		while (c != null) {
Log.trace(c.getName());
			if (c.equals(BasicRecordObject.class)) {
				break;
			}
			Method[] m = c.getDeclaredMethods();
			for (int i=0;i<m.length;i++) {
				String name = m[i].getName();
				if (name.startsWith("set")) {
					if (caseSensitive==false)name = name.toUpperCase();
					Class<?>[] param = m[i].getParameterTypes();
					if (param.length==1) {
Log.trace("found setter:"+name);
						String fName = name.substring(3,4).toLowerCase() + name.substring(4);
						String mfname=null;
						if (caseSensitive) {
							mfname=fName;
						}
						else {
							fName = fName.toUpperCase();
							Iterator<String> it = fieldSet.keySet().iterator();
							while (it.hasNext()) {
								String tmp = (String)it.next();
								if (tmp != null) {
									if (tmp.equalsIgnoreCase(fName)) {
										mfname=tmp;
										break;
									}
								}
							}
						}
						if (mfname==null) continue;
						Object value[] = new Object[1];
						value[0]= fieldSet.get(mfname);
						if (value[0] != null) {
							Class<?> com =param[0].getComponentType();
							Class<?>[] interfaces = param[0].getInterfaces();
							boolean isArray = false;
							if (com != null) {
								interfaces = com.getInterfaces();
								isArray = true;
							}
							boolean isIRecordElement = false;
							for (int j=0;j<interfaces.length;j++) {
								Class<?> i_f = interfaces[j];
								if (i_f.equals(IRecordElement.class)) {
									isIRecordElement = true;
									break;
								}
							}
							try {
								if (isIRecordElement) {
									IRecordElement helper = null;
									if (isArray) {
										helper = (IRecordElement)com.newInstance();
										value[0] = helper.parseArrayInput(value[0]);
									}
									else {
										helper = (IRecordElement)param[0].newInstance();
										helper.setRecordElementValue(value[0]);
										value[0] = helper;
									}
								}
								m[i].invoke(beanToBuild,value);
								Log.trace("setting field "+fName+" value "+value[0]+" in method "+name+":OK");
							}
							catch (IllegalAccessException iae) {
								Log.debug("skip setter set"+fName+" because of it is not public.");
							}
							catch (Exception e) {
								Log.trace("error setting field "+fName+" value "+value[0]+" in method "+name+". continue..");
							}
						}
					}
				}
			}
			c = c.getSuperclass();
		}
		return beanToBuild;
	}

}
