/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.exception;

import java.rmi.RemoteException;
import java.io.StringWriter;
import java.io.PrintWriter;

public class HandleException extends RemoteException 
{
	private static final long serialVersionUID = 1L;
	private Throwable ne;
	private String stTrace;
	
	/**
	 * Constructor
	 */
	public HandleException()
	{}
	
	/**
	 * Converts the stackTrace into string representation
	 * @param th throwable or any subclass derived from it.
	 * @return StackTrace string
	 */
	public static String generateStackTraceString(Throwable th)
	{
		StringWriter sw = new StringWriter();
		th.printStackTrace(new PrintWriter(sw));
		return sw.toString();
	}//end generateStackTraceString
	
	/**
	 * Overloaded constructor with argument string 
	 * assigned to BaseClass variable. 
	 * @param msg Message to be displayed 
	 */
	public HandleException(String msg)
	{
		super(msg);
	}//end HandleException
	
	/**
	 * Overloaded constructor with Throwable or any of it's subclass as an argument.
	 * @param th Throwable or any of it's subclass
	 */
	public HandleException(Throwable th)
	{
		this.ne = th;
		stTrace = generateStackTraceString(ne);
	}//end HandleException
	
	/**
	 * Overloaded constructor with a string message and a throwable or
	 * any of it's subclass.   
	 * @param msg The String message
	 * @param th Throwable or any of it's subclass
	 */
	public HandleException(String msg, Throwable th)
	{
		this(msg);
		this.ne = th;
		stTrace = generateStackTraceString(ne);
	}//end HandleException
	
	/**
	 * @return Throwable object. 
	 */
	public Throwable getNestedException()
	{
		return ne;
	}//end getNestedException
	
	/**
	 * Returns StackTrace object as string representation 
	 * @return StackTrace object as a string
	 */
	public String getStackTraceString()
	{
		if(ne == null)
			return null;
		
		StringBuffer sb = new StringBuffer();
		
		if(ne instanceof HandleException)
		{
			String str = ((HandleException)ne).getStackTraceString();
			sb.append(str);
		}
		
		sb.append(stTrace);
		return sb.toString();
	}//end getStackTraceString
	
	/**
	 * Retrieves the message from the exception.
	 * @return Message from the exception
	 */
	public String getMessage()
	{
		String superMsg = super.getMessage();
		
		if(getNestedException() == null)
			return superMsg;
		
		StringBuffer theMsg	= new StringBuffer();
		String nestedMsg = getNestedException().getMessage();
		
		if(superMsg != null)
			theMsg.append(superMsg).append(": ").append(nestedMsg);
		else
			theMsg.append(nestedMsg);
		return theMsg.toString();
	}//end getMessage
	
	/**
	 * @return String representation of all nested exceptions. 
	 */
	public String toString()
	{
		StringBuffer theMsg = new StringBuffer(super.toString());
		
		if(getNestedException() != null)
			theMsg.append(getNestedException());
		return theMsg.toString();
	}//end toString
	
}//end HandleException
