/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.*;

import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class FileBasedPropertyHandlerImpl extends PropertyHandlerBaseImpl
{
	static {
		FileBasedPropertyHandlerImpl impl =  new FileBasedPropertyHandlerImpl();
		handlers.put("jp.co.connectone.common.FileBasedPropertyHandlerImpl",impl);
		theHandler = impl;
	}
	
	protected boolean initDone=true;
	protected String propPath = "/var/connectOne/connectOne.ini";
	public void setInitArgs(Properties initArgs) throws Exception
	{
		// do nothing.
	}

	protected Properties getSystemProperties() throws Exception
	{
		if (initDone==false) throw new HandleException("need initialize with setInitArgs().");
		
		Properties l_propertiesObj = null;
		try {
//			String strDirectoryStr = ResourceBandleHandler.getString("notes.propertyfilename"); 
//			String l_strPath = strDirectoryStr + ResourceBandleHandler.getString("notes.filename");
			String l_strPath = System.getProperty("connectOne.ini",propPath);
Log.trace("l_strPath="+l_strPath);
			FileInputStream l_propFileObj = null;
			l_propertiesObj = new Properties(System.getProperties());
			l_propFileObj = new FileInputStream(l_strPath);
			l_propertiesObj.load(l_propFileObj);
		}
		catch(MissingResourceException l_missingResEx) {
			//Should be ERROR level (assume installing miss)
			throw new DataNotFound(l_missingResEx.getMessage());
		}
		catch(IOException l_ioExceptionObj) {
			//FileNotFound? should be ERROR level (assume installing miss)
			throw new DataNotFound(l_ioExceptionObj.getMessage());
		}
		return l_propertiesObj;
	}
}
