/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;

import jp.co.connectone.log.Log;

public abstract class ActiveActiveServerToolBaseImpl
{
	public static final int SAFETY=10;
	abstract protected boolean isToggle();
	abstract protected void setToggle(boolean tgl);
	abstract protected int getToggleCount();
	abstract protected void setToggleCount(int cnt);
	

	public void toggleOff()
	{
		setToggle(false);
	}

	public ActiveActiveServerToolBaseImpl()
	{
		super();
	}
	
	protected void flip()
	{
		setToggle(!isToggle());
	}

	protected boolean toggleOn()
	{
		Log.debug("enter toggle mode.");
		flip();
		boolean rc=true;
		if (toggleInclement()>=SAFETY) {
			rc=false;
			Log.warn("ActiveActiveServerToolBaseImpl:toggle counter("+getToggleCount()+") overflow SAFETY("+SAFETY+")");
		}
		return rc;
	}
	
	protected int toggleInclement()
	{
		int i = getToggleCount();
		setToggleCount(++i);
		return i;
	}

	protected void clearCount()
	{
		setToggleCount(0);
	}

	protected String getServerToConnect(String serverName, String serverName2)
	{
		String sn;
		if ((serverName2==null) || ("".equals(serverName2))) {
			Log.debug("getServerToConnect:serverName2 not set.");
			return serverName;
		}
		if (isToggle()) {
			Log.debug("getServerToConnect:toggle mode.");
			sn = serverName2;
		}
		else {
			sn = serverName;
		}
		return sn;
	}

}