/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.security;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.*;
import java.util.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.commandenv.CommandEnvSet;

public class OptionalSecurityWrapper
{
	public static void setArgsFromRequest(CommandEnvSet env, HttpServletRequest request)
	{
		request.setAttribute("utn", "");
		try {
			Log.debug("trying to set TermIdSecurityHandler parameter.");
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.TermIdSecurityHandler");
			Class<?>[] setTermIdArgsParameterTypes = {CommandEnvSet.class,HttpServletRequest.class};
			Method setTermIdArgs = termIdSequrityClass.getMethod("setTermIdArgs", setTermIdArgsParameterTypes);
			Object[] args = {env,request};
			setTermIdArgs.invoke(null, args);
		}
		catch (Exception e) {
			Log.debug("TermIdSecurityHandler parameter not set.");

		}
		try {
			Log.debug("trying to set BizBrowserIdSecurityHandler parameter.");
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.BizBrowserIdSecurityHandler");
			Class<?>[] setTermIdArgsParameterTypes = {CommandEnvSet.class,HttpServletRequest.class};
			Method setTermIdArgs = termIdSequrityClass.getMethod("setTermIdArgs", setTermIdArgsParameterTypes);
			Object[] args = {env,request};
			setTermIdArgs.invoke(null, args);
		}
		catch (Exception e) {
			Log.debug("BizBrowserIdSecurityHandler parameter not set.");

		}
	}
	
	public static String getErrorMessages(CommandEnvSet env)
	{
		String rc = "";
		try {
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.TermIdSecurityHandler");
			Class<?>[] getErrorMessageParameterTypes = {CommandEnvSet.class};
			Method getErrorMessage = termIdSequrityClass.getMethod("getErrorMessage", getErrorMessageParameterTypes);
			Object[] args = {env};
			rc = (String)getErrorMessage.invoke(null, args);
		}
		catch (Exception e) {

		}
		
		return rc;
	}
	
	public static boolean isValidParameters(CommandEnvSet env)
	{
		boolean rc = true;// must return true if there are no additional validation.
		try {
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.TermIdSecurityHandler");
			Class<?>[] isValidTerminalIdParameterTypes = {CommandEnvSet.class};
			Method isValidTerminalId = termIdSequrityClass.getMethod("isValidTerminalId", isValidTerminalIdParameterTypes);
			Object[] args = {env};
			Boolean valid = (Boolean)isValidTerminalId.invoke(null, args);
			rc = valid.booleanValue();
		}
		catch (Exception e) {

		}
		return rc;
	}
	public static void setOptionalSecurityParams(CommandEnvSet env, Hashtable<String,Object> authParams)
	{
		try {
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.TermIdSecurityHandler");
			Class<?>[] setTermIdToUserParameterTypes = {CommandEnvSet.class,Hashtable.class};
			Method setTermIdToUser = termIdSequrityClass.getMethod("setTermIdToUser", setTermIdToUserParameterTypes);
			Object[] args = {env,authParams};
			setTermIdToUser.invoke(null, args);
		}
		catch (Exception e) {

		}
		try {
			Class<?> termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.BizBrowserIdSecurityHandler");
			Class<?>[] setTermIdToUserParameterTypes = {CommandEnvSet.class,Hashtable.class};
			Method setTermIdToUser = termIdSequrityClass.getMethod("setTermIdToUser", setTermIdToUserParameterTypes);
			Object[] args = {env,authParams};
			setTermIdToUser.invoke(null, args);
		}
		catch (Exception e) {

		}
	}
}
