/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.commandenv;

import java.util.*;

import javax.servlet.http.HttpSession;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class CommandQueue
{
	private LinkedHashMap<String,CommandEnvSet> queue;
	private String lastKey;
	private HttpSession s;
	@SuppressWarnings("unchecked")
	public CommandQueue(HttpSession session)
	{
		s = session;
Log.debug("CommandQueue: sesion="+session);
		Object o = s.getAttribute("CommandQueue");
Log.debug("check the object 'CommandQueue' from session:"+o);
		if (o instanceof LinkedHashMap<?, ?>) {
			queue = (LinkedHashMap<String,CommandEnvSet>)o;
Log.debug("get queue from session:"+queue);
			lastKey = (String)s.getAttribute("lastKey");
Log.debug("get lastKey from session:"+lastKey);
			return;
		}
		queue = new LinkedHashMap<String,CommandEnvSet>();
		lastKey = null;
	}
	
	public CommandEnvSet getEnv(String key) throws HandleException
	{
Log.debug("getEnv:key="+key);
		if (key == null) {
Log.debug("return new CommandEnvSet");
			queue.clear();
			return new CommandEnvSet();
		}
		if (key.length()==0) {
Log.debug("return new CommandEnvSet");
			queue.clear();
			return new CommandEnvSet();
		}
		CommandEnvSet dst = null;
		
		CommandEnvSet oldEnv = (CommandEnvSet)queue.get(key);
		
		if (key.equalsIgnoreCase(lastKey)) {
Log.debug("return clone of last CommandEnvSet:"+oldEnv.getKey());
			return (CommandEnvSet)oldEnv.clone();
		}
		else if (oldEnv == null) {
Log.debug("oldEnv not found:assume it's the latest one");
			if (lastKey == null) {
Log.debug("return new CommandEnvSet");
				return new CommandEnvSet();
			}
			else {
				throw new HandleException("logic error on handling CommandQueue");
			}
		}
Log.debug("oldEnv found:assume some page-rewinds");
		LinkedHashMap<String,CommandEnvSet> nq = new LinkedHashMap<String,CommandEnvSet>();
		
		Iterator<String> keyList = queue.keySet().iterator();
		
		while (keyList.hasNext()) {
			String checkKey = (String)keyList.next();
			CommandEnvSet o = queue.get(checkKey);
			nq.put(checkKey,o);
			if (checkKey.equalsIgnoreCase(oldEnv.getKey())) {
				break;
			}
		}
		queue = nq;
		
Log.debug("return clone of old CommandEnvSet:"+oldEnv.getKey());
		dst = (CommandEnvSet)oldEnv.clone();
		
		return dst;
	}
	
	public void putEnv(CommandEnvSet env)
	{
		if (env == null) return;
Log.debug("putEnv:key="+env.getKey());
		String key = env.getKey();
		queue.put(key,env);
		lastKey = key;
Log.debug("no of queue entries:"+queue.size());
		
		s.setAttribute("CommandQueue",queue);
		s.setAttribute("lastKey",lastKey);
	}
	
	public void pushEnv()
	{
		CommandEnvSet[] s = new CommandEnvSet[1];
		s = (CommandEnvSet[])queue.values().toArray(s);
		CommandEnvSet env = s[s.length-1];
		String key = env.getKey();
		env = (CommandEnvSet)queue.get(key);
		env.pushed = true;
		
	}
	
	public String popEnv() throws HandleException
	{
		CommandEnvSet env = null;
		String key = null;
		for (Iterator<CommandEnvSet> it = queue.values().iterator();it.hasNext();) {
			env=it.next();
			if (env.pushed) {
				key = env.getKey();
			}
		}
		env = (CommandEnvSet)queue.get(key);
		env.pushed = false;
		return key;
	}
}
