/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.dbInfo;

public abstract class DbInfo
{
	protected String DB_URL;
	protected String DATA_PATH;
	protected String DATA_DIR;
	protected String DB_NAME;

	protected String DB_DRIVER;
	protected String DB_USER;
	protected String DB_PASS;
	protected String DB_GETUSER_SQL_V3;
	protected String DB_GETDEACTIVATE_USER_SQL_V3;
	protected String DB_SERVICE_UPDATE_SQL_V3;
	protected String DB_SERVICE_INSERT_SQL_V3;
	protected String DB_GETOID_SQL;
	protected String DB_GETTERMID_SQL;
	protected String DB_USER_INSERT_SQL;
	protected String DB_USER_UPDATE_SQL;
	protected String DB_USER_SETFLAG_SQL;
	protected String DB_EXCH_INSERT_SQL;
	protected String DB_TERM_INSERT_SQL;
	protected String DB_EXCH_UPDATE_SQL;
	protected String DB_TERM_UPDATE_SQL;

	public static DbInfo getInstance(DbType type)
	{
		DbInfo info = null;
		if (type==DbType.HSQLDB) {
			info = new HsqldbDbInfo();
		} else if (type==DbType.MSSQL) {
			info = new MSSqlDbInfo();
		} else if (type==DbType.MYSQL) {
			info = new MYSqlDbInfo();
		}

		return info;
	}

	public DbInfo()
	{
		super();
	}

	public String getDbUrl()
	{
		return DB_URL + DATA_PATH + DATA_DIR + DB_NAME;
	}

	public String getDbUrl(String serverName)
	{
		return DB_URL + serverName + DATA_DIR + DB_NAME;
	}

	public String getDB_DRIVER()
	{
		return DB_DRIVER;
	}

	public String getDB_GETDEACTIVATE_USER_SQL_V3()
	{
		return DB_GETDEACTIVATE_USER_SQL_V3;
	}

	public String getDB_EXCH_INSERT_SQL()
	{
		return DB_EXCH_INSERT_SQL;
	}

	public String getDB_EXCH_UPDATE_SQL()
	{
		return DB_EXCH_UPDATE_SQL;
	}

	public String getDB_GETOID_SQL()
	{
		return DB_GETOID_SQL;
	}

	public String getDB_GETTERMID_SQL()
	{
		return DB_GETTERMID_SQL;
	}

	public String getDB_GETUSER_SQL_V3()
	{
		return DB_GETUSER_SQL_V3;
	}

	public String getDB_SERVICE_UPDATE_SQL_V3()
	{
		return DB_SERVICE_UPDATE_SQL_V3;
	}

	public String getDB_SERVICE_INSERT_SQL_V3()
	{
		return DB_SERVICE_INSERT_SQL_V3;
	}

	public String getDB_USER()
	{
		return DB_USER;
	}

	public String getDB_PASS()
	{
		return DB_PASS;
	}

	public String getDB_URL()
	{
		return DB_URL;
	}

	public String getDATA_PATH()
	{
		return DATA_PATH;
	}

	public String getDATA_DIR()
	{
		return DATA_DIR;
	}

	public String getDB_NAME()
	{
		return DB_NAME;
	}

	public String getDB_USER_INSERT_SQL()
	{
		return DB_USER_INSERT_SQL;
	}

	public String getDB_USER_UPDATE_SQL()
	{
		return DB_USER_UPDATE_SQL;
	}

	public String getDB_USER_SETFLAG_SQL()
	{
		return DB_USER_SETFLAG_SQL;
	}

	public String getDB_TERM_INSERT_SQL()
	{
		return DB_TERM_INSERT_SQL;
	}

	public String getDB_TERM_UPDATE_SQL()
	{
		return DB_TERM_UPDATE_SQL;
	}

}
