/**
 * Copyright (C) 2006/05/22 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webproxy.ui.action;

import javax.servlet.http.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.commandenv.CommandEnvSet;
import org.apache.struts.action.*;

/**
 * @author amanot
 *
 */
public class ServiceMenuAction extends BaseAction
{

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#setArgs()
	 */
	protected void setArgs(CommandEnvSet env,DynaActionForm form)
	{
		String code = form.getString("sc");
		if (code!=null)if (code.length()>0)env.put("sc",code);
		clearCommandArgs(env);
	}
	
	private void clearCommandArgs(CommandEnvSet env)
	{
		env.put("date",null);
		env.put("cmd",null);
		env.put("fc",null);
		env.put("fidx",null);
		env.put("midx",null);
		env.put("cp",null);
		env.put("eMailList",null);
		env.put("name",null);
		env.put("at",null);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#actionLogic(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward actionLogic(CommandEnvSet env,ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		String code = env.getString("sc");
		Log.debug("sc="+code);
		if (code.equalsIgnoreCase("c1v2s1")) {
			return mapping.findForward("nMenu");
		}
		if (code.equalsIgnoreCase("c1v2s2")) {
			return mapping.findForward("eMenu");
		}
		if (code.equalsIgnoreCase("c1v2s3")) {
			return mapping.findForward("pMenu");
		}
		if (code.equalsIgnoreCase("c1v2s4")) {
			return mapping.findForward("rMenu");
		}
		if (code.equalsIgnoreCase("c1v2s5")) {
			return mapping.findForward("wMenu");
		}
		if (code.equalsIgnoreCase("c1v2s6")) {
			return mapping.findForward("fMenu");
		}
		if (code.equalsIgnoreCase("setting")) {
			return mapping.findForward("setting");
		}
		if (code.equalsIgnoreCase("simple")) {
			return mapping.findForward("customise");
		}
		if (code.equalsIgnoreCase("logout")) {
			return mapping.findForward("logout");
		}
		
		return mapping.findForward("error");
	}

}
