package jp.co.connectone.webproxy.ui.action;

import java.util.*;

import javax.servlet.http.*	;

import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.commandenv.*;
import jp.co.connectone.webapps.tools.*;
import jp.co.connectone.webapps.security.OptionalSecurityWrapper;
import jp.co.connectone.webproxy.ui.logic.*;

import org.apache.log4j.*;
import org.apache.struts.action.*;

/**
 * @author amanot
 *
 */
public abstract class BaseAction extends Action {
	protected static final Controler ctrl=Controler.getInstance();
	protected static int maxAllowedPasswordMiss=3;

	static
	{
		try {
			Properties prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.webproxy.ui.action.BaseAction");
			String tmp = prop.getProperty("maxAllowedPasswordMiss", "3");
			maxAllowedPasswordMiss = Integer.parseInt(tmp);
		}
		catch (Exception e) {
			// level ERROR : install or setting
			Log.fatal("error on getting properties on class-static",e);
		}
	}
	protected ActionForward errorReturn(HttpServletRequest request,ActionForward rc,Throwable t)
	{
		if (request==null) return rc;
		if (t==null) return rc;
		String[] stacks = new String[11];
		stacks[0] = t.getClass().getName() + " : " + t.getMessage();
		ActionMessages errors = new ActionMessages();
		StackTraceElement[] ste = t.getStackTrace();
		if (ste != null) {
			for (int i=0;(i<10)&&(i<ste.length);i++) {
				stacks[i+1] = ste[i].toString();
			}
			ActionMessage mess =  new ActionMessage("error.stacks",stacks);
			errors.add("error.exception.stacks",mess);
			saveErrors(request, errors);
		}

		return rc;
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
	{
		try {
			return execute2(mapping,form,request,response);
		}
		finally {
			NDC.remove();// for multiple session-id in one line problem on log.
		}
	}

	/* ( Javadoc)
	 * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ActionForward execute2(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
	{
		HttpSession session=null;
		CommandEnvSet env = null;

		DynaActionForm fm=(DynaActionForm)form;

		if(request.getAttribute("FilterException") != null){
			return mapping.findForward("timeout");
		}

		session = request.getSession(true);
		NDC.push(session.getId());

		String key = (String)fm.get("key");
		if (key==null) {
			key = (String)request.getAttribute("key");
		}
		else if (key.length()==0) {
			key = (String)request.getAttribute("key");
		}
		CommandQueue q = new CommandQueue(session);
		try {
			env = q.getEnv(key);
		} catch (HandleException he) {
			Log.error("",he);
			NDC.pop();
			return errorReturn(request,mapping.findForward("envError"),he);
		}
		OptionalSecurityWrapper.setArgsFromRequest(env, request);
		setArgs(env,fm);
		String pushPop = (String)fm.get("pp");
		if (pushPop.equalsIgnoreCase("push")) {
			push(q);
		}
		else if (pushPop.equalsIgnoreCase("pop")) {
			try {
				key = pop(q);
				env = q.getEnv(key);
			} catch (HandleException he) {
				Log.error("",he);
				NDC.pop();
				return errorReturn(request,mapping.findForward("envError"),he);
			}
		}

		ActionForward rc = null;
		try {
			if (doAuth(env)==false) {
				Log.debug("imode2 check:remove exm to session.");
				session.removeAttribute("exm");
				return mapping.findForward("authError");
			}

			rc = actionLogic(env,mapping, fm, request, response);
		}
		catch (Exception e) {
			Log.error("",e);
			NDC.pop();
			return errorReturn(request,mapping.findForward("error"),e);
		}
		Date d = (Date)request.getAttribute("date");
		if (d != null) {
			DateControler dc = new DateControler(d);
			request.setAttribute("dateParam",dc);
		}
		session = request.getSession(false);
		if (session != null) {
			q.putEnv(env);
		}

		request.setAttribute("key",env.getKey());
		NDC.pop();
		return rc;
	}

	protected abstract void setArgs(CommandEnvSet env,DynaActionForm form);
	protected abstract ActionForward actionLogic(CommandEnvSet env,ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception;

	protected boolean doAuth(CommandEnvSet env) throws Exception
	{
		return true;
	}

	protected void push(CommandQueue q)
	{
		q.pushEnv();
	}

	protected String pop(CommandQueue q) throws HandleException
	{
		return q.popEnv();
	}

	protected String[] makeArray(String srcStr)
	{
		srcStr = srcStr.trim();
		StringTokenizer toStr = new StringTokenizer(srcStr,",");

		ArrayList<String> ar = new ArrayList<String>();
		while (toStr.hasMoreElements()) {
			String token = toStr.nextToken().trim();
			if (token.length() > 0)
				ar.add(token);
		}
		if(ar.size() == 0) return new String[0];

		String[] to = ar.toArray(new String[0]);

		return to;
	}
}
