package jp.co.connectone.webproxy.ui.DTOParseHelper;

import java.util.*;

import jp.co.connectone.eai.exch2k.store.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.pim.ScheduleParseHelper;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.webapps.helpers.WebScheduleParseHelper;

public class WebExch2kScheduleParseHelper extends WebScheduleParseHelper implements IRecordObject
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public MailAddress getOrganizer() {
		return ((Exch2kScheduleDTO)schedule).getOrganizer();
	}

	public void setOrganizer(MailAddress organizer) {
		((Exch2kScheduleDTO)schedule).setOrganizer(organizer);
	}
	
	public long getReminderoffset() {
		return ((Exch2kScheduleDTO)schedule).getReminderoffset();
	}

	public void setReminderoffset(long reminderoffset) {
		((Exch2kScheduleDTO)schedule).setReminderoffset(reminderoffset);
	}
	
	public long getReminderoffsetMinutes() {
		long offset = ((Exch2kScheduleDTO)schedule).getReminderoffset();
		return offset / 60;
	}

	public void setReminderoffsetMinutes(long minutes) {
		((Exch2kScheduleDTO)schedule).setReminderoffset(minutes * 60);
	}

	/**
	 * @return bCC ߂܂B
	 */
	public MailAddress[] getBCC()
	{
		return ((Exch2kScheduleDTO)schedule).getBcc();
	}

	/**
	 * @param bcc ݒ肷 bCCB
	 */
	public void setBCC(MailAddress[] bcc)
	{
		((Exch2kScheduleDTO)schedule).setBcc(bcc);
	}

	/**
	 * @return cC ߂܂B
	 */
	public MailAddress[] getCC()
	{
		return ((Exch2kScheduleDTO)schedule).getCc();
	}

	/**
	 * @param cc ݒ肷 cCB
	 */
	public void setCC(MailAddress[] cc)
	{
		((Exch2kScheduleDTO)schedule).setCc(cc);
	}

	public void setCC(String[] toList)
	{
		if (toList==null) {
			((Exch2kScheduleDTO)schedule).setCc(null);
		}
		else {
			MailAddress[] to = new MailAddress[toList.length];
			for (int i=0;i<toList.length;i++) {
				to[i] = new MailAddress(toList[i]);
			}
			((Exch2kScheduleDTO)schedule).setCc(to);
		}
	}

	/**
	 * @return tO ߂܂B
	 */
	public MailAddress[] getTO()
	{
		return ((Exch2kScheduleDTO)schedule).getTo();
	}

	/**
	 * @param to ݒ肷 tOB
	 */
	public void setTO(MailAddress[] to)
	{
		((Exch2kScheduleDTO)schedule).setTo(to);
	}

	public void setTO(String[] toList)
	{
		if (toList==null) {
			((Exch2kScheduleDTO)schedule).setTo(null);
		}
		else {
			MailAddress[] to = new MailAddress[toList.length];
			for (int i=0;i<toList.length;i++) {
				to[i] = new MailAddress(toList[i]);
			}
			((Exch2kScheduleDTO)schedule).setTo(to);
		}
	}

    public Collection<MailAddress> getTOCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = ((Exch2kScheduleDTO)schedule).getTo();
    	if (array==null) return list;
    	for (int i=0;i<array.length;i++) {
    		list.add(getEmailId(array[i]));
    	}
    	return list;
    }

    public Collection<MailAddress> getCCCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = ((Exch2kScheduleDTO)schedule).getCc();
    	if (array==null) return list;
    	for (int i=0;i<array.length;i++) {
    		list.add(getEmailId(array[i]));
    	}
    	return list;
    }

    public Collection<MailAddress> getBCCCollection()
    {
    	ArrayList<MailAddress> list = new ArrayList<MailAddress>();
    	MailAddress[] array = ((Exch2kScheduleDTO)schedule).getBcc();
    	if (array==null) return list;
    	for (int i=0;i<array.length;i++) {
    		list.add(getEmailId(array[i]));
    	}
    	return list;
    }
	
	public WebExch2kScheduleParseHelper()
	{
		initDTO();
	}
	
	public WebExch2kScheduleParseHelper(ScheduleParseHelper org)
	{
		super(org);
	}

	private void initDTO()
	{
		schedule = new Exch2kScheduleDTO();
		schedule.setBody("");
		schedule.setStartDate(new Date());
		schedule.setEndDate(new Date());
		schedule.setLocation("");

		schedule.setSubject("");
		String[] l_byteFilestream = new String[1];
		String bodyStr = new String("");
		l_byteFilestream[0] = bodyStr;
	}
	private MailAddress getEmailId(MailAddress eMailAddress)
	{
		Log.debug("getEmailId(): Entering Method ");
		if (eMailAddress==null) return new MailAddress("");
		String eMailId = eMailAddress.getRawAddress();
		if (eMailId==null) return new MailAddress("");
	 	String notesId = "";
//	  	String fnln=null;
//      	String nDomain=null;
      	String internetId = eMailId;
      	Log.debug(" getEmailId(): E-Mail Id to process " + eMailId);

		// If the author name starts with CN= process the name and if lotus notes id check for "/"
      	if (eMailId.startsWith("CN=")) {
      		int atIndx = eMailId.indexOf('@');
      		if (atIndx != -1) eMailId = eMailId.substring(0, atIndx);
      		// Parse for "/"
         	StringTokenizer sParser = new StringTokenizer(eMailId,"/");
         	String sPart="";
         	// Rebuild the Id
        	while (sParser.hasMoreTokens()) {
	            sPart = sParser.nextToken();
//	            if (sPart.indexOf("CN=") != -1) fnln = sPart;
//	            if (sPart.indexOf("O=") != -1) nDomain = sPart;
	         	sPart = sPart.substring(sPart.indexOf("=")+1);
            	if (sParser.hasMoreTokens()) {
              		notesId = notesId+sPart+"/";
            	}
            	else {
                	//internet name or alias
                	notesId = notesId+sPart;
            	}
          	}
        	internetId=notesId;
	   }
      	eMailAddress.setRawAddress(internetId);
      	Log.debug(" getEmailId(): before leaving internet Id:   " + eMailAddress);
       return eMailAddress;

    }	
}
