/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.BodyType;
import com.microsoft.schemas.exchange.services._2006.types.BodyTypeType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.TaskType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.eai.exchews.ews.UpdateItemMap;
import jp.co.connectone.eai.exchews.store.EAIExchewsBase;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.eai.exchews.store.ExchewsTaskDTO;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.ITaskDTO;
import jp.co.connectone.store.pim.ITaskStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;

public class ExchewsTaskStoreImpl
extends EAIExchewsBase
implements ITaskStore {
    public static final List<String> SEARCH_FIELDS = IEwsSearchFormula.ALL_PROPERTIES;
    public static final IStoreID storeID = new SimpleStoreID(ExchewsTaskStoreImpl.class.getName());
    public static final String storeName = "Exchange EWS task store";
    protected static final String itemType = "IPM.Task";

    public ExchewsTaskStoreImpl() {
        this.includeMimeContent = false;
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new ExchewsServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        DistinguishedFolderIdType src = new DistinguishedFolderIdType();
        switch (type) {
            case 1: {
                src.setId(EAIExchewsBase.taskElement);
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        folder = (IFolderIndex)this.populateFolder(new ExchewsFolderIndex(src)).getOid();
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected UnindexedFieldURIType getDateField() {
        return UnindexedFieldURIType.ITEM_DATE_TIME_CREATED;
    }

    public IObjectIndex createNewTask(IAccountData acc, ITaskDTO dto) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        super.setAccountData(acc);
        TaskType item = null;
        try {
            item = ExchewsTaskDTO.convertToTaskType(dto);
        }
        catch (Exception e) {
            Log.error((String)"TaskDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        item = super.createItem(EAIExchewsBase.taskElement, (ItemType)item);
        ExchewsObjectIndex oid = new ExchewsObjectIndex(item.getItemId());
        return oid;
    }

    public void deleteTask(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        this.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        super.delete(oid);
    }

    public ITaskDTO[] getAllTasks(IAccountData acc) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        super.setAccountData(acc);
        ExchewsTaskDTO[] l_taskDtoArray = new ExchewsTaskDTO[]{};
        ISearchDestination dest = this.getPresetDestination(acc, 1);
        List<String> fieldsToGet = SEARCH_FIELDS;
        List<Object> items = new ArrayList();
        try {
            items = super.getList(dest, fieldsToGet);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        ArrayList<ExchewsTaskDTO> rc = new ArrayList<ExchewsTaskDTO>();
        for (ItemType itemType : items) {
            try {
                ExchewsTaskDTO dto = ExchewsTaskDTO.convertFromTaskType((TaskType)itemType);
                rc.add(dto);
                itemType.isHasAttachments().booleanValue();
            }
            catch (Exception e) {
                Log.debug((String)"error on converting MessageType to ExchewsMailDTO. skip one data..", (Throwable)e);
            }
        }
        return rc.toArray(l_taskDtoArray);
    }

    public ITaskDTO getTaskByOID(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        super.setAccountData(acc);
        TaskType task = (TaskType)this.getItem(this.getPresetDestination(acc, 1), (ItemIdType)oid.getIndex());
        ExchewsTaskDTO rc = null;
        try {
            rc = ExchewsTaskDTO.convertFromTaskType(task);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"mail convert error", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public ITaskDTO[] getTasksByDate(IAccountData acc, Date dateObj) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        return null;
    }

    public IObjectIndex updateTask(IAccountData acc, ITaskDTO dto) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        if (dto == null) {
            throw new IncorrectData("dto null.");
        }
        if (dto.getOid() == null) {
            throw new IncorrectData("oid in updateItem should not be null");
        }
        super.setAccountData(acc);
        IObjectIndex oid = dto.getOid();
        super.updateItem((ItemIdType)oid.getIndex(), this.generateUpdateMap(dto));
        return oid;
    }

    protected UpdateItemMap generateUpdateMap(ITaskDTO dto) throws IncorrectData {
        UpdateItemMap map = new UpdateItemMap();
        ItemType item = null;
        try {
            item = new ItemType();
            item.setSubject(dto.getSubject());
            map.put(UnindexedFieldURIType.ITEM_SUBJECT, item);
            item = new ItemType();
            BodyType value = new BodyType();
            value.setBodyType(BodyTypeType.TEXT);
            value.setValue(dto.getBody());
            item.setBody(value);
            map.put(UnindexedFieldURIType.ITEM_BODY, item);
        }
        catch (Exception e) {
            Log.error((String)"TaskDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        return map;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteTask(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return null;
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return null;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return null;
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        return null;
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return null;
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        if (data.isNew()) {
            return this.createNewTask(acc, (ITaskDTO)data);
        }
        return this.updateTask(acc, (ITaskDTO)data);
    }

    @Override
    protected TargetFolderIdType getTargetFolder() {
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(EAIExchewsBase.taskElement);
        target.setDistinguishedFolderId(id);
        return target;
    }
}

