/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderType;
import com.microsoft.schemas.exchange.services._2006.types.BodyType;
import com.microsoft.schemas.exchange.services._2006.types.BodyTypeType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.FolderType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;
import com.microsoft.schemas.exchange.services._2006.types.TargetFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.eai.exchews.ews.UpdateItemMap;
import jp.co.connectone.eai.exchews.store.EAIExchewsBase;
import jp.co.connectone.eai.exchews.store.ExchewsFolderIndex;
import jp.co.connectone.eai.exchews.store.ExchewsFolderMetadata;
import jp.co.connectone.eai.exchews.store.ExchewsMemoDTO;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.store.ExchewsServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.IMemoDTO;
import jp.co.connectone.store.pim.IMemoStore;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;

public class ExchewsMemoStoreImpl
extends EAIExchewsBase
implements IMemoStore {
    public static final List<String> SEARCH_FIELDS = IEwsSearchFormula.ALL_PROPERTIES;
    public static final IStoreID storeID = new SimpleStoreID(ExchewsMemoStoreImpl.class.getName());
    public static final String storeName = "Exchange EWS memo store";
    protected static final String itemType = "IPM.StickyNote";

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new ExchewsServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IMemoDTO[] getAllMemos(IAccountData acc) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        super.setAccountData(acc);
        ExchewsMemoDTO[] l_memoDtoArray = new ExchewsMemoDTO[]{};
        ISearchDestination dest = this.getPresetDestination(acc, 1);
        List<String> fieldsToGet = SEARCH_FIELDS;
        List<Object> items = new ArrayList();
        try {
            items = super.getList(dest, fieldsToGet);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        ArrayList<ExchewsMemoDTO> rc = new ArrayList<ExchewsMemoDTO>();
        for (ItemType itemType : items) {
            try {
                ExchewsMemoDTO dto = ExchewsMemoDTO.convertFromMemoItemType(itemType);
                rc.add(dto);
                itemType.isHasAttachments().booleanValue();
            }
            catch (Exception e) {
                Log.debug((String)"error on converting MessageType to ExchewsMailDTO. skip one data..", (Throwable)e);
            }
        }
        return rc.toArray(l_memoDtoArray);
    }

    public IMemoDTO[] getMemosByDate(IAccountData acc, Date dateObj) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        throw new UnsupportedOperationException("getMemosByDate not yet supported.");
    }

    public IMemoDTO getMemoByOID(IAccountData acc, IObjectIndex oid) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        super.setAccountData(acc);
        ItemType item = this.getItem(this.getPresetDestination(acc, 1), (ItemIdType)oid.getIndex());
        ExchewsMemoDTO rc = null;
        try {
            rc = ExchewsMemoDTO.convertFromMemoItemType(item);
            if (rc != null && item.isHasAttachments().booleanValue()) {
                rc.convertAndSetEWSAttachments(this.getAttachments(item));
            }
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"memo convert error", (Throwable)e);
            throw new HandleException((Throwable)e);
        }
        return rc;
    }

    public IObjectIndex createNewMemo(IAccountData acc, IMemoDTO dto) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        super.setAccountData(acc);
        MessageType item = null;
        try {
            item = ExchewsMemoDTO.convertToMessageType(dto);
        }
        catch (Exception e) {
            Log.error((String)"MemoDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        item = super.createItem(EAIExchewsBase.memoElement, (ItemType)item);
        ExchewsObjectIndex oid = new ExchewsObjectIndex(item.getItemId());
        return oid;
    }

    public IObjectIndex updateMemo(IAccountData acc, IMemoDTO dto) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, UpdateFailed, HandleException {
        if (dto == null) {
            throw new IncorrectData("dto null.");
        }
        if (dto.getOid() == null) {
            throw new IncorrectData("oid in updateItem should not be null");
        }
        super.setAccountData(acc);
        IObjectIndex oid = dto.getOid();
        super.updateItem((ItemIdType)oid.getIndex(), this.generateUpdateMap(dto));
        return oid;
    }

    protected UpdateItemMap generateUpdateMap(IMemoDTO dto) throws IncorrectData {
        UpdateItemMap map = new UpdateItemMap();
        ItemType item = null;
        try {
            item = new ItemType();
            item.setSubject(dto.getSubject());
            map.put(UnindexedFieldURIType.ITEM_SUBJECT, item);
            item = new ItemType();
            BodyType value = new BodyType();
            value.setBodyType(BodyTypeType.TEXT);
            value.setValue(dto.getBody());
            item.setBody(value);
            map.put(UnindexedFieldURIType.ITEM_BODY, item);
        }
        catch (Exception e) {
            Log.error((String)"MemoDTO convert error.", (Throwable)e);
            throw new IncorrectData(e.getMessage());
        }
        return map;
    }

    public void deleteMemo(IAccountData acc, IObjectIndex oid) throws IncorrectData, DeleteFailed, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        this.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        super.delete(oid);
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteMemo(acc, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAllMemos(acc);
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        super.setAccountData(acc);
        ExchewsFolderIndex idx = (ExchewsFolderIndex)dest.getFolder();
        BaseFolderIdType src = (BaseFolderIdType)idx.getIndex();
        List<BaseFolderType> folders = super.getAllSubFolders(src, 0);
        ArrayList<ExchewsFolderMetadata> rc = new ArrayList<ExchewsFolderMetadata>();
        ExchewsFolderMetadata[] a = new ExchewsFolderMetadata[]{};
        for (BaseFolderType folder : folders) {
            rc.add(ExchewsFolderMetadata.convertFromEWSFolderType((FolderType)folder));
        }
        return rc.toArray(a);
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getMemoByOID(acc, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        throw new UnsupportedOperationException("search not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        throw new UnsupportedOperationException("searchByDate not yet supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = null;
        rc = data.isNew() ? this.createNewMemo(acc, (IMemoDTO)data) : this.updateMemo(acc, (IMemoDTO)data);
        return rc;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((IAccountData)((PasswordBasedAccountDataImpl)acc));
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        DistinguishedFolderIdType src = new DistinguishedFolderIdType();
        switch (type) {
            case 1: {
                src.setId(EAIExchewsBase.memoElement);
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        folder = (IFolderIndex)this.populateFolder(new ExchewsFolderIndex(src)).getOid();
        return new BasicSearchDestination(db, folder);
    }

    @Override
    protected UnindexedFieldURIType getDateField() {
        return UnindexedFieldURIType.ITEM_DATE_TIME_CREATED;
    }

    @Override
    protected TargetFolderIdType getTargetFolder() {
        TargetFolderIdType target = new TargetFolderIdType();
        DistinguishedFolderIdType id = new DistinguishedFolderIdType();
        id.setId(EAIExchewsBase.memoElement);
        target.setDistinguishedFolderId(id);
        return target;
    }
}

