/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;
import java.util.Date;
import jp.co.connectone.eai.exchews.store.ExchewsItemBase;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.store.pim.IMemoDTO;

public class ExchewsMemoDTO
extends ExchewsItemBase
implements IMemoDTO {
    private static final long serialVersionUID = 1L;
    protected String lastModifiedName;
    protected Date date;

    public ExchewsMemoDTO() {
        this.itemClass = "IPM.StickyNote";
    }

    public void copy(IMemoDTO src) {
    }

    public Date getDate() {
        return this.date;
    }

    @Deprecated
    public String getSenderName() {
        return this.lastModifiedName;
    }

    @Deprecated
    public String getTid() {
        return null;
    }

    public void setDate(Date createDate) {
        this.date = createDate;
    }

    @Deprecated
    public void setSenderName(String senderName) {
        this.lastModifiedName = senderName;
    }

    @Deprecated
    public void setTid(String tid) {
    }

    public static MessageType convertToMessageType(IMemoDTO dto) throws Exception {
        MessageType rc = new MessageType();
        if (!(dto instanceof ExchewsMemoDTO)) {
            throw new IllegalArgumentException("dto must be instance of ExchewsMemoDTO");
        }
        ExchewsMemoDTO memo = (ExchewsMemoDTO)dto;
        memo.setBody(String.valueOf(memo.getSubject()) + "\n" + memo.getBody());
        ExchewsMemoDTO.convertToItemType((ItemType)rc, memo);
        return rc;
    }

    public static ExchewsMemoDTO convertFromMemoItemType(ItemType msg) throws Exception {
        if (msg == null) {
            return null;
        }
        ExchewsMemoDTO rc = new ExchewsMemoDTO();
        ExchewsMemoDTO.convertFromItemType(rc, msg);
        if (msg.getLastModifiedName() != null) {
            rc.setSenderName(msg.getLastModifiedName());
        }
        if (msg.getDateTimeCreated() != null) {
            rc.setDate(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeCreated()));
        }
        rc.setBeanData();
        return rc;
    }

    public String getLastModifiedName() {
        return this.lastModifiedName;
    }

    public void setLastModifiedName(String lastModifiedName) {
        this.lastModifiedName = lastModifiedName;
    }
}

