/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.ArrayOfRecipientsType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;
import java.util.Date;
import jp.co.connectone.eai.exchews.ews.IEwsDTOType;
import jp.co.connectone.eai.exchews.store.ExchewsItemBase;
import jp.co.connectone.eai.exchews.util.ExchEWSImportance;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.MailAddress;

public class ExchewsMailDTO
extends ExchewsItemBase
implements IMailDTO,
IEwsDTOType {
    private static final long serialVersionUID = 1L;
    protected MailAddress sender;
    protected MailAddress[] toRecipients;
    protected MailAddress[] ccRecipients;
    protected MailAddress[] bccRecipients;
    protected boolean isReadReceiptRequested;
    protected boolean isDeliveryReceiptRequested;
    protected byte[] conversationIndex;
    protected String conversationTopic;
    protected MailAddress from;
    protected String internetMessageId;
    protected boolean read;
    protected boolean isResponseRequested;
    protected String references;
    protected MailAddress replyTo;
    protected MailAddress receivedBy;
    protected MailAddress receivedRepresenting;
    protected String[] MailItemNameList = new String[]{"sender", "toRecipients", "ccRecipients", "bccRecipients", "isReadReceiptRequested", "isDeliveryReceiptRequested", "conversationIndex", "conversationTopic", "from", "internetMessageId", "isRead", "isResponseRequested", "references", "replyTo", "receivedBy", "receivedRepresenting"};
    protected AttachmentDTO[] attachments;

    public ExchewsMailDTO(IMailDTO dto) {
        if (dto == null) {
            return;
        }
        this.setHeaderDTO(dto.getHeader());
        this.body = dto.getBody();
        ((ExchewsItemBase)this).attachments = dto.getAttachments();
    }

    public ExchewsMailDTO(HeaderDTO header) {
        this.setHeaderDTO(header);
    }

    public ExchewsMailDTO() {
    }

    public void setHeaderDTO(HeaderDTO header) {
        if (header != null) {
            this.copyHeader(header);
        }
    }

    public HeaderDTO getHeader() {
        return this.generateHeader();
    }

    public void copyExch2kElements2Header() {
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public void setSender(MailAddress sender) {
        this.sender = sender;
    }

    public boolean isReadReceiptRequested() {
        return this.isReadReceiptRequested;
    }

    public void setReadReceiptRequested(boolean isReadReceiptRequested) {
        this.isReadReceiptRequested = isReadReceiptRequested;
    }

    public byte[] getConversationIndex() {
        return this.conversationIndex;
    }

    public void setConversationIndex(byte[] conversationIndex) {
        this.conversationIndex = conversationIndex;
    }

    public String getConversationTopic() {
        return this.conversationTopic;
    }

    public void setConversationTopic(String conversationTopic) {
        this.conversationTopic = conversationTopic;
    }

    public String getInternetMessageId() {
        return this.internetMessageId;
    }

    public void setInternetMessageId(String internetMessageId) {
        this.internetMessageId = internetMessageId;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public MailAddress getReceivedBy() {
        return this.receivedBy;
    }

    public void setReceivedBy(MailAddress receivedBy) {
        this.receivedBy = receivedBy;
    }

    private HeaderDTO generateHeader() {
        HeaderDTO h = new HeaderDTO();
        h.setHeaderBCC(this.bccRecipients);
        h.setHeaderCC(this.ccRecipients);
        h.setHeaderFrom(this.from);
        h.setHeaderReceivedDate(this.dateTimeReceived);
        h.setHeaderReplyTo(this.replyTo);
        h.setHeaderSendDate(this.dateTimeSent);
        h.setHeaderSize(this.size);
        h.setHeaderSubject(this.subject);
        h.setHeaderTo(this.toRecipients);
        ItemIdType id = (ItemIdType)this.oid.getIndex();
        h.setHeaderUIDL(id.getId());
        h.setOid(this.oid);
        return h;
    }

    private void copyHeader(HeaderDTO h) {
        this.bccRecipients = h.getHeaderBCC();
        this.ccRecipients = h.getHeaderCC();
        this.toRecipients = h.getHeaderTo();
        this.from = h.getHeaderFrom();
        switch (h.getHeaderPriority()) {
            case 0: {
                this.importance = ExchEWSImportance.NORMAL;
                break;
            }
            case 1: {
                this.importance = ExchEWSImportance.HIGH;
                break;
            }
            case -1: {
                this.importance = ExchEWSImportance.LOW;
            }
        }
        this.replyTo = h.getHeaderReplyTo();
        this.subject = h.getHeaderSubject();
        this.toRecipients = h.getHeaderTo();
    }

    public static ExchewsMailDTO convertFromMessageType(MessageType msg) throws Exception {
        ArrayOfRecipientsType re_ar;
        ArrayOfRecipientsType bcc_ar;
        ArrayOfRecipientsType cc_ar;
        ArrayOfRecipientsType to_ar;
        if (msg == null) {
            return null;
        }
        ExchewsMailDTO rc = new ExchewsMailDTO();
        ExchewsMailDTO.convertFromItemType(rc, (ItemType)msg);
        if (msg.getSender() != null) {
            rc.setSender(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getSender().getMailbox()));
        }
        if ((to_ar = msg.getToRecipients()) != null) {
            rc.setTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(to_ar));
        }
        if ((cc_ar = msg.getCcRecipients()) != null) {
            rc.setCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(cc_ar));
        }
        if ((bcc_ar = msg.getBccRecipients()) != null) {
            rc.setBCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(bcc_ar));
        }
        rc.setConversationIndex(msg.getConversationIndex());
        rc.setConversationTopic(msg.getConversationTopic());
        if (msg.getFrom() != null) {
            rc.setFrom(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getFrom().getMailbox()));
        }
        rc.setInternetMessageId(msg.getInternetMessageId());
        rc.setRead(msg.isIsRead());
        if (msg.getReceivedBy() != null) {
            rc.setReceivedBy(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getReceivedBy().getMailbox()));
        }
        if ((re_ar = msg.getReplyTo()) != null) {
            rc.setReplyTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2SingleMailAddress(re_ar));
        }
        rc.setBeanData();
        return rc;
    }

    public static MessageType convertToMessageType(IMailDTO dto) throws Exception {
        int n;
        MessageType rc = new MessageType();
        ExchewsMailDTO mail = null;
        if (dto instanceof BasicMailDTO) {
            mail = new ExchewsMailDTO(dto);
        } else if (dto instanceof ExchewsMailDTO) {
            mail = (ExchewsMailDTO)dto;
        } else {
            throw new IllegalArgumentException("dto must be instance of ExchewsMailDTO or BasicMailDto");
        }
        ExchewsMailDTO.convertToItemType((ItemType)rc, mail);
        MailAddress[] tos = dto.getTo();
        ArrayOfRecipientsType rArry = new ArrayOfRecipientsType();
        if (tos != null) {
            MailAddress[] mailAddressArray = tos;
            n = tos.length;
            int n2 = 0;
            while (n2 < n) {
                MailAddress to = mailAddressArray[n2];
                rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(to));
                ++n2;
            }
        }
        if (rArry.getMailbox().size() > 0) {
            rc.setToRecipients(rArry);
        }
        MailAddress[] ccs = dto.getCC();
        rArry = new ArrayOfRecipientsType();
        if (ccs != null) {
            MailAddress[] mailAddressArray = ccs;
            int n3 = ccs.length;
            n = 0;
            while (n < n3) {
                MailAddress cc = mailAddressArray[n];
                rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(cc));
                ++n;
            }
        }
        if (rArry.getMailbox().size() > 0) {
            rc.setCcRecipients(rArry);
        }
        MailAddress[] bccs = dto.getBCC();
        rArry = new ArrayOfRecipientsType();
        if (bccs != null) {
            MailAddress[] mailAddressArray = bccs;
            int n4 = bccs.length;
            int n5 = 0;
            while (n5 < n4) {
                MailAddress bcc = mailAddressArray[n5];
                rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(bcc));
                ++n5;
            }
        }
        if (rArry.getMailbox().size() > 0) {
            rc.setBccRecipients(rArry);
        }
        return rc;
    }

    public AttachmentDTO getAttachment(int number) {
        return this.attachments[number];
    }

    @Override
    public AttachmentDTO[] getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(AttachmentDTO[] attachments) {
        this.attachments = attachments;
    }

    public MailAddress[] getBCC() {
        return this.bccRecipients;
    }

    public MailAddress[] getCC() {
        return this.ccRecipients;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public String getMailBinary() {
        return null;
    }

    public int getNumberOfAttachments() {
        if (this.attachments == null) {
            return 0;
        }
        return this.attachments.length;
    }

    public int getPriority() {
        return 0;
    }

    public Date getReceivedDate() {
        return this.dateTimeReceived;
    }

    public MailAddress getReplyTo() {
        return this.replyTo;
    }

    public Date getSentDate() {
        return this.dateTimeSent;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public MailAddress[] getTo() {
        return this.toRecipients;
    }

    public void setBCC(MailAddress[] bcc) {
        this.bccRecipients = bcc;
    }

    public void setCC(MailAddress[] cc) {
        this.ccRecipients = cc;
    }

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public void setPriority(int priority) {
    }

    public void setReplyTo(MailAddress replyTo) {
        this.replyTo = replyTo;
    }

    public void setSentDate(Date date) {
        this.dateTimeSent = date;
    }

    @Override
    public void setSize(int size) {
    }

    public void setTo(MailAddress[] to) {
        this.toRecipients = to;
    }
}

