/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.AttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.BodyType;
import com.microsoft.schemas.exchange.services._2006.types.BodyTypeType;
import com.microsoft.schemas.exchange.services._2006.types.FileAttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.ItemAttachmentType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.SensitivityChoicesType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.co.connectone.eai.exchews.log.LogAspect;
import jp.co.connectone.eai.exchews.store.ExchewsObjectIndex;
import jp.co.connectone.eai.exchews.util.ExchEWSImportance;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.AttachmentDTO;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class ExchewsItemBase
extends BasicRecordObject {
    private static final long serialVersionUID = 1L;
    protected String itemClass;
    protected String subject;
    protected SENSITIVITY sensitivity;
    protected String body;
    protected AttachmentDTO[] attachments;
    protected List<ItemAttachmentType> ewsItemAttachments = null;
    protected Date dateTimeReceived;
    protected int size;
    protected ExchEWSImportance importance;
    protected boolean submitted;
    protected boolean draft;
    protected boolean fromMe;
    protected boolean resend;
    protected boolean unmodified;
    protected Date dateTimeSent;
    protected Date dateTimeCreated;
    protected boolean reminderIsSet;
    protected String reminderMinutesBeforeStart;
    protected String displayCc;
    protected String displayTo;
    protected boolean hasattachments;
    protected String culture;
    protected Date lastModifiedTime;
    protected String[] baseItemNameList = new String[]{"mimeContent", "itemId", "parentFolderId", "itemClass", "subject", "sensitivity", "body", "attachments", "dateTimeReceived", "size", "categories", "importance", "inReplyTo", "isSubmitted", "isDraft", "isFromMe", "isResend", "isUnmodified", "internetMessageHeaders", "dateTimeSent", "dateTimeCreated", "responseObjects", "reminderDueBy", "reminderIsSet", "reminderMinutesBeforeStart", "displayCc", "displayTo", "hasAttachments", "extendedProperty", "culture", "effectiveRights", "lastModifiedName", "lastModifiedTime"};
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public String getItemClass() {
        return this.itemClass;
    }

    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SENSITIVITY getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(SENSITIVITY sensitivity) {
        this.sensitivity = sensitivity;
    }

    public Date getDateTimeReceived() {
        return this.dateTimeReceived;
    }

    public void setDateTimeReceived(Date dateTimeReceived) {
        this.dateTimeReceived = dateTimeReceived;
    }

    public ExchEWSImportance getImportance() {
        return this.importance;
    }

    public void setImportance(ExchEWSImportance importance) {
        this.importance = importance;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isFromMe() {
        return this.fromMe;
    }

    public void setFromMe(boolean fromMe) {
        this.fromMe = fromMe;
    }

    public boolean isResend() {
        return this.resend;
    }

    public void setResend(boolean resend) {
        this.resend = resend;
    }

    public boolean isUnmodified() {
        return this.unmodified;
    }

    public void setUnmodified(boolean unmodified) {
        this.unmodified = unmodified;
    }

    public Date getDateTimeSent() {
        return this.dateTimeSent;
    }

    public void setDateTimeSent(Date dateTimeSent) {
        this.dateTimeSent = dateTimeSent;
    }

    public Date getDateTimeCreated() {
        return this.dateTimeCreated;
    }

    public void setDateTimeCreated(Date dateTimeCreated) {
        this.dateTimeCreated = dateTimeCreated;
    }

    public boolean isReminderIsSet() {
        return this.reminderIsSet;
    }

    public void setReminderIsSet(boolean reminderIsSet) {
        this.reminderIsSet = reminderIsSet;
    }

    public String getReminderMinutesBeforeStart() {
        return this.reminderMinutesBeforeStart;
    }

    public void setReminderMinutesBeforeStart(String reminderMinutesBeforeStart) {
        this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
    }

    public String getDisplayCc() {
        return this.displayCc;
    }

    public void setDisplayCc(String displayCc) {
        this.displayCc = displayCc;
    }

    public String getDisplayTo() {
        return this.displayTo;
    }

    public void setDisplayTo(String displayTo) {
        this.displayTo = displayTo;
    }

    public boolean isHasAttachments() {
        return this.hasattachments;
    }

    public void setHasAttachments(boolean hasattachments) {
        this.hasattachments = hasattachments;
    }

    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String[] getBaseItemNameList() {
        return this.baseItemNameList;
    }

    public void setBaseItemNameList(String[] baseItemNameList) {
        this.baseItemNameList = baseItemNameList;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public AttachmentDTO[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(AttachmentDTO[] attachments) {
        this.attachments = attachments;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void convertAndSetEWSAttachments(List<AttachmentType> attaches) {
        if (attaches == null) {
            return;
        }
        if (attaches.size() == 0) {
            return;
        }
        ArrayList<AttachmentDTO> arr = new ArrayList<AttachmentDTO>();
        for (AttachmentType attach : attaches) {
            if (attach instanceof FileAttachmentType) {
                FileAttachmentType fat = (FileAttachmentType)attach;
                AttachmentDTO att = new AttachmentDTO();
                att.setFileName(fat.getName());
                att.setFileBody(fat.getContent());
                String string = "attach:" + att.getFileName();
                ExchewsItemBase.trace_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                arr.add(att);
                continue;
            }
            if (attach instanceof ItemAttachmentType) {
                Log.warn((String)"unsupported type ItemAttachmentType detected.");
                ItemAttachmentType iat = (ItemAttachmentType)attach;
                if (this.ewsItemAttachments == null) {
                    this.ewsItemAttachments = new ArrayList<ItemAttachmentType>();
                }
                this.ewsItemAttachments.add(iat);
                continue;
            }
            Log.warn((String)("unsupported type " + attach.getClass().getName() + " detected."));
        }
        this.setAttachments(arr.toArray(new AttachmentDTO[0]));
    }

    protected static SENSITIVITY MSSensiticity2C1Sensitivity(SensitivityChoicesType ms) {
        if (ms == null) {
            return null;
        }
        SENSITIVITY val = null;
        switch (ms) {
            case CONFIDENTIAL: {
                val = SENSITIVITY.CONFIDENTIAL;
                break;
            }
            case NORMAL: {
                val = SENSITIVITY.NORMAL;
                break;
            }
            case PERSONAL: {
                val = SENSITIVITY.PERSONAL;
                break;
            }
            case PRIVATE: {
                val = SENSITIVITY.PRIVATE;
            }
        }
        return val;
    }

    protected static SensitivityChoicesType C1Sensitivity2MSSensiticity(SENSITIVITY c1) {
        if (c1 == null) {
            return null;
        }
        SensitivityChoicesType val = null;
        switch (c1) {
            case CONFIDENTIAL: {
                val = SensitivityChoicesType.CONFIDENTIAL;
                break;
            }
            case NORMAL: {
                val = SensitivityChoicesType.NORMAL;
                break;
            }
            case PERSONAL: {
                val = SensitivityChoicesType.PERSONAL;
                break;
            }
            case PRIVATE: {
                val = SensitivityChoicesType.PRIVATE;
            }
        }
        return val;
    }

    protected static ExchewsItemBase convertFromItemType(ExchewsItemBase dto, ItemType msg) throws Exception {
        if (msg == null) {
            return null;
        }
        if (dto == null) {
            return null;
        }
        dto.setNew(false);
        dto.setOid((IObjectIndex)new ExchewsObjectIndex(msg.getItemId()));
        dto.setItemClass(msg.getItemClass());
        dto.setSubject(msg.getSubject());
        if (msg.getSensitivity() != null) {
            dto.setSensitivity(ExchewsItemBase.MSSensiticity2C1Sensitivity(msg.getSensitivity()));
        }
        if (msg.getDateTimeReceived() != null) {
            dto.setDateTimeReceived(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeReceived()));
        }
        dto.setSize(msg.getSize());
        if (msg.getImportance() != null) {
            dto.setImportance(ExchEWSTranslator.convertEWSImportantType2C1Importance(msg.getImportance()));
        }
        dto.setSubmitted(msg.isIsSubmitted());
        dto.setDraft(msg.isIsDraft());
        dto.setFromMe(msg.isIsFromMe());
        dto.setResend(msg.isIsResend());
        dto.setUnmodified(msg.isIsUnmodified());
        if (msg.getDateTimeSent() != null) {
            dto.setDateTimeSent(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeSent()));
        }
        if (msg.getDateTimeCreated() != null) {
            dto.setDateTimeCreated(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeCreated()));
        }
        if (msg.isReminderIsSet() != null) {
            dto.setReminderIsSet(msg.isReminderIsSet());
        }
        if (dto.isReminderIsSet()) {
            dto.setReminderMinutesBeforeStart(msg.getReminderMinutesBeforeStart());
        }
        dto.setDisplayCc(msg.getDisplayCc());
        dto.setDisplayTo(msg.getDisplayTo());
        dto.setHasAttachments(msg.isHasAttachments());
        dto.setCulture(msg.getCulture());
        if (msg.getBody() != null) {
            dto.setBody(msg.getBody().getValue());
        }
        if (msg.getLastModifiedTime() != null) {
            dto.setLastModifiedTime(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getLastModifiedTime()));
        }
        dto.setBeanData();
        return dto;
    }

    protected static ItemType convertToItemType(ItemType msg, ExchewsItemBase dto) throws Exception {
        if (msg == null) {
            return null;
        }
        if (dto == null) {
            return null;
        }
        if (dto.getOid() != null) {
            msg.setItemId((ItemIdType)dto.getOid().getIndex());
        }
        msg.setItemClass(dto.getItemClass());
        msg.setSubject(dto.getSubject());
        if (dto.getBody() != null) {
            BodyType body = new BodyType();
            body.setBodyType(BodyTypeType.TEXT);
            body.setValue(dto.getBody());
            msg.setBody(body);
        }
        return msg;
    }

    static {
        ExchewsItemBase.ajc$preClinit();
    }

    private static final /* synthetic */ void trace_aroundBody0(ExchewsItemBase exchewsItemBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(ExchewsItemBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exchews_log_LogAspect$jp_co_connectone_eai_exchews_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExchewsItemBase.java", Class.forName("jp.co.connectone.eai.exchews.store.ExchewsItemBase"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 336);
    }

    public static enum SENSITIVITY {
        NORMAL("Normal"),
        PERSONAL("Personal"),
        PRIVATE("Private"),
        CONFIDENTIAL("Confidential");

        private String value;

        private SENSITIVITY(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

