/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.common;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.co.connectone.common.IPropertyHandler;
import jp.co.connectone.exception.HandleException;

public abstract class PropertyHandlerBaseImpl
implements IPropertyHandler {
    protected static HashMap<String, IPropertyHandler> handlers = null;
    protected static IPropertyHandler theHandler = null;

    static {
        handlers = new HashMap();
    }

    protected abstract Properties getSystemProperties() throws Exception;

    public static IPropertyHandler getInstance() throws Exception {
        if (theHandler != null) {
            return theHandler;
        }
        String className = System.getProperty("jp.co.connectone.common.IPropertyHandler", "jp.co.connectone.common.FileBasedPropertyHandlerImpl");
        theHandler = (IPropertyHandler)Class.forName(className).newInstance();
        return theHandler;
    }

    public static IPropertyHandler getInstance(String className) throws Exception {
        Class<?> o = Class.forName(className);
        IPropertyHandler handler = handlers.get(className);
        if (handler == null) {
            throw new HandleException("request IPropertyHandler with bad class name " + className + ".");
        }
        return handler;
    }

    @Override
    public String getValueFromProperties(String key) throws Exception {
        return this.getSystemProperties().getProperty(key);
    }

    @Override
    public Properties getProperties(String key) throws Exception {
        Properties props = this.getSystemProperties();
        Enumeration<?> e = props.propertyNames();
        HashMap<String, String> sectionMap = new HashMap<String, String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.startsWith(key)) continue;
            String v = props.getProperty(s);
            String k = s.substring(key.length() + 1);
            sectionMap.put(k, v);
        }
        Properties rc = new Properties();
        if (sectionMap.size() != 0) {
            rc.putAll((Map<?, ?>)sectionMap);
        }
        return rc;
    }
}

