/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Find;
import jregex.FindBack;
import jregex.Term;

public class Optimizer {
    public static final int THRESHOLD = 20;
    private Term atom;
    private int distance;

    static Optimizer find(Term term) {
        return Optimizer.find(term, 0);
    }

    private static Optimizer find(Term term, int n) {
        if (term == null) {
            return null;
        }
        Term term2 = term.next;
        int n2 = term.type;
        switch (n2) {
            case 0: 
            case 6: 
            case 7: {
                return new Optimizer(term, n);
            }
            case 1: 
            case 2: {
                if (term.weight <= 20) {
                    return new Optimizer(term, n);
                }
                return Optimizer.find(term.next, n + 1);
            }
            case 4: 
            case 5: {
                return Optimizer.find(term2, n + 1);
            }
            case 46: 
            case 47: {
                if (term.minCount > 0) {
                    return Optimizer.find(term.target, n);
                }
                return null;
            }
        }
        if (n2 >= 11 && n2 <= 31) {
            return Optimizer.find(term2, n);
        }
        return null;
    }

    private Optimizer(Term term, int n) {
        this.atom = term;
        this.distance = n;
    }

    Term makeFirst(Term term) {
        return new Find(this.atom, this.distance, term);
    }

    Term makeBacktrack(Term term) {
        int n = term.minCount;
        switch (term.type) {
            case 50: {
                n = 0;
            }
            case 51: {
                return new FindBack(this.atom, this.distance, n, term);
            }
            case 54: {
                return term;
            }
        }
        throw new Error("unexpected iterator's backtracker:" + term);
    }
}

