/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.webapps.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.filters.BaseFilter;
import jp.co.connectone.webapps.log.LogAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class URLencodeFilter
extends BaseFilter
implements Filter {
    private static Pattern aHrefPattern;
    private static Pattern formActionPattern;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        URLencodeFilter.ajc$preClinit();
        aHrefPattern = Pattern.compile("(<a(\\s+\\w+(=\"[^\"]*\")*)*(\\s+href=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*/?\\s*>)", 2);
        formActionPattern = Pattern.compile("(<form(\\s+\\w+(=\"[^\"]*\")*)*?(\\s+action=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*>)", 2);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        BufferedTextResponseWrapper responseWrapper = new BufferedTextResponseWrapper(response);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        String string = "content type = " + response.getContentType();
        URLencodeFilter.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        if (response.getContentType().indexOf("text/html") >= 0) {
            String cookielessSessionHtmlText = this.encodeUrlForAllUrls((HttpServletResponse)response, responseWrapper.getBuffer());
            PrintWriter out = response.getWriter();
            out.print(cookielessSessionHtmlText);
        }
    }

    private String encodeUrlForAllUrls(HttpServletResponse response, CharSequence htmlText) {
        Matcher m = aHrefPattern.matcher(htmlText);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String newHref = m.group(5);
            if (newHref.indexOf(58) == -1) {
                newHref = response.encodeURL(newHref);
            }
            m.appendReplacement(sb, String.valueOf(m.group(1)) + newHref + m.group(6));
        }
        m.appendTail(sb);
        m = formActionPattern.matcher(sb);
        sb = new StringBuffer();
        while (m.find()) {
            String newAction = m.group(5);
            if (newAction.indexOf(58) == -1) {
                newAction = response.encodeURL(newAction);
            }
            m.appendReplacement(sb, String.valueOf(m.group(1)) + newAction + m.group(6));
        }
        m.appendTail(sb);
        return new String(sb);
    }

    private static final /* synthetic */ void debug_aroundBody0(URLencodeFilter uRLencodeFilter, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(URLencodeFilter ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_webapps_log_LogAspect$jp_co_connectone_webapps_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_webapps_log_LogAspect$jp_co_connectone_webapps_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("URLencodeFilter.java", Class.forName("jp.co.connectone.webapps.filters.URLencodeFilter"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 21);
    }

    static class BufferedTextResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter writer;
        private PrintWriter pw;

        public BufferedTextResponseWrapper(ServletResponse response) {
            super((HttpServletResponse)response);
        }

        public PrintWriter getWriter() throws IOException {
            this.writer = new StringWriter();
            this.pw = new PrintWriter(this.writer);
            return this.pw;
        }

        public StringBuffer getBuffer() {
            if (this.writer == null) {
                try {
                    this.getWriter();
                }
                catch (IOException ioe) {
                    Log.error((String)"error on getWriter", (Throwable)ioe);
                }
            }
            this.pw.flush();
            return this.writer.getBuffer();
        }
    }
}

