/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.MailAddress;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Pop3Translator {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public static MimeMessage TopString2MimeMessage(String topStr) {
        try {
            return new MimeMessage(null, (InputStream)new ByteArrayInputStream(topStr.getBytes()));
        }
        catch (MessagingException e) {
            Log.debug((String)"error on creating MimeMessage.", (Throwable)e);
            return null;
        }
    }

    public static MimeMessage RetrString2MimeMessage(String retrStr) {
        return Pop3Translator.TopString2MimeMessage(retrStr);
    }

    public static IMailDTO TopString2MailDTO(String topStr, String uidl) throws HandleException {
        MimeMessage mes = Pop3Translator.TopString2MimeMessage(topStr);
        if (mes == null) {
            return null;
        }
        HeaderDTO header = Pop3Translator.TopString2HeaderDTO(topStr, uidl);
        BasicMailDTO mailDTOObj = new BasicMailDTO(header);
        try {
            if (mes.isMimeType("multipart/mixed")) {
                mailDTOObj.setAttachments(new AttachmentDTO[]{new AttachmentDTO()});
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
            if (!(e instanceof MessageRemovedException)) {
                throw new HandleException(e.getMessage());
            }
            String string = "skip this message...";
            Pop3Translator.debug_aroundBody1$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        }
        return mailDTOObj;
    }

    public static HeaderDTO TopString2HeaderDTO(String topStr, String uidl) throws HandleException {
        HeaderDTO head;
        block29: {
            MimeMessage mes = Pop3Translator.TopString2MimeMessage(topStr);
            if (mes == null) {
                return null;
            }
            head = new HeaderDTO();
            try {
                int i;
                String tmp = null;
                head.setHeaderUIDL(uidl);
                head.setOid((IObjectIndex)new BasicObjectIndex((Object)uidl));
                Address[] add = null;
                try {
                    add = mes.getFrom();
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    head.setHeaderFrom(tmp);
                }
                head.setHeaderSubject(mes.getSubject());
                int pri = 0;
                String[] priStr = mes.getHeader("importance");
                if (priStr == null) {
                    priStr = mes.getHeader("priority");
                }
                try {
                    if (priStr != null) {
                        pri = Integer.parseInt(priStr[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                head.setHeaderPriority(pri);
                try {
                    add = mes.getReplyTo();
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    head.setHeaderReplyTo(tmp);
                }
                head.setHeaderSize(mes.getSize());
                head.setHeaderSendDate(mes.getSentDate());
                try {
                    add = mes.getRecipients(Message.RecipientType.CC);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    MailAddress[] cc = new MailAddress[add.length];
                    i = 0;
                    while (i < add.length) {
                        MailAddress address;
                        tmp = add[i].toString();
                        try {
                            tmp = MimeUtility.decodeText((String)add[i].toString());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        cc[i] = address = new MailAddress(tmp);
                        ++i;
                    }
                    head.setHeaderCC(cc);
                }
                try {
                    add = mes.getRecipients(Message.RecipientType.TO);
                }
                catch (AddressException cc) {
                    // empty catch block
                }
                if (add == null) break block29;
                MailAddress[] to = new MailAddress[add.length];
                i = 0;
                while (i < add.length) {
                    tmp = add[i].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[i].toString());
                    }
                    catch (UnsupportedEncodingException address) {
                        // empty catch block
                    }
                    to[i] = address = new MailAddress(tmp);
                    ++i;
                }
                head.setHeaderTo(to);
            }
            catch (MessagingException e) {
                e.printStackTrace();
                if (!(e instanceof MessageRemovedException)) {
                    throw new HandleException(e.getMessage());
                }
                String string = "skip this message...";
                Pop3Translator.debug_aroundBody3$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
            }
        }
        return head;
    }

    public static IMailDTO RetrString2MailDTO(String retrStr, String uidl) throws HandleException {
        MimeMessage mes;
        HeaderDTO l_headerDTOObj;
        BasicMailDTO l_IMailDTOObj;
        ArrayList<AttachmentDTO> attach;
        String bodyText;
        block32: {
            bodyText = null;
            attach = new ArrayList<AttachmentDTO>();
            l_IMailDTOObj = new BasicMailDTO();
            l_headerDTOObj = new HeaderDTO();
            String tmp = null;
            if (retrStr == null || retrStr.length() <= 0) {
                return l_IMailDTOObj;
            }
            mes = Pop3Translator.RetrString2MimeMessage(retrStr);
            try {
                int i;
                l_headerDTOObj.setHeaderUIDL(uidl);
                l_headerDTOObj.setOid((IObjectIndex)new BasicObjectIndex((Object)uidl));
                Address[] add = null;
                try {
                    add = mes.getFrom();
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    l_headerDTOObj.setHeaderFrom(tmp);
                }
                l_headerDTOObj.setHeaderSubject(mes.getSubject());
                int pri = 0;
                String[] priStr = mes.getHeader("importance");
                if (priStr == null) {
                    priStr = mes.getHeader("priority");
                }
                try {
                    if (priStr != null) {
                        pri = Integer.parseInt(priStr[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l_headerDTOObj.setHeaderPriority(pri);
                try {
                    add = mes.getReplyTo();
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    l_headerDTOObj.setHeaderReplyTo(tmp);
                }
                l_headerDTOObj.setHeaderSize(mes.getSize());
                l_headerDTOObj.setHeaderSendDate(mes.getSentDate());
                try {
                    add = mes.getRecipients(Message.RecipientType.CC);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    MailAddress[] cc = new MailAddress[add.length];
                    i = 0;
                    while (i < add.length) {
                        MailAddress address;
                        tmp = add[i].toString();
                        try {
                            tmp = MimeUtility.decodeText((String)add[i].toString());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        cc[i] = address = new MailAddress(tmp);
                        ++i;
                    }
                    l_headerDTOObj.setHeaderCC(cc);
                }
                try {
                    add = mes.getRecipients(Message.RecipientType.TO);
                }
                catch (AddressException cc) {
                    // empty catch block
                }
                if (add == null) break block32;
                MailAddress[] to = new MailAddress[add.length];
                i = 0;
                while (i < add.length) {
                    tmp = add[i].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[i].toString());
                    }
                    catch (UnsupportedEncodingException address) {
                        // empty catch block
                    }
                    to[i] = address = new MailAddress(tmp);
                    ++i;
                }
                l_headerDTOObj.setHeaderTo(to);
            }
            catch (MessagingException e) {
                e.printStackTrace();
                if (!(e instanceof MessageRemovedException)) {
                    throw new HandleException(e.getMessage());
                }
                String string = "skip this message...";
                Pop3Translator.debug_aroundBody5$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
            }
        }
        l_IMailDTOObj.setHeaderDTO(l_headerDTOObj);
        bodyText = Pop3Translator.retrieveAllParts((Part)mes, attach);
        try {
            bodyText = new String(bodyText.getBytes("Shift-JIS"), "MS932");
        }
        catch (Exception e) {
            // empty catch block
        }
        l_IMailDTOObj.setBody(bodyText);
        if (attach != null && attach.size() > 0) {
            AttachmentDTO[] list = attach.toArray(new AttachmentDTO[1]);
            l_IMailDTOObj.setAttachments(list);
            String string = list.toString();
            Pop3Translator.debug_aroundBody7$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
        }
        attach = null;
        return l_IMailDTOObj;
    }

    private static String retrieveAllParts(Part part, ArrayList<AttachmentDTO> attach) throws IncorrectData, HandleException {
        String bodyText = "";
        try {
            if (part.isMimeType("multipart/*")) {
                Multipart subPart = (Multipart)part.getContent();
                int i = 0;
                while (i < subPart.getCount()) {
                    String text = Pop3Translator.retrieveAllParts((Part)subPart.getBodyPart(i), attach);
                    if (bodyText == null || bodyText.length() == 0) {
                        bodyText = text;
                    }
                    ++i;
                }
            } else if (part.isMimeType("text/plain")) {
                if (part.getFileName() == null) {
                    bodyText = (String)part.getContent();
                } else {
                    Pop3Translator.addAttach(part, attach);
                }
            } else {
                Pop3Translator.addAttach(part, attach);
            }
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectData(me.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new HandleException((Throwable)ioe);
        }
        return bodyText;
    }

    private static void addAttach(Part part, ArrayList<AttachmentDTO> attach) throws MessagingException {
        AttachmentDTO newAttach = new AttachmentDTO();
        String fileName = null;
        byte[] rawData = null;
        try {
            fileName = part.getFileName();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (fileName == null) {
            return;
        }
        try {
            fileName = MimeUtility.decodeText((String)fileName);
            InputStream bio = part.getInputStream();
            ByteArrayOutputStream boo = new ByteArrayOutputStream();
            byte[] buf = new byte[81920];
            int len = buf.length;
            while (len == buf.length) {
                len = bio.read(buf);
                if (len < 0) break;
                try {
                    boo.write(buf, 0, len);
                }
                catch (IndexOutOfBoundsException e) {
                    Log.error((String)"", (Throwable)e);
                }
            }
            rawData = boo.toByteArray();
        }
        catch (UnsupportedEncodingException bio) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String string = fileName;
        Pop3Translator.debug_aroundBody9$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        newAttach.setFileName(fileName);
        newAttach.setFileBody(rawData);
        attach.add(newAttach);
    }

    static {
        Pop3Translator.ajc$preClinit();
    }

    private static final /* synthetic */ void debug_aroundBody0(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Pop3Translator.java", Class.forName("jp.co.connectone.eai.pop3.socket.Pop3Translator"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 49);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 154);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 255);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 269);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 350);
    }
}

