/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.socket;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.pop3.socket.IConnectorSession;
import jp.co.connectone.eai.pop3.socket.Pop3Translator;
import jp.co.connectone.eai.pop3.socket.SocketBasedPop3BaseImpl;
import jp.co.connectone.eai.pop3.socket.UidlElement;
import jp.co.connectone.eai.pop3.store.Pop3FolderIndex;
import jp.co.connectone.eai.pop3.store.Pop3ObjectIndex;
import jp.co.connectone.eai.pop3.store.Pop3ServiceInfo;
import jp.co.connectone.eai.pop3.user.Pop3AccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.user.IAccountData;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Pop3MailStoreImpl
extends SocketBasedPop3BaseImpl
implements IMailStore {
    public static final IStoreID storeID;
    public static final String storeName = "Pop3 Mail Store";
    private static final SimpleDateFormat sf;
    private static final SimpleDateFormat ef;
    private static final SimpleDateFormat df;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        Pop3MailStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Pop3MailStoreImpl.class.getName());
        sf = new SimpleDateFormat("yyyy/MM/dd 00:00:00 Z");
        ef = new SimpleDateFormat("yyyy/MM/dd 23:59:59 Z");
        df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
    }

    private int binarySearch(Vector<UidlElement> uidlList, HashMap<String, IMailDTO> topList, Date d, MODE mode) throws HandleException {
        int l = 0;
        int r = uidlList.size() - 1;
        int val = -1;
        block0: while (l <= r) {
            int m = (l + r) / 2;
            Date from = this.getDateFromHeaders(uidlList, topList, m);
            int comp = from.compareTo(d);
            if (comp < 0) {
                l = m + 1;
                val = m;
                String string = "\u2192";
                Pop3MailStoreImpl.trace_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
                if (mode != MODE.GREATER) continue;
                ++val;
                continue;
            }
            if (comp > 0) {
                r = m - 1;
                val = m;
                String string = "\u2190";
                Pop3MailStoreImpl.trace_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
                if (mode != MODE.LESSER) continue;
                --val;
                continue;
            }
            String string = "=";
            Pop3MailStoreImpl.trace_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
            val = m--;
            if (mode == MODE.GREATER) {
                while (l <= m) {
                    from = this.getDateFromHeaders(uidlList, topList, m);
                    comp = from.compareTo(d);
                    if (comp != 0) break block0;
                    val = m--;
                }
            } else {
                if (mode != MODE.LESSER) break;
                ++m;
                while (r >= m) {
                    from = this.getDateFromHeaders(uidlList, topList, m);
                    comp = from.compareTo(d);
                    if (comp != 0) break block0;
                    val = m++;
                }
            }
            break;
        }
        return val;
    }

    private Date getDateFromHeaders(Vector<UidlElement> uidlList, HashMap<String, IMailDTO> topList, int index) throws HandleException {
        UidlElement uidl = uidlList.get(index);
        IMailDTO header = topList.get(uidl.getUidl());
        if (header == null) {
            String topStr = this.getTopByUidlIndexWithoutOpen(uidlList, index);
            header = Pop3Translator.TopString2MailDTO(topStr, uidl.getUidl());
            topList.put(uidl.getUidl(), header);
        }
        return header.getHeader().getHeaderSendDate();
    }

    private boolean checkDataExist(int start, int end, int size) {
        if (start < 0) {
            return false;
        }
        if (end < 0) {
            return false;
        }
        if (start > size) {
            return false;
        }
        return start <= end;
    }

    public static Pop3MailStoreImpl getInstance() {
        return new Pop3MailStoreImpl();
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Pop3ServiceInfo(storeID, storeName);
    }

    public void deleteMail(IConnectorSession cacheObj, IAccountData acc, IObjectIndex oidx) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        Object oid = oidx.getIndex();
        String string = "deleteMail::oid=" + oid;
        Pop3MailStoreImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
        super.delete(uidlList, oid.toString());
    }

    private HashMap<String, IMailDTO> getCurrentTopList(IConnectorSession cacheObj) {
        if (cacheObj == null) {
            return null;
        }
        return cacheObj.getTopList();
    }

    private Vector<UidlElement> getCurrentUidlList(IConnectorSession cacheObj) {
        if (cacheObj == null) {
            return null;
        }
        return cacheObj.getUidlList();
    }

    public IMailDTO[] getHeaders(IConnectorSession cacheObj, IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        IMailDTO[] headers = null;
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Vector<IMailDTO> ar = this.getList(uidlList);
        headers = ar.toArray(headers);
        return headers;
    }

    private Vector<IMailDTO> getList(Vector<UidlElement> uidlList) {
        return null;
    }

    public IMailDTO[] getHeadersByDate(IConnectorSession cacheObj, IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        try {
            this.open();
            uidlList = this.checkUidlListNotEmptyWithoutOpen(uidlList);
            cacheObj.setUidlList(uidlList);
            HashMap<String, Object> topList = this.getCurrentTopList(cacheObj);
            if (topList == null) {
                topList = new HashMap();
            }
            IMailDTO[] headers = null;
            String sStr = sf.format(date);
            String eStr = ef.format(date);
            Date start = null;
            Date end = null;
            try {
                start = df.parse(sStr);
                end = df.parse(eStr);
            }
            catch (ParseException e) {
                this.close();
                throw new HandleException("can't create datetime-range.");
            }
            String string = "From " + start + " TO " + end;
            Pop3MailStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
            int sidx = this.binarySearch(uidlList, topList, start, MODE.GREATER);
            int eidx = this.binarySearch(uidlList, topList, end, MODE.LESSER);
            String string2 = "sidx=" + sidx + ",eidx=" + ++eidx;
            Pop3MailStoreImpl.debug_aroundBody11$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_5);
            if (!this.checkDataExist(sidx, eidx, uidlList.size())) {
                this.close();
                return new BasicMailDTO[0];
            }
            topList = this.fillTopListByRange(sidx, eidx, uidlList, topList);
            this.close();
            if (cacheObj != null) {
                cacheObj.setTopList(topList);
            }
            headers = this.populateHeaderList(sidx, eidx, uidlList, topList);
            return headers;
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    public IMailDTO[] getHeadersByDateRange(IConnectorSession cacheObj, IAccountData acc, ISearchDestination dest, Date date, int sidx, int eidx) throws HandleException {
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        try {
            this.open();
            uidlList = this.checkUidlListNotEmptyWithoutOpen(uidlList);
            cacheObj.setUidlList(uidlList);
            HashMap<String, Object> topList = this.getCurrentTopList(cacheObj);
            if (topList == null) {
                topList = new HashMap();
            }
            IMailDTO[] headers = null;
            String sStr = sf.format(date);
            String eStr = ef.format(date);
            Date start = null;
            Date end = null;
            try {
                start = df.parse(sStr);
                end = df.parse(eStr);
            }
            catch (ParseException e) {
                this.close();
                throw new HandleException("can't create datetime-range.");
            }
            String string = "From " + start + " TO " + end;
            Pop3MailStoreImpl.debug_aroundBody13$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_6);
            int dsidx = this.binarySearch(uidlList, topList, start, MODE.GREATER);
            int deidx = this.binarySearch(uidlList, topList, end, MODE.LESSER);
            ++eidx;
            String string2 = "dsidx=" + dsidx + ",deidx=" + deidx;
            Pop3MailStoreImpl.debug_aroundBody15$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_7);
            if (!this.checkDataExist(dsidx, deidx, uidlList.size())) {
                this.close();
                return new BasicMailDTO[0];
            }
            int aeidx = deidx - sidx;
            if (aeidx < dsidx) {
                this.close();
                return new BasicMailDTO[0];
            }
            int asidx = deidx - eidx;
            if (asidx < dsidx) {
                asidx = dsidx;
            }
            String string3 = "asidx=" + asidx + ",aeidx=" + aeidx;
            Pop3MailStoreImpl.debug_aroundBody17$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_8);
            topList = this.fillTopListByRange(asidx, aeidx, uidlList, topList);
            this.close();
            if (cacheObj != null) {
                cacheObj.setTopList(topList);
            }
            headers = this.populateHeaderList(asidx, aeidx, uidlList, topList);
            return headers;
        }
        catch (HandleException e) {
            this.close();
            throw e;
        }
    }

    private IMailDTO[] populateHeaderList(int start, int end, Vector<UidlElement> uidlList, HashMap<String, IMailDTO> topList) {
        Vector<IMailDTO> rc = new Vector<IMailDTO>();
        if (++end >= uidlList.size()) {
            end = uidlList.size();
        }
        int i = start;
        while (i < end) {
            IMailDTO dto = topList.get(uidlList.get(i).getUidl());
            rc.add(0, dto);
            ++i;
        }
        return rc.toArray(new IMailDTO[0]);
    }

    private Vector<IMailDTO> getListByDate(Vector<UidlElement> uidlList, Date date) {
        return null;
    }

    public IMailDTO getMail(IConnectorSession cacheObj, IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        if (oidx == null) {
            throw new IncorrectData("message-id is null. cannot retrieve data.");
        }
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        Object oid = oidx.getIndex();
        String string = "getMail::oid=" + oid;
        Pop3MailStoreImpl.debug_aroundBody19$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_9);
        IMailDTO mail = this.getMail(uidlList, oid.toString());
        return mail;
    }

    protected IMailDTO getMail(Vector<UidlElement> uidlList, String uidl) throws HandleException {
        String retr = this.getRetrByUidl(uidlList, uidl);
        return Pop3Translator.RetrString2MailDTO(retr, uidl);
    }

    public FolderMetadata[] getMailFolders(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        FolderMetadata[] folders = new FolderMetadata[]{this.populateFolder(new Pop3FolderIndex())};
        return folders;
    }

    public IMailDTO[] getMailsByDate(IConnectorSession cacheObj, IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        Vector<UidlElement> uidlList = this.getCurrentUidlList(cacheObj);
        IMailDTO[] headers = null;
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Vector<IMailDTO> ar = this.getListByDate(uidlList, date);
        headers = ar.toArray(headers);
        return headers;
    }

    public IMailDTO[] getSentMails(IAccountData arg0) throws ServerDown, HandleException {
        throw new HandleException("Pop3 Mail Store does not support getSentMails.");
    }

    public IMailDTO[] getSentMailsByDate(IAccountData arg0, Date arg1) throws ServerDown, HandleException {
        throw new HandleException("Pop3 Mail Store does not support getSentMailsByDate.");
    }

    public Vector<UidlElement> getInitialUidls(IAccountData acc) throws HandleException {
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        return super.getUIDLList();
    }

    public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setAccount(pacc.getUserID(), pacc.getPassword(), pacc.getServiceInfo().getServerAddress(), pacc.getServiceInfo().getServerAddress2(), pacc.getServiceInfo().getPort());
        Vector<UidlElement> uidlList = super.getUIDLList();
        ArrayList<Pop3ObjectIndex> uidlarray = new ArrayList<Pop3ObjectIndex>();
        for (UidlElement uidl : uidlList) {
            uidlarray.add(new Pop3ObjectIndex(uidl.getUidl()));
        }
        Pop3ObjectIndex[] uidls = new Pop3ObjectIndex[1];
        uidls = uidlarray.toArray(uidls);
        return uidls;
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO[] headers = this.getHeadersByDate(acc, dest, date);
        if (headers == null) {
            return new Pop3ObjectIndex[0];
        }
        ArrayList<Pop3ObjectIndex> uidlarray = new ArrayList<Pop3ObjectIndex>();
        int i = 0;
        while (i < headers.length) {
            String uidl = headers[i].getHeader().getHeaderUIDL();
            if (uidl == null) {
                String string = "skip message " + headers[i].getHeader().getHeaderSubject() + " because of no Message-ID.";
                Pop3MailStoreImpl.debug_aroundBody21$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_10);
            } else {
                uidlarray.add(new Pop3ObjectIndex(uidl));
            }
            ++i;
        }
        Pop3ObjectIndex[] uidls = new Pop3ObjectIndex[uidlarray.size()];
        uidls = uidlarray.toArray(uidls);
        return uidls;
    }

    public IObjectIndex sendMail(IAccountData arg0, IMailDTO arg1) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        throw new HandleException("Pop3 Mail Store does not support sendMail.");
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws Exception {
        this.deleteMail(acc, oidx);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getHeaders(acc, dest);
    }

    public IRecordObject getFolderIndexFromString(String arg0) throws IncorrectData {
        return new Pop3FolderIndex();
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailFolders(acc, dest);
    }

    public String getName() throws Exception {
        return storeName;
    }

    public ISearchDestination getPresetDestination(IAccountData arg0, int arg2) throws IncorrectData, HandleException {
        BasicSearchDestination dst = new BasicSearchDestination(null, (IFolderIndex)new Pop3FolderIndex());
        return dst;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        Pop3ServiceInfo info = new Pop3ServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        return info;
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws Exception {
        return this.getMail(acc, dest, oidx);
    }

    public IRecordObject[] search(IAccountData arg0, ISearchFormula arg1) throws Exception {
        throw new HandleException("Pop3 Mail Store does not support search.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return this.getHeadersByDate(acc, dest, date);
    }

    public IObjectIndex write(IAccountData arg0, ISearchDestination arg1, IRecordObject arg2) throws Exception {
        throw new HandleException("Pop3 Mail Store does not support write.");
    }

    protected FolderMetadata populateFolder(IFolderIndex idx) {
        FolderMetadata folder = new FolderMetadata();
        folder.setOid((IObjectIndex)idx);
        HashMap<String, IFolderIndex> h = new HashMap<String, IFolderIndex>();
        h.put("oid", idx);
        folder.setFieldSet(h);
        folder.setFolderName(idx.getIndex().toString());
        return folder;
    }

    public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        this.deleteMail(null, acc, oid);
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getHeaders(null, acc, dest);
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getHeadersByDate(null, acc, dest, date);
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return this.getMail(null, acc, dest, oid);
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        return this.getMailsByDate(null, acc, dest, date);
    }

    protected HashMap<String, IMailDTO> fillTopListByRange(int start, int end, Vector<UidlElement> uidlList, HashMap<String, IMailDTO> topList) throws HandleException {
        if (topList == null) {
            topList = new HashMap();
        }
        if (start >= uidlList.size()) {
            return topList;
        }
        if (end < start) {
            return topList;
        }
        if (++end >= uidlList.size()) {
            end = uidlList.size();
        }
        List<UidlElement> sub = uidlList.subList(start, end);
        for (UidlElement uidl : sub) {
            IMailDTO top = (IMailDTO)topList.get(uidl.getUidl());
            if (top != null) continue;
            String topStr = this.getTopByUidlWithoutOpen(uidlList, uidl.getUidl());
            topList.put(uidl.getUidl(), Pop3Translator.TopString2MailDTO(topStr, uidl.getUidl()));
        }
        return topList;
    }

    public HashMap<String, IMailDTO> fillTopListByRangeR(int start, int end, Vector<UidlElement> uidlList, HashMap<String, IMailDTO> topList) throws HandleException {
        this.checkUidlListNotEmpty(uidlList);
        int s = this.reverseIndex(end, uidlList.size());
        int e = this.reverseIndex(start, uidlList.size());
        return this.fillTopListByRange(s, e, uidlList, topList);
    }

    private static final /* synthetic */ void trace_aroundBody0(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody2(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody3$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody4(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody5$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody14(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody15$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody18(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody19$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody20(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody21$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Pop3MailStoreImpl.java", Class.forName("jp.co.connectone.eai.pop3.socket.Pop3MailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 42);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 48);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 393);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 52);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 125);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 192);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 197);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 242);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 247);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 261);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 310);
    }

    private static enum MODE {
        GREATER,
        LESSER;

    }
}

