/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import jp.co.connectone.eai.notes.log.LogAspect;
import jp.co.connectone.eai.notes.store.EAINotesBase;
import jp.co.connectone.eai.notes.store.IRecordElement;
import jp.co.connectone.eai.notes.store.NotesDBFieldSet;
import jp.co.connectone.eai.notes.store.NotesFolderIndex;
import jp.co.connectone.eai.notes.store.NotesObjectIndex;
import jp.co.connectone.eai.notes.store.NotesServiceInfo;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.db.IDBStore;
import jp.co.connectone.user.IAccountData;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class NotesDBStoreImpl
extends EAINotesBase
implements IDBStore {
    public static final IStoreID storeID;
    public static final String storeName = "Notes Database Store";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        NotesDBStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(NotesDBStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        NotesServiceInfo info = new NotesServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        String database = (String)h.get("database");
        String serverAddress2 = (String)h.get("server2");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
            if (serverAddress2 != null) {
                info.setServerAddress2(serverAddress2);
            }
            info.setDatabase(database);
        }
        return info;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new NotesServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        NotesDBFieldSet rc = null;
        Document doc = super.getDocument(oid);
        try {
            try {
                rc = new NotesDBFieldSet(doc.getUniversalID(), super.populateHashMap(doc));
            }
            catch (NullPointerException l_nullExObj) {
                throw new HandleException(l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new HandleException(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (doc != null) {
                        doc.recycle();
                    }
                }
                catch (NotesException l_excepObj) {
                    throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (doc != null) {
                    doc.recycle();
                }
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return rc;
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject objRecord) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        NotesObjectIndex rc = null;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        Document doc = null;
        if (objRecord.isNew()) {
            String string = "new record";
            NotesDBStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            doc = super.createDocument();
        } else {
            String string = "overwrite";
            NotesDBStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
            doc = super.getDocument(objRecord.getOid());
            if (objRecord instanceof NotesDBFieldSet) {
                this.updateFieldsFromNotesDBFieldSet(doc, objRecord);
            }
        }
        try {
            try {
                doc.save();
                rc = new NotesObjectIndex(doc.getUniversalID());
            }
            catch (NotesException notesEx) {
                throw new HandleException(String.valueOf(notesEx.id) + notesEx.text);
            }
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    try {
                        if (doc != null) {
                            doc.recycle();
                        }
                    }
                    catch (NotesException l_notesExp) {
                        new ServerDown(String.valueOf(l_notesExp.id) + l_notesExp.text);
                        super.recycleObjects();
                        break block20;
                    }
                }
                catch (Throwable throwable2) {
                    super.recycleObjects();
                    throw throwable2;
                }
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (doc != null) {
                    doc.recycle();
                }
            }
            catch (NotesException l_notesExp) {
                new ServerDown(String.valueOf(l_notesExp.id) + l_notesExp.text);
                super.recycleObjects();
            }
        }
        finally {
            super.recycleObjects();
        }
        return rc;
    }

    public FolderMetadata[] getFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        FolderMetadata[] l_strFolderlist = new FolderMetadata[]{};
        ArrayList<FolderMetadata> dst = new ArrayList<FolderMetadata>();
        Vector<View> l_viewsObj = null;
        View l_viewObj = null;
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_viewsObj = this.getViews();
                int l_intIndex = 0;
                while (l_intIndex < l_viewsObj.size()) {
                    l_viewObj = l_viewsObj.elementAt(l_intIndex);
                    if (l_viewObj.isFolder()) {
                        FolderMetadata folder = new FolderMetadata();
                        folder.setFolderName(l_viewObj.getName());
                        dst.add(folder);
                    }
                    ++l_intIndex;
                }
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        finally {
            block19: {
                try {
                    try {
                        if (l_viewsObj != null) {
                            l_viewObj.recycle();
                        }
                    }
                    catch (Exception l_exceptionObj) {
                        Log.error((String)"", (Throwable)l_exceptionObj);
                        super.recycleObjects();
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    super.recycleObjects();
                    throw throwable;
                }
                super.recycleObjects();
            }
        }
        l_strFolderlist = dst.toArray(l_strFolderlist);
        return l_strFolderlist;
    }

    public IRecordObject[] getDataSet(IAccountData acc, ISearchDestination dest, IRecordObject template) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        View l_viewObj = null;
        ViewEntryCollection col = null;
        ViewEntry entry = null;
        Document doc = null;
        NotesDBFieldSet[] l_docArray = null;
        IFolderIndex folder = dest.getFolder();
        super.initSession((NotesAccountData)acc, dest.getDatabase());
        try {
            try {
                l_viewObj = this.getView(dest.getFolder());
                String string = "l_viewObj=" + l_viewObj;
                NotesDBStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
                col = l_viewObj.getAllEntries();
                String string2 = "Number of Entries:" + col.getCount();
                NotesDBStoreImpl.debug_aroundBody7$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_3);
                l_docArray = new NotesDBFieldSet[col.getCount()];
                entry = col.getFirstEntry();
                int i = 0;
                while (entry != null) {
                    if (entry.isDocument()) {
                        doc = entry.getDocument();
                        l_docArray[i++] = new NotesDBFieldSet(doc.getUniversalID(), super.populateHashMap(doc));
                    }
                    entry = col.getNextEntry(entry);
                }
            }
            catch (NullPointerException l_nullExObj) {
                throw new StoreNotFound(String.valueOf(folder.getIndex().toString()) + l_nullExObj.getMessage());
            }
            catch (NotesException l_notesExcepObj) {
                throw new ServerDown(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_viewObj != null) {
                        l_viewObj.recycle();
                    }
                    if (doc != null) {
                        doc.recycle();
                    }
                    if (entry != null) {
                        doc.recycle();
                    }
                    if (col != null) {
                        col.recycle();
                    }
                }
                catch (NotesException l_excepObj) {
                    throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_viewObj != null) {
                    l_viewObj.recycle();
                }
                if (doc != null) {
                    doc.recycle();
                }
                if (entry != null) {
                    doc.recycle();
                }
                if (col != null) {
                    col.recycle();
                }
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return l_docArray;
    }

    @Override
    protected String getElmentName() {
        return null;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        this.initSession((NotesAccountData)acc, dest.getDatabase());
        this.deleteDocument(oid);
    }

    public IRecordObject[] getUniqueIndexes(IAccountData acc, ISearchFormula form) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("getUniqueIndexes is not yet supported.");
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("search is not yet supported.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date startDate) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("searchByDate is not yet supported.");
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        String string = "getAllDatas";
        NotesDBStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        IFolderIndex folder = dest.getFolder();
        View l_viewObj = null;
        DocumentCollection l_docCollectionObj = null;
        this.initSession((NotesAccountData)acc, dest.getDatabase());
        l_viewObj = this.getView(folder);
        l_docCollectionObj = l_viewObj.getAllDocumentsByKey((Object)"", false);
        if (l_viewObj.getAllEntries().getCount() != l_docCollectionObj.getCount()) {
            ViewEntryCollection evc = l_viewObj.getAllEntries();
            ViewEntry entry = evc.getFirstEntry();
            while (entry != null) {
                Document doc = entry.getDocument();
                if (doc != null && l_docCollectionObj.getDocument(doc) == null) {
                    l_docCollectionObj.addDocument(doc);
                }
                entry = evc.getNextEntry();
            }
        }
        IRecordObject[] rc = null;
        try {
            rc = this.populateObjects(l_docCollectionObj);
        }
        finally {
            block18: {
                try {
                    try {
                        l_docCollectionObj.recycle();
                        l_viewObj.recycle();
                        l_docCollectionObj = null;
                        l_viewObj = null;
                    }
                    catch (Exception exception) {
                        this.recycleObjects();
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.recycleObjects();
                    throw throwable;
                }
                this.recycleObjects();
            }
        }
        return rc;
    }

    protected IRecordObject[] populateObjects(DocumentCollection col) throws HandleException {
        int cnt = 0;
        try {
            cnt = col.getCount();
        }
        catch (NotesException ne) {
            Log.error((String)"error getting count of DocumentCollection", (Throwable)ne);
            throw new IncorrectData(ne.getMessage());
        }
        IRecordObject[] rc = new IRecordObject[cnt];
        try {
            int i = 0;
            while (i < cnt) {
                Document doc = col.getNthDocument(i + 1);
                IRecordObject ro = this.populateObject(doc);
                doc.recycle();
                rc[i] = ro;
                ++i;
            }
        }
        catch (NotesException ne) {
            Log.error((String)"error getting count of DocumentCollection", (Throwable)ne);
        }
        return rc;
    }

    protected IRecordObject populateObject(Document doc) throws NotesException, HandleException {
        String id = doc.getUniversalID();
        return new NotesDBFieldSet(id, super.populateHashMap(doc));
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getFolders(acc, dest);
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        throw new HandleException("no preset destination supported.");
    }

    public static Object getBean(IRecordObject beanToBuild, IRecordObject src) throws Exception {
        if (!(beanToBuild instanceof BasicRecordObject)) {
            throw new HandleException("beanToBuild must be an instance of BasicRecordObject.");
        }
        BasicRecordObject bro = (BasicRecordObject)beanToBuild;
        bro.setOid(src.getOid());
        Class<?> c = beanToBuild.getClass();
        while (c != null) {
            String string = c.getName();
            NotesDBStoreImpl.debug_aroundBody11$advice(string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
            if (c.equals(BasicRecordObject.class)) break;
            Method[] m = c.getDeclaredMethods();
            int i = 0;
            while (i < m.length) {
                Class<?>[] param;
                String name = m[i].getName();
                if (name.startsWith("set") && (param = m[i].getParameterTypes()).length == 1) {
                    String string2 = "found setter:" + name;
                    NotesDBStoreImpl.debug_aroundBody13$advice(string2, LogAspect.aspectOf(), string2, null, ajc$tjp_6);
                    String fName = String.valueOf(name.substring(3, 4).toLowerCase()) + name.substring(4);
                    Object[] value = new Object[1];
                    HashMap fieldSet = src.getFieldSet();
                    value[0] = fieldSet.get(fName);
                    if (value[0] == null) {
                        fName = name.substring(3);
                        value[0] = fieldSet.get(fName);
                    }
                    if (value != null) {
                        Class<?> com = param[0].getComponentType();
                        Class<?>[] interfaces = param[0].getInterfaces();
                        boolean isArray = false;
                        if (com != null) {
                            interfaces = com.getInterfaces();
                            isArray = true;
                        }
                        boolean isIRecordElement = false;
                        int j = 0;
                        while (j < interfaces.length) {
                            Class<?> i_f = interfaces[j];
                            if (i_f.equals(IRecordElement.class)) {
                                isIRecordElement = true;
                                break;
                            }
                            ++j;
                        }
                        try {
                            if (isIRecordElement) {
                                IRecordElement helper = null;
                                if (isArray) {
                                    helper = (IRecordElement)com.newInstance();
                                    value[0] = helper.parseArrayInput(value[0]);
                                } else {
                                    helper = (IRecordElement)param[0].newInstance();
                                    helper.setRecordElementValue(value[0]);
                                    value[0] = helper;
                                }
                            }
                            m[i].invoke((Object)beanToBuild, value);
                            String string3 = "setting field " + fName + " value " + value[0] + " in method " + name + ":OK";
                            NotesDBStoreImpl.debug_aroundBody15$advice(string3, LogAspect.aspectOf(), string3, null, ajc$tjp_7);
                        }
                        catch (IllegalAccessException iae) {
                            String string4 = "skip setter set" + fName + " because of it is not public.";
                            NotesDBStoreImpl.debug_aroundBody17$advice(string4, LogAspect.aspectOf(), string4, null, ajc$tjp_8);
                        }
                        catch (Exception e) {
                            Log.error((String)("error setting field " + fName + " value " + value[0] + " in method " + name + ". continue.."), (Throwable)e);
                        }
                    }
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        return beanToBuild;
    }

    public HashMap<String, Object> generateHashMap(IRecordObject src) throws Exception {
        Class<?> c = src.getClass();
        HashMap<String, Object> h = new HashMap<String, Object>();
        while (c != null) {
            if (c.equals(BasicRecordObject.class)) break;
            Method[] m = c.getDeclaredMethods();
            int i = 0;
            while (i < m.length) {
                Class<?>[] param;
                String name = m[i].getName();
                if (name.startsWith("get") && (param = m[i].getParameterTypes()).length == 0) {
                    String string = "found getter:" + name;
                    NotesDBStoreImpl.debug_aroundBody19$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_9);
                    String fName = String.valueOf(name.substring(3, 4).toLowerCase()) + name.substring(4);
                    Object value = m[i].invoke((Object)src, null);
                    h.put(fName, value);
                    fName = name.substring(3);
                    value = m[i].invoke((Object)src, null);
                    h.put(fName, value);
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        return h;
    }

    public IRecordObject[] getDataSet(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        try {
            return this.getAllDatas(acc, dest);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
    }

    public IRecordObject getTableIndexFromString(String tableName) throws IncorrectData {
        if (tableName == null) {
            throw new NullPointerException("folder/table name must not be null");
        }
        BasicRecordObject rc = new BasicRecordObject();
        rc.setOid((IObjectIndex)new NotesFolderIndex(tableName));
        return rc;
    }

    public IRecordObject[] getUniqueIndexes(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("searchByDate is not yet supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchFormula form, IRecordObject data) throws Exception {
        ISearchDestination dest = form.getDest();
        return this.write(acc, dest, data);
    }

    private static final /* synthetic */ void debug_aroundBody0(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody14(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody15$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody18(NotesDBStoreImpl notesDBStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody19$advice(NotesDBStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotesDBStoreImpl.java", Class.forName("jp.co.connectone.eai.notes.store.NotesDBStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 93);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 179);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 181);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 274);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 375);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 385);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 424);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 427);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 456);
    }
}

