/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.eai.notes.log.LogAspect;
import jp.co.connectone.eai.notes.store.NotesFolderIndex;
import jp.co.connectone.eai.notes.store.NotesServiceInfo;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import lotus.domino.Database;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.DbDirectory;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.Session;
import lotus.domino.View;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class EAINotesBase {
    protected static Properties prop;
    private Session m_sessionObj = null;
    private DbDirectory m_dbDirObj = null;
    private Database m_dbObj = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    protected abstract String getElmentName();

    public IRecordObject getFolderIndexFromString(String path) throws IncorrectData {
        if (path == null) {
            path = this.getElmentName();
        }
        BasicRecordObject rc = new BasicRecordObject();
        rc.setOid((IObjectIndex)new NotesFolderIndex(path));
        HashMap<String, IObjectIndex> h = new HashMap<String, IObjectIndex>();
        h.put("IFolderIndex", rc.getOid());
        try {
            rc.setFieldSet(h);
        }
        catch (IllegalAccessException e) {
            Log.error((String)"getFolderIndexFromString:error on setting IFolderIndex", (Throwable)e);
            throw new IncorrectData("getFolderIndexFromString:error on setting IFolderIndex");
        }
        return rc;
    }

    private String getIORFromServer(String strMailSvr) throws IncorrectData {
        String l_strIor;
        block6: {
            l_strIor = null;
            String l_strURI1 = null;
            String l_strURI2 = null;
            String string = "getIORFromServer:strMailSvr=" + strMailSvr;
            EAINotesBase.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            if (strMailSvr.indexOf(":") > 0) {
                l_strURI1 = strMailSvr;
            } else {
                l_strURI1 = String.valueOf(strMailSvr) + ":80";
                l_strURI2 = String.valueOf(strMailSvr) + ":8080";
            }
            String string2 = "l_strURI1=" + l_strURI1;
            EAINotesBase.debug_aroundBody3$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_1);
            String string3 = "l_strURI2=" + l_strURI2;
            EAINotesBase.debug_aroundBody5$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_2);
            try {
                l_strIor = NotesFactory.getIOR((String)l_strURI1);
            }
            catch (NotesException e) {
                if (l_strURI2 == null) break block6;
                try {
                    l_strIor = NotesFactory.getIOR((String)l_strURI2);
                }
                catch (NotesException l_notesExObj) {
                    throw new IncorrectData(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
                }
            }
        }
        return l_strIor;
    }

    private String getIORFromFile(String strMailServer) throws DataNotFound {
        String l_strIor = null;
        try {
            String strIorFile = prop.getProperty("diiop");
            strIorFile = String.valueOf(strIorFile) + strMailServer + ".txt";
            String string = "IOR_filename:" + strIorFile;
            EAINotesBase.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
            FileInputStream l_fileInStreamObj = new FileInputStream(strIorFile);
            InputStreamReader l_inStremReaderObj = new InputStreamReader(l_fileInStreamObj);
            BufferedReader l_bufReaderObj = new BufferedReader(l_inStremReaderObj);
            l_strIor = l_bufReaderObj.readLine();
            l_fileInStreamObj.close();
        }
        catch (Exception l_fexcepObj) {
            throw new DataNotFound(l_fexcepObj.getMessage());
        }
        return l_strIor;
    }

    private void _init(String strUser, String strPassword, String strMailServer, String strMailServer2) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        String string = "_init:strUser=" + strUser;
        EAINotesBase.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
        if (prop == null) {
            try {
                prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.eai.notes");
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }
        String l_strIor = null;
        try {
            l_strIor = this.getIORFromFile(strMailServer);
        }
        catch (DataNotFound dataNotFound) {
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException("SYSTEM ERROR");
        }
        if (l_strIor == null) {
            try {
                l_strIor = this.getIORFromServer(strMailServer);
            }
            catch (IncorrectData e) {
                // empty catch block
            }
        }
        if (l_strIor == null) {
            Log.warn((String)("server " + strMailServer + " not respond. try " + strMailServer2 + "."));
            try {
                l_strIor = this.getIORFromServer(strMailServer2);
            }
            catch (IncorrectData e) {
                // empty catch block
            }
        }
        String string2 = "_init:l_strIor=" + l_strIor;
        EAINotesBase.debug_aroundBody11$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_5);
        if (l_strIor == null) {
            throw new ServerDown("could not get IOR from server: assume server is down");
        }
        try {
            this.m_sessionObj = NotesFactory.createSessionWithIOR((String)l_strIor, (String)strUser, (String)strPassword);
            String string3 = "_init:userName=" + this.m_sessionObj.getUserName();
            EAINotesBase.trace_aroundBody13$advice(this, string3, LogAspect.aspectOf(), string3, null, ajc$tjp_6);
            String string4 = "_init:commonUserName=" + this.m_sessionObj.getCommonUserName();
            EAINotesBase.trace_aroundBody15$advice(this, string4, LogAspect.aspectOf(), string4, null, ajc$tjp_7);
            this.m_dbDirObj = this.m_sessionObj.getDbDirectory(null);
        }
        catch (NotesException ne) {
            int errCode = ne.id;
            String msg = ne.getMessage();
            this.recycleObjects();
            throw new NoSuchRights("(" + errCode + ")" + msg);
        }
    }

    protected void initSession(NotesAccountData acc) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        String strUser = acc.getUserID();
        String strPassword = acc.getInternetPassword();
        NotesServiceInfo info = (NotesServiceInfo)acc.getServiceInfo();
        String strMailServer = info.getServerAddress();
        String strMailServer2 = info.getServerAddress2();
        String strMailDb = info.getDatabase();
        String string = "initSession:user=" + strUser + ":server=" + strMailServer + ":server2=" + strMailServer2 + ":db=" + strMailDb;
        EAINotesBase.debug_aroundBody17$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_8);
        this._init(strUser, strPassword, strMailServer, strMailServer2);
        try {
            this.m_dbObj = strMailDb == null ? this.m_dbDirObj.openMailDatabase() : this.m_dbDirObj.openDatabase(strMailDb);
        }
        catch (NotesException l_notesExObj) {
            String string2 = "failed to open mail database via openDatabase()/openMailDatabase()";
            EAINotesBase.debug_aroundBody19$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_9);
            throw new NoSuchRights(l_notesExObj.getMessage());
        }
    }

    protected void initSession(NotesAccountData acc, IDatabaseIndex database) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        String strUser = acc.getUserID();
        String strPassword = acc.getInternetPassword();
        NotesServiceInfo info = (NotesServiceInfo)acc.getServiceInfo();
        String strMailServer = info.getServerAddress();
        String strMailServer2 = info.getServerAddress2();
        String strDBName = database.getIndex().toString();
        String string = "initSession:user=" + strUser + ":server=" + strMailServer + ":server2=" + strMailServer2 + ":DB=" + strDBName;
        EAINotesBase.debug_aroundBody21$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_10);
        this._init(strUser, strPassword, strMailServer, strMailServer2);
        try {
            this.m_dbObj = strDBName == null ? this.m_dbDirObj.openMailDatabase() : this.m_dbDirObj.openDatabase(strDBName);
        }
        catch (NotesException l_notesExObj) {
            Log.error((String)("filed to Open Database " + strDBName), (Throwable)l_notesExObj);
            if (l_notesExObj.id == 4003) {
                throw new StoreNotFound("Store '" + strDBName + "' not found.");
            }
            throw new NoSuchRights(l_notesExObj.getMessage());
        }
    }

    protected DateTime getOffsetDateTime(int offsetDays) throws ServerDown, HandleException {
        if (this.m_sessionObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        DateTime l_dateTimeObj = null;
        try {
            l_dateTimeObj = this.m_sessionObj.createDateTime("Today");
            l_dateTimeObj.adjustDay(-1 * offsetDays);
        }
        catch (NotesException l_excepObj) {
            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
        }
        return l_dateTimeObj;
    }

    protected DocumentCollection search(String query, DateTime datetime) throws ServerDown, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        DocumentCollection col = null;
        try {
            col = this.m_dbObj.search(query, datetime);
        }
        catch (NotesException l_excepObj) {
            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
        }
        return col;
    }

    protected DateTime createDateTime(String dateStr) throws NullPointerException, ParseException {
        if (this.m_sessionObj == null) {
            throw new NullPointerException("EAINotesBase.initSession() must be called first.");
        }
        if (dateStr == null) {
            throw new NullPointerException("dateStr must not be null.");
        }
        DateTime l_dateTimeObj = null;
        try {
            l_dateTimeObj = this.m_sessionObj.createDateTime(dateStr);
        }
        catch (NotesException l_excepObj) {
            throw new ParseException("date string format couldn't parsed by Notes Session Object", 0);
        }
        return l_dateTimeObj;
    }

    protected DateTime createDateTime(Date date) throws NullPointerException {
        if (this.m_sessionObj == null) {
            throw new NullPointerException("EAINotesBase.initSession() must be called first.");
        }
        if (date == null) {
            throw new NullPointerException("date must not be null.");
        }
        DateTime l_dateTimeObj = null;
        try {
            l_dateTimeObj = this.m_sessionObj.createDateTime(date);
        }
        catch (NotesException notesException) {
            // empty catch block
        }
        return l_dateTimeObj;
    }

    protected DateRange createDateRange(Date startDate, Date endDate) throws ServerDown, HandleException {
        if (this.m_sessionObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        DateTime l_dateTimeStartObj = null;
        DateTime l_dateTimeEndObj = null;
        DateRange l_dateRangeObj = null;
        try {
            l_dateTimeStartObj = this.m_sessionObj.createDateTime(startDate);
            l_dateTimeEndObj = this.m_sessionObj.createDateTime(endDate);
        }
        catch (NotesException l_excepObj) {
            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
        }
        try {
            try {
                l_dateRangeObj = this.m_sessionObj.createDateRange(l_dateTimeStartObj, l_dateTimeEndObj);
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            try {
                if (l_dateTimeStartObj != null) {
                    l_dateTimeStartObj.recycle();
                }
                if (l_dateTimeEndObj != null) {
                    l_dateTimeEndObj.recycle();
                }
            }
            catch (NotesException notesException) {}
        }
        return l_dateRangeObj;
    }

    protected DateRange createDateRange(String datePoint, int offsetDays, boolean isPointStartDate) throws ServerDown, HandleException {
        if (this.m_sessionObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        DateTime l_dateTimeStartObj = null;
        DateTime l_dateTimeEndObj = null;
        DateRange l_dateRangeObj = null;
        try {
            l_dateTimeStartObj = this.m_sessionObj.createDateTime(datePoint);
            l_dateTimeEndObj = this.m_sessionObj.createDateTime(datePoint);
            if (isPointStartDate) {
                l_dateTimeEndObj.adjustDay(offsetDays);
            } else {
                l_dateTimeStartObj.adjustDay(-1 * offsetDays);
            }
        }
        catch (NotesException l_excepObj) {
            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
        }
        try {
            try {
                l_dateRangeObj = this.m_sessionObj.createDateRange(l_dateTimeStartObj, l_dateTimeEndObj);
            }
            catch (NotesException l_excepObj) {
                throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
            }
        }
        finally {
            try {
                if (l_dateTimeStartObj != null) {
                    l_dateTimeStartObj.recycle();
                }
                if (l_dateTimeEndObj != null) {
                    l_dateTimeEndObj.recycle();
                }
            }
            catch (NotesException notesException) {}
        }
        return l_dateRangeObj;
    }

    protected Document CreateDocument() throws DataNotFound, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Document d = null;
        try {
            d = this.m_dbObj.createDocument();
        }
        catch (NotesException l_notesExcepObj) {
            throw new DataNotFound(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return d;
    }

    protected Vector<View> getViews() throws ServerDown, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Vector v = null;
        try {
            v = this.m_dbObj.getViews();
        }
        catch (NotesException e) {
            throw new ServerDown(String.valueOf(e.id) + e.text);
        }
        return v;
    }

    protected View getView(IFolderIndex folder) throws ServerDown, HandleException {
        String viewName = folder.getIndex().toString();
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        View v = null;
        try {
            v = this.m_dbObj.getView(viewName);
        }
        catch (NotesException e) {
            Log.error((String)"NotesException on getView", (Throwable)e);
            throw new ServerDown(String.valueOf(e.id) + e.text);
        }
        return v;
    }

    protected String getUNID(IObjectIndex idx) {
        return (String)idx.getIndex();
    }

    protected Document getDocument(IObjectIndex idx) throws DataNotFound, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Document d = null;
        try {
            d = this.m_dbObj.getDocumentByUNID(this.getUNID(idx));
        }
        catch (NotesException l_notesExcepObj) {
            throw new DataNotFound(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return d;
    }

    protected void deleteDocument(IObjectIndex idx) throws DataNotFound, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Document d = null;
        String unid = this.getUNID(idx);
        try {
            d = this.m_dbObj.getDocumentByUNID(unid);
            d.remove(true);
            d.recycle();
            d = null;
            String string = "document " + unid + " deleted";
            EAINotesBase.debug_aroundBody23$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_11);
        }
        catch (NotesException l_notesExcepObj) {
            throw new DataNotFound(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
    }

    protected Document getDocumentByUNID(IObjectIndex strReferenceUID) throws DataNotFound, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Document d = null;
        try {
            d = this.m_dbObj.getDocumentByUNID((String)strReferenceUID.getIndex());
        }
        catch (NotesException l_notesExcepObj) {
            throw new DataNotFound(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return d;
    }

    protected Document createDocument() throws NoSuchRights, HandleException {
        if (this.m_dbObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        Document d = null;
        try {
            d = this.m_dbObj.createDocument();
        }
        catch (NotesException l_notesExcepObj) {
            throw new NoSuchRights(String.valueOf(l_notesExcepObj.id) + l_notesExcepObj.text);
        }
        return d;
    }

    protected void recycleObjects() throws ServerDown {
        try {
            if (this.m_dbObj != null) {
                this.m_dbObj.recycle();
            }
            if (this.m_dbDirObj != null) {
                this.m_dbDirObj.recycle();
            }
            if (this.m_sessionObj != null) {
                this.m_sessionObj.recycle();
            }
        }
        catch (NotesException l_exceptionObj) {
            throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
        }
    }

    protected void updateFieldsFromNotesDBFieldSet(Document doc, IRecordObject objRecord) throws HandleException {
        HashMap fieldSet = null;
        try {
            fieldSet = objRecord.getFieldSet();
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
        Vector items = null;
        try {
            items = doc.getItems();
        }
        catch (NotesException l_exceptionObj) {
            throw new HandleException(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
        }
        Enumeration en = items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            try {
                String name = item.getName();
                String strValue = item.getValueString();
                String string = "Item (" + name + ":" + strValue + ")";
                EAINotesBase.trace_aroundBody25$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_12);
                String name_ignoreCase = name.toUpperCase();
                Object o = fieldSet.get(name_ignoreCase);
                if (o != null) {
                    if (o instanceof Date) {
                        Date d = (Date)o;
                        item.setDateTimeValue(this.createDateTime(d));
                    } else if (o instanceof String) {
                        String s = (String)o;
                        item.setValueString(s);
                    } else if (o instanceof Integer) {
                        Integer itg = (Integer)o;
                        int i = itg;
                        item.setValueInteger(i);
                    } else if (o instanceof Double) {
                        Double dbl = (Double)o;
                        double d = dbl;
                        item.setValueDouble(d);
                    }
                }
                strValue = item.getValueString();
                String string2 = "changed (" + name + ":" + strValue + ")";
                EAINotesBase.trace_aroundBody27$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_13);
            }
            catch (NotesException l_exceptionObj) {
                throw new HandleException(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
            }
        }
    }

    protected HashMap<String, Object> populateHashMap(Document doc) throws HandleException {
        HashMap<String, Object> rc = new HashMap<String, Object>();
        Vector items = null;
        try {
            items = doc.getItems();
        }
        catch (NotesException l_exceptionObj) {
            throw new HandleException(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
        }
        Enumeration en = items.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            try {
                String name = item.getName();
                Object value = null;
                switch (item.getType()) {
                    case 0: 
                    case 256: 
                    case 512: {
                        throw new HandleException("Notes item returned ERRITEM/UNAVAILABLE/UNKNOWN on getType");
                    }
                    case 6: 
                    case 1084: 
                    case 1085: 
                    case 1090: {
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 1074: 
                    case 1075: 
                    case 1076: 
                    case 1280: 
                    case 1536: 
                    case 1792: {
                        value = item.getValueString();
                        break;
                    }
                    case 1024: {
                        try {
                            value = item.getDateTimeValue().toJavaDate();
                        }
                        catch (Exception e) {
                            String string = "DATETIME conversion error:" + name;
                            EAINotesBase.trace_aroundBody29$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_14);
                        }
                        break;
                    }
                    case 768: {
                        int in = item.getValueInteger();
                        double dn = item.getValueDouble();
                        String string = "integer number=" + in + ".double number=" + dn;
                        EAINotesBase.trace_aroundBody31$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_15);
                        if ((double)in == dn) {
                            value = new Integer(in);
                            break;
                        }
                        value = new Double(dn);
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                rc.put(name, value);
            }
            catch (NotesException l_exceptionObj) {
                throw new HandleException(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
            }
        }
        return rc;
    }

    protected String getUserID(NotesAccountData acc) {
        if (acc == null) {
            return null;
        }
        return acc.getUserID();
    }

    protected String getInternetPassword(NotesAccountData acc) {
        if (acc == null) {
            return null;
        }
        return acc.getInternetPassword();
    }

    protected String getServerAddress(NotesAccountData acc) {
        if (acc == null) {
            return null;
        }
        return acc.getServiceInfo().getServerAddress();
    }

    protected String getCommonUserNameFromSession() throws HandleException {
        String commonUserName = "";
        if (this.m_sessionObj == null) {
            throw new HandleException("EAINotesBase.initSession() must be called first.");
        }
        try {
            commonUserName = this.m_sessionObj.getCommonUserName();
        }
        catch (NotesException l_excepObj) {
            throw new ServerDown(String.valueOf(l_excepObj.id) + l_excepObj.text);
        }
        return commonUserName;
    }

    protected String getAccountStringFromFullname(String src) {
        String notesId = "";
        if (src.startsWith("CN=")) {
            int atIndx = src.indexOf(64);
            if (atIndx != -1) {
                src = src.substring(0, atIndx);
            }
            StringTokenizer sParser = new StringTokenizer(src, "/");
            String sPart = "";
            while (sParser.hasMoreTokens()) {
                sPart = sParser.nextToken();
                sPart = sPart.substring(sPart.indexOf("=") + 1);
                notesId = sParser.hasMoreTokens() ? String.valueOf(notesId) + sPart + "/" : String.valueOf(notesId) + sPart;
            }
        }
        if (notesId.length() == 0) {
            return src;
        }
        return notesId;
    }

    protected String getFilePath() throws HandleException {
        String dbName = null;
        try {
            dbName = this.m_dbObj.getFilePath();
        }
        catch (NotesException ne) {
            throw new HandleException(String.valueOf(ne.id) + ne.text);
        }
        return dbName;
    }

    static {
        EAINotesBase.ajc$preClinit();
    }

    private static final /* synthetic */ void debug_aroundBody0(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody12(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody13$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody14(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody15$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody16(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody17$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody18(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody19$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody20(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody21$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody22(EAINotesBase eAINotesBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody23$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody24(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody25$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody26(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody27$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody28(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody29$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody30(EAINotesBase eAINotesBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody31$advice(EAINotesBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EAINotesBase.java", Class.forName("jp.co.connectone.eai.notes.store.EAINotesBase"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 41);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 49);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 183);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 448);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 529);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 553);
        ajc$tjp_14 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 609);
        ajc$tjp_15 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 615);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 50);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 77);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 94);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 131);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 137);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 138);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 158);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 170);
    }
}

