/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.webapps.log;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.log.SubmitType;

public class AuditLog {
    protected String userId = "";
    protected String httpHeaderUserAgent = "";
    protected String strCmd = "";
    protected String strFc = "";
    protected String strSubmit = "";
    protected static final AuditLog theSingleton = new AuditLog();
    protected static final String logFormat = "%1$s,%2$s,%3$s/%4$s";
    protected static final String logFormatPlusSubmit = "%1$s,%2$s,%3$s/%4$s/%5$s";
    protected static final String logAuthFail = "Authentication Failed:%1$s,%2$s";

    public static AuditLog getInstance() {
        return theSingleton;
    }

    public void output(boolean authSuccess) throws HandleException {
        if (this.strCmd == null) {
            this.strCmd = "Menu";
        }
        if (this.strCmd.length() == 0) {
            this.strCmd = "Menu";
        }
        String outputStr = "";
        try {
            outputStr = this.selectLogFormat(authSuccess);
        }
        catch (Exception e) {
            Log.fatal((String)"PANIC:can't create audit-log formatted text.", (Throwable)e);
            outputStr = "userId=" + this.userId + ",UserAgent=" + this.httpHeaderUserAgent + ",cmd/fc=" + this.strCmd + "/" + this.strFc;
        }
        Log.info((String)outputStr);
    }

    private String selectLogFormat(boolean authSuccess) {
        String outputStr = authSuccess ? (this.strSubmit != null ? String.format(logFormatPlusSubmit, this.userId, this.httpHeaderUserAgent, this.strCmd, this.strFc, this.getDisplaySubmitValue()) : String.format(logFormat, this.userId, this.httpHeaderUserAgent, this.strCmd, this.strFc)) : String.format(logAuthFail, this.userId, this.httpHeaderUserAgent);
        if (outputStr.endsWith("/")) {
            outputStr = outputStr.substring(0, outputStr.length() - 1);
        }
        return outputStr;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getHttpHeaderUserAgent() {
        return this.httpHeaderUserAgent;
    }

    public void setHttpHeaderUserAgent(String httpHeaderUserAgent) {
        this.httpHeaderUserAgent = httpHeaderUserAgent;
    }

    public String getStrCmd() {
        return this.strCmd;
    }

    public void setStrCmd(String strCmd) {
        this.strCmd = strCmd;
    }

    public String getStrFc() {
        return this.strFc;
    }

    public void setStrFc(String strFc) {
        this.strFc = strFc;
    }

    public String getStrSubmit() {
        return this.strSubmit;
    }

    public void setStrSubmit(String strSubmit) {
        this.strSubmit = strSubmit;
    }

    private String getDisplaySubmitValue() {
        String value = "";
        SubmitType type = SubmitType.get(this.strSubmit);
        if (type != SubmitType.UNKNOWN) {
            value = type.toString();
        }
        return value;
    }
}

