/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.store;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.AndTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.pop3.store.Pop3ObjectIndexRawDataDateAndSubject;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.pim.MailAddress;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class EAIPop3Base {
    private static final int DEFAULT_POP3_PORT = -1;
    protected int port = -1;
    private String serverAddress;
    private String path;
    private String userID;
    private String password;
    private String mailAddress;
    protected Store store = null;
    protected Folder folder = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public void finalize() {
        if (this.store != null) {
            this.close();
        }
    }

    protected void close() {
        if (this.store == null) {
            return;
        }
        try {
            if (this.folder != null) {
                this.folder.close(false);
                this.folder = null;
            }
            this.store.close();
            this.store = null;
        }
        catch (MessagingException me) {
            Log.error((String)"error closing pop3 store.", (Throwable)me);
        }
    }

    protected void setServerAddress(String serverAddress) throws ServerDown, HandleException {
        this.serverAddress = serverAddress;
    }

    protected Vector<HashMap<String, Object>> search(String storeURL, Vector<String> itemList, SearchConditionCollection conds) throws NullPointerException, ServerDown, HandleException {
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        Vector<HashMap<String, Object>> lists = new Vector<HashMap<String, Object>>();
        return lists;
    }

    protected Message[] getListByDate(String storeURL, Vector<String> itemList, Date date) throws NullPointerException, StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        Message[] list = null;
        Date date2 = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date = cal.getTime();
        cal.add(5, 1);
        date2 = cal.getTime();
        try {
            this.openFolder(1);
            list = this.folder.search((SearchTerm)new AndTerm((SearchTerm)new SentDateTerm(6, date), (SearchTerm)new SentDateTerm(2, date2)));
            String string = "number of messages are " + list.length;
            EAIPop3Base.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectStore(me.getMessage());
        }
        return list;
    }

    protected Message[] getList(String storeURL, Vector<String> itemList) throws NullPointerException, StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (itemList == null) {
            return null;
        }
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        Message[] list = null;
        try {
            this.openFolder(1);
            list = this.folder.getMessages();
            String string = "number of messages are " + list.length;
            EAIPop3Base.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectStore(me.getMessage());
        }
        return list;
    }

    protected MimeMessage getMail(String messageID) throws NullPointerException, StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        MimeMessage msg = null;
        Message[] list = null;
        this.openFolder(1);
        try {
            list = this.folder.search((SearchTerm)new MessageIDTerm(messageID));
            String string = "number of messages are " + list.length;
            EAIPop3Base.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectStore(me.getMessage());
        }
        msg = (MimeMessage)list[0];
        return msg;
    }

    protected MimeMessage getMail(Pop3ObjectIndexRawDataDateAndSubject dateAndSubject) throws NullPointerException, StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        MimeMessage msg = null;
        Message[] list = null;
        this.openFolder(1);
        try {
            list = this.folder.search((SearchTerm)new ReceivedDateTerm(3, dateAndSubject.getDate()));
            list = this.folder.search((SearchTerm)new SubjectTerm(dateAndSubject.getSubject()), list);
            String string = "number of messages are " + list.length;
            EAIPop3Base.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectStore(me.getMessage());
        }
        msg = (MimeMessage)list[0];
        return msg;
    }

    private void openFolder(int mode) throws IncorrectStore, HandleException {
        this.connect(this.serverAddress, this.port);
        if (this.folder == null) {
            try {
                this.folder = this.store.getFolder("INBOX");
                if (this.folder == null) {
                    throw new IncorrectStore("store returns null folder");
                }
                this.folder.open(mode);
            }
            catch (MessagingException me) {
                me.printStackTrace();
                throw new IncorrectStore(me.getMessage());
            }
        }
    }

    protected int delete(String messageID) throws NullPointerException, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        int mode = 2;
        this.openFolder(mode);
        int code = 0;
        MimeMessage msg = null;
        try {
            msg = this.getMail(messageID);
        }
        catch (HandleException dnf) {
            Log.error((String)"error on getting message.", (Throwable)dnf);
            return -1;
        }
        try {
            try {
                msg.setFlag(Flags.Flag.DELETED, true);
                this.folder.close(true);
                this.folder = null;
            }
            catch (MessagingException me) {
                Log.error((String)"error on deleting mail.", (Throwable)me);
                this.close();
            }
        }
        finally {
            this.close();
        }
        return code;
    }

    protected int delete(Pop3ObjectIndexRawDataDateAndSubject dateAndSubject) throws NullPointerException, HandleException {
        if (this.userID == null) {
            throw new NullPointerException("set userID first");
        }
        if (this.password == null) {
            throw new NullPointerException("set password first");
        }
        if (this.serverAddress == null) {
            throw new NullPointerException("set serverAddress first");
        }
        int mode = 2;
        this.openFolder(mode);
        int code = 0;
        MimeMessage msg = null;
        try {
            msg = this.getMail(dateAndSubject);
        }
        catch (HandleException dnf) {
            Log.error((String)"error on getting message.", (Throwable)dnf);
            return -1;
        }
        try {
            try {
                msg.setFlag(Flags.Flag.DELETED, true);
                this.folder.close(true);
                this.folder = null;
            }
            catch (MessagingException me) {
                Log.error((String)"error on deleting mail.", (Throwable)me);
                this.close();
            }
        }
        finally {
            this.close();
        }
        return code;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getUserID() {
        return this.userID;
    }

    protected void setUserID(String userID) {
        this.userID = userID;
    }

    protected String getStringFromMessage(MimeMessage mmsg) {
        if (mmsg == null) {
            return null;
        }
        String msg = "";
        try {
            String tmp;
            Enumeration lines = mmsg.getAllHeaderLines();
            while (lines.hasMoreElements()) {
                msg = String.valueOf(msg) + (String)lines.nextElement() + "\r\n";
            }
            msg = String.valueOf(msg) + "\r\n";
            String string = "Header Line Dump\n============================\n" + msg;
            EAIPop3Base.trace_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
            InputStream is = mmsg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is));
            while ((tmp = b.readLine()) != null) {
                msg = String.valueOf(msg) + tmp + "\r\n";
            }
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
            e.printStackTrace();
        }
        return msg;
    }

    protected String populateMessageFile(Hashtable<String, String> itemList) {
        String msg = "";
        String subject = itemList.get("urn:schemas:httpmail:subject");
        String body = itemList.get("urn:schemas:httpmail:textdescription");
        String from = itemList.get("urn:schemas:httpmail:sendername");
        if (from == null) {
            from = itemList.get("urn:schemas:httpmail:from");
        }
        try {
            MimeMessage mmsg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart pbody = new MimeBodyPart();
            pbody.setText(body, "UTF-8");
            part.addBodyPart((BodyPart)pbody);
            mmsg.setSubject(subject, "UTF-8");
            if (from != null) {
                String name;
                MailAddress add = new MailAddress(from);
                String address = add.getAddressPart();
                if (address.equals(name = add.getNamePart())) {
                    mmsg.setFrom((Address)new InternetAddress(address, name, "UTF-8"));
                } else {
                    mmsg.setFrom((Address)new InternetAddress(address));
                }
            }
            mmsg.setContent((Multipart)part);
            mmsg.saveChanges();
            msg = this.getStringFromMessage(mmsg);
        }
        catch (Exception e) {
            Log.error((String)"Exception on creating MimeMessage", (Throwable)e);
            e.printStackTrace();
        }
        return msg;
    }

    protected void connect(String server, int port) throws ServerDown, NoSuchRights, HandleException {
        if (this.store != null) {
            return;
        }
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            this.store = session.getStore("pop3");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new HandleException((Throwable)nspe);
        }
        try {
            this.store.connect(server, port, this.userID, this.password);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            if (me instanceof AuthenticationFailedException) {
                throw new NoSuchRights(me.getMessage());
            }
            throw new ServerDown(me.getMessage());
        }
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    protected FolderMetadata populateFolder(IFolderIndex idx) {
        FolderMetadata folder = new FolderMetadata();
        folder.setOid((IObjectIndex)idx);
        HashMap<String, IFolderIndex> h = new HashMap<String, IFolderIndex>();
        h.put("oid", idx);
        folder.setFieldSet(h);
        folder.setFolderName(idx.getIndex().toString());
        return folder;
    }

    static {
        EAIPop3Base.ajc$preClinit();
    }

    private static final /* synthetic */ void debug_aroundBody0(EAIPop3Base eAIPop3Base, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(EAIPop3Base ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(EAIPop3Base eAIPop3Base, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(EAIPop3Base ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(EAIPop3Base eAIPop3Base, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(EAIPop3Base ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(EAIPop3Base eAIPop3Base, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(EAIPop3Base ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody8(EAIPop3Base eAIPop3Base, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody9$advice(EAIPop3Base ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EAIPop3Base.java", Class.forName("jp.co.connectone.eai.pop3.store.EAIPop3Base"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 83);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 103);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 122);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 143);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 300);
    }
}

