/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Vector;
import jregex.LAEntry;
import jregex.MatchIterator;
import jregex.MatchResult;
import jregex.MemReg;
import jregex.Pattern;
import jregex.SearchEntry;
import jregex.Term;
import jregex.TextBuffer;

public class Matcher
implements MatchResult {
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_LASTMATCH = 2;
    public static final int ANCHOR_END = 4;
    public static final int ACCEPT_INCOMPLETE = 8;
    private static Term startAnchor = new Term(18);
    private static Term lastMatchAnchor = new Term(23);
    private Pattern re;
    private int[] counters;
    private MemReg[] memregs;
    private LAEntry[] lookaheads;
    private int counterCount;
    private int memregCount;
    private int lookaheadCount;
    private char[] data;
    private int offset;
    private int end;
    private int wOffset;
    private int wEnd;
    private boolean shared;
    private SearchEntry top;
    private SearchEntry first;
    private SearchEntry defaultEntry;
    private boolean called;
    private int minQueueLength;
    private String cache;
    private int cacheOffset;
    private int cacheLength;
    private MemReg prefixBounds;
    private MemReg suffixBounds;
    private MemReg targetBounds;

    Matcher(Pattern pattern) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        this.re = pattern;
        int n4 = pattern.memregs;
        if (n4 > 0) {
            objectArray = new MemReg[n4];
            n3 = 0;
            while (n3 < n4) {
                objectArray[n3] = new MemReg(-1);
                ++n3;
            }
            this.memregs = objectArray;
        }
        if ((n2 = pattern.counters) > 0) {
            this.counters = new int[n2];
        }
        if ((n = pattern.lookaheads) > 0) {
            objectArray = new LAEntry[n];
            n3 = 0;
            while (n3 < n) {
                objectArray[n3] = new LAEntry();
                ++n3;
            }
            this.lookaheads = objectArray;
        }
        this.memregCount = n4;
        this.counterCount = n2;
        this.lookaheadCount = n;
        this.first = new SearchEntry();
        this.defaultEntry = new SearchEntry();
        this.minQueueLength = pattern.stringRepr.length() / 2;
    }

    public final void setTarget(Matcher matcher, int n) {
        MemReg memReg = matcher.bounds(n);
        if (memReg == null) {
            throw new IllegalArgumentException("group #" + n + " is not assigned");
        }
        this.data = matcher.data;
        this.offset = memReg.in;
        this.end = memReg.out;
        this.cache = matcher.cache;
        this.cacheLength = matcher.cacheLength;
        this.cacheOffset = matcher.cacheOffset;
        if (matcher != this) {
            this.shared = true;
            matcher.shared = true;
        }
        this.init();
    }

    public void setTarget(String string) {
        this.setTarget(string, 0, string.length());
    }

    public void setTarget(String string, int n, int n2) {
        char[] cArray = this.data;
        if (cArray == null || this.shared || cArray.length < n2) {
            this.data = cArray = new char[(int)(1.7f * (float)n2)];
            this.shared = false;
        }
        string.getChars(n, n2, cArray, 0);
        this.offset = 0;
        this.end = n2;
        this.cache = string;
        this.cacheOffset = -n;
        this.cacheLength = string.length();
        this.init();
    }

    public void setTarget(char[] cArray, int n, int n2) {
        this.setTarget(cArray, n, n2, true);
    }

    public final void setTarget(char[] cArray, int n, int n2, boolean bl) {
        this.cache = null;
        this.data = cArray;
        this.offset = n;
        this.end = n + n2;
        this.shared = bl;
        this.init();
    }

    public void setTarget(Reader reader, int n) throws IOException {
        int n2;
        if (n < 0) {
            this.setAll(reader);
            return;
        }
        char[] cArray = this.data;
        boolean bl = this.shared;
        if (cArray == null || bl || cArray.length < n) {
            cArray = new char[n];
            bl = false;
        }
        int n3 = 0;
        while ((n2 = reader.read(cArray, n3, n)) >= 0) {
            n3 += n2;
            if ((n -= n2) == 0) break;
        }
        this.setTarget(cArray, 0, n3, bl);
    }

    private void setAll(Reader reader) throws IOException {
        int n;
        int n2;
        char[] cArray = this.data;
        boolean bl = this.shared;
        if (cArray == null || bl) {
            n2 = 1024;
            cArray = new char[1024];
            bl = false;
        } else {
            n2 = cArray.length;
        }
        int n3 = 0;
        while ((n = reader.read(cArray, n3, n2)) >= 0) {
            n3 += n;
            if ((n2 -= n) != 0) continue;
            int n4 = n3 * 3;
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
            n2 = n4 - n3;
            bl = false;
        }
        this.setTarget(cArray, 0, n3, bl);
    }

    private final String getString(int n, int n2) {
        String string = this.cache;
        if (string != null) {
            int n3 = this.cacheOffset;
            return string.substring(n - n3, n2 - n3);
        }
        int n4 = this.end;
        int n5 = this.offset;
        int n6 = n4 - n5;
        char[] cArray = this.data;
        if (n2 - n >= n6 / 3) {
            this.cache = string = new String(cArray, n5, n6);
            this.cacheOffset = n5;
            this.cacheLength = n6;
            return string.substring(n - n5, n2 - n5);
        }
        return new String(cArray, n, n2 - n);
    }

    public final boolean matchesPrefix() {
        this.setPosition(0);
        return this.search(13);
    }

    public final boolean isStart() {
        return this.matchesPrefix();
    }

    public final boolean matches() {
        if (this.called) {
            this.setPosition(0);
        }
        return this.search(5);
    }

    public final boolean matches(String string) {
        this.setTarget(string);
        return this.search(5);
    }

    public void setPosition(int n) {
        this.wOffset = this.offset + n;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    public final boolean find() {
        if (this.called) {
            this.skip();
        }
        return this.search(0);
    }

    public final boolean find(int n) {
        if (this.called) {
            this.skip();
        }
        return this.search(n);
    }

    public MatchIterator findAll() {
        return this.findAll(0);
    }

    public MatchIterator findAll(final int n) {
        return new MatchIterator(){
            private boolean checked = false;
            private boolean hasMore = false;

            public boolean hasMore() {
                if (!this.checked) {
                    this.check();
                }
                return this.hasMore;
            }

            public MatchResult nextMatch() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.checked = false;
                return Matcher.this;
            }

            private final void check() {
                this.hasMore = Matcher.this.find(n);
                this.checked = true;
            }

            public int count() {
                if (!this.checked) {
                    this.check();
                }
                if (!this.hasMore) {
                    return 0;
                }
                int n2 = 1;
                while (Matcher.this.find(n)) {
                    ++n2;
                }
                this.checked = false;
                return n2;
            }
        };
    }

    public final boolean proceed() {
        return this.proceed(0);
    }

    public final boolean proceed(int n) {
        if (this.called && this.top == null) {
            ++this.wOffset;
        }
        return this.search(0);
    }

    public final void skip() {
        int n = this.wEnd;
        if (this.wOffset == n) {
            if (this.top == null) {
                ++this.wOffset;
                this.flush();
            }
            return;
        }
        this.wOffset = n < 0 ? 0 : n;
        this.flush();
    }

    private final void init() {
        this.wOffset = this.offset;
        this.wEnd = -1;
        this.called = false;
        this.flush();
    }

    private final void flush() {
        this.top = null;
        this.defaultEntry.reset(0);
        this.first.reset(this.minQueueLength);
        int n = this.memregs.length - 1;
        while (n > 0) {
            MemReg memReg = this.memregs[n];
            memReg.out = -1;
            memReg.in = -1;
            --n;
        }
        int n2 = this.memregs.length - 1;
        while (n2 > 0) {
            MemReg memReg = this.memregs[n2];
            memReg.out = -1;
            memReg.in = -1;
            --n2;
        }
        this.called = false;
    }

    private final void rflush() {
        SearchEntry searchEntry = this.top;
        this.top = null;
        MemReg[] memRegArray = this.memregs;
        int[] nArray = this.counters;
        while (searchEntry != null) {
            SearchEntry searchEntry2 = searchEntry.sub;
            SearchEntry.popState(searchEntry, memRegArray, nArray);
            searchEntry = searchEntry2;
        }
        SearchEntry.popState(this.defaultEntry, memRegArray, nArray);
    }

    public String toString() {
        return this.getString(this.wOffset, this.wEnd);
    }

    public Pattern pattern() {
        return this.re;
    }

    public String target() {
        return this.getString(this.offset, this.end);
    }

    public char[] targetChars() {
        this.shared = true;
        return this.data;
    }

    public int targetStart() {
        return this.offset;
    }

    public int targetEnd() {
        return this.end;
    }

    public char charAt(int n) {
        int n2 = this.wOffset;
        int n3 = this.wEnd;
        if (n2 < 0 || n3 < n2) {
            throw new IllegalStateException("unassigned");
        }
        return this.data[n2 + n];
    }

    public char charAt(int n, int n2) {
        MemReg memReg = this.bounds(n2);
        if (memReg == null) {
            throw new IllegalStateException("group #" + n2 + " is not assigned");
        }
        int n3 = memReg.in;
        if (n < 0 || n > memReg.out - n3) {
            throw new StringIndexOutOfBoundsException("" + n);
        }
        return this.data[n3 + n];
    }

    public final int length() {
        return this.wEnd - this.wOffset;
    }

    public final int start() {
        return this.wOffset - this.offset;
    }

    public final int end() {
        return this.wEnd - this.offset;
    }

    public String prefix() {
        return this.getString(this.offset, this.wOffset);
    }

    public String suffix() {
        return this.getString(this.wEnd, this.end);
    }

    public int groupCount() {
        return this.memregs.length;
    }

    public String group(int n) {
        MemReg memReg = this.bounds(n);
        if (memReg == null) {
            return null;
        }
        return this.getString(memReg.in, memReg.out);
    }

    public String group(String string) {
        Integer n = this.re.groupId(string);
        if (n == null) {
            throw new IllegalArgumentException("<" + string + "> isn't defined");
        }
        return this.group(n);
    }

    public boolean getGroup(int n, TextBuffer textBuffer) {
        MemReg memReg = this.bounds(n);
        if (memReg == null) {
            return false;
        }
        int n2 = memReg.in;
        textBuffer.append(this.data, n2, memReg.out - n2);
        return true;
    }

    public boolean getGroup(String string, TextBuffer textBuffer) {
        Integer n = this.re.groupId(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.getGroup((int)n, textBuffer);
    }

    public boolean getGroup(int n, StringBuffer stringBuffer) {
        MemReg memReg = this.bounds(n);
        if (memReg == null) {
            return false;
        }
        int n2 = memReg.in;
        stringBuffer.append(this.data, n2, memReg.out - n2);
        return true;
    }

    public boolean getGroup(String string, StringBuffer stringBuffer) {
        Integer n = this.re.groupId(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.getGroup((int)n, stringBuffer);
    }

    public String[] groups() {
        MemReg[] memRegArray = this.memregs;
        String[] stringArray = new String[memRegArray.length];
        int n = 0;
        while (n < memRegArray.length) {
            MemReg memReg = memRegArray[n];
            int n2 = memReg.in;
            int n3 = memReg.out;
            n2 = memReg.in;
            if (n2 >= 0 && memReg.out >= n2) {
                stringArray[n] = this.getString(n2, n3);
            }
            ++n;
        }
        return stringArray;
    }

    public Vector groupv() {
        MemReg[] memRegArray = this.memregs;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < memRegArray.length) {
            MemReg memReg = this.bounds(n);
            if (memReg == null) {
                vector.addElement("empty");
            } else {
                String string = this.getString(memReg.in, memReg.out);
                vector.addElement(string);
            }
            ++n;
        }
        return vector;
    }

    private final MemReg bounds(int n) {
        MemReg memReg;
        if (n >= 0) {
            memReg = this.memregs[n];
        } else {
            switch (n) {
                case -1: {
                    memReg = this.prefixBounds;
                    if (memReg == null) {
                        this.prefixBounds = memReg = new MemReg(-1);
                    }
                    memReg.in = this.offset;
                    memReg.out = this.wOffset;
                    break;
                }
                case -2: {
                    memReg = this.suffixBounds;
                    if (memReg == null) {
                        this.suffixBounds = memReg = new MemReg(-2);
                    }
                    memReg.in = this.wEnd;
                    memReg.out = this.end;
                    break;
                }
                case -3: {
                    memReg = this.targetBounds;
                    if (memReg == null) {
                        this.targetBounds = memReg = new MemReg(-3);
                    }
                    memReg.in = this.offset;
                    memReg.out = this.end;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal group id: " + n + "; must either nonnegative int, or MatchResult.PREFIX, or MatchResult.SUFFIX");
                }
            }
        }
        int n2 = memReg.in;
        if (n2 < 0 || memReg.out < n2) {
            return null;
        }
        return memReg;
    }

    public final boolean isCaptured() {
        return this.wOffset >= 0 && this.wEnd >= this.wOffset;
    }

    public final boolean isCaptured(int n) {
        return this.bounds(n) != null;
    }

    public final boolean isCaptured(String string) {
        Integer n = this.re.groupId(string);
        if (n == null) {
            throw new IllegalArgumentException("unknown group: \"" + string + "\"");
        }
        return this.isCaptured(n);
    }

    public final int length(int n) {
        MemReg memReg = this.bounds(n);
        return memReg.out - memReg.in;
    }

    public final int start(int n) {
        return this.bounds((int)n).in - this.offset;
    }

    public final int end(int n) {
        return this.bounds((int)n).out - this.offset;
    }

    private final boolean search(int n) {
        int n2;
        Term term;
        this.called = true;
        int n3 = this.end;
        int n4 = this.offset;
        char[] cArray = this.data;
        int n5 = this.wOffset;
        int n6 = this.wEnd;
        MemReg[] memRegArray = this.memregs;
        int[] nArray = this.counters;
        LAEntry[] lAEntryArray = this.lookaheads;
        int n7 = this.memregCount;
        int n8 = this.counterCount;
        SearchEntry searchEntry = this.defaultEntry;
        SearchEntry searchEntry2 = this.first;
        SearchEntry searchEntry3 = this.top;
        SearchEntry searchEntry4 = null;
        boolean bl = (n & 4) > 0;
        boolean bl2 = (n & 8) > 0;
        Pattern pattern = this.re;
        Term term2 = pattern.root;
        if (searchEntry3 == null) {
            if ((n & 1) > 0) {
                term = pattern.root0;
                term2 = startAnchor;
            } else if ((n & 2) > 0) {
                term = pattern.root0;
                term2 = lastMatchAnchor;
            } else {
                term = term2;
            }
            n2 = n5;
            searchEntry4 = searchEntry2;
            SearchEntry.popState(searchEntry, memRegArray, nArray);
        } else {
            searchEntry4 = searchEntry3;
            searchEntry3 = searchEntry4.sub;
            term = searchEntry4.term;
            n2 = searchEntry4.index;
            SearchEntry.popState(searchEntry4, memRegArray, nArray);
        }
        int n9 = searchEntry4.cnt;
        int n10 = searchEntry4.regLen;
        block56: while (n5 <= n3) {
            block57: while (true) {
                switch (term.type) {
                    case 8: {
                        int n11 = Matcher.find(cArray, n2 + term.distance, n3, term.target);
                        if (n11 < 0) break block56;
                        n5 = n2 += n11;
                        if (term.eat) {
                            if (n2 == n3) break;
                            ++n2;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 9: {
                        MemReg memReg = memRegArray[term.target.memreg];
                        int n12 = memReg.in;
                        int n13 = memReg.out - n12;
                        if (n12 < 0 || n13 < 0) break;
                        if (n13 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        int n14 = Matcher.findReg(cArray, n2 + term.distance, n12, n13, term.target, n3);
                        if (n14 < 0) break block56;
                        n5 = n2 += n14;
                        if (term.eat && (n2 += n13) > n3) break;
                        term = term.next;
                        continue block57;
                    }
                    case 17: {
                        term = term.next;
                        continue block57;
                    }
                    case 0: {
                        if (n2 >= n3 || cArray[n2] != term.c) break;
                        ++n2;
                        term = term.next;
                        continue block57;
                    }
                    case 4: {
                        if (n2 >= n3) break;
                        ++n2;
                        term = term.next;
                        continue block57;
                    }
                    case 5: {
                        char c;
                        if (n2 >= n3 || (c = cArray[n2]) == '\r' || c == '\n') break;
                        ++n2;
                        term = term.next;
                        continue block57;
                    }
                    case 19: {
                        if (n2 < n3) break;
                        term = term.next;
                        continue block57;
                    }
                    case 20: {
                        if (n2 >= n3) {
                            term = term.next;
                            continue block57;
                        }
                        boolean bl3 = n2 >= n3 | (n2 + 1 == n3 && cArray[n2] == '\n') | (n2 + 2 == n3 && cArray[n2] == '\r' && cArray[n2 + 1] == '\n');
                        if (!bl3) break;
                        term = term.next;
                        continue block57;
                    }
                    case 22: {
                        if (n2 >= n3) {
                            term = term.next;
                            continue block57;
                        }
                        char c = cArray[n2];
                        if (c != '\r' && c != '\n') break;
                        term = term.next;
                        continue block57;
                    }
                    case 18: {
                        if (n2 == n4) {
                            term = term.next;
                            continue block57;
                        }
                        if (searchEntry3 == null && term == startAnchor) break block56;
                        break;
                    }
                    case 23: {
                        if (n2 != n6) break block56;
                        term = term.next;
                        continue block57;
                    }
                    case 21: {
                        char c;
                        if (n2 == n4) {
                            term = term.next;
                            continue block57;
                        }
                        if (n2 >= n3 || (c = cArray[n2 - 1]) != '\n' && (c != '\r' || cArray[n2] == '\n')) break;
                        term = term.next;
                        continue block57;
                    }
                    case 1: {
                        char c;
                        if (n2 >= n3 || ((c = cArray[n2]) > '\u00ff' || !term.bitset[c]) ^ term.inverse) break;
                        ++n2;
                        term = term.next;
                        continue block57;
                    }
                    case 2: {
                        boolean[] blArray;
                        char c;
                        if (n2 >= n3 || (blArray = term.bitset2[(c = cArray[n2]) >> 8]) == null || !blArray[c & 0xFF] ^ term.inverse) break;
                        ++n2;
                        term = term.next;
                        continue block57;
                    }
                    case 11: {
                        char c;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean[] blArray = term.bitset;
                        int n15 = n2 - 1;
                        if (n15 >= n4) {
                            c = cArray[n15];
                            boolean bl6 = bl4 = c < '\u0100' && blArray[c];
                        }
                        if (n2 < n3) {
                            c = cArray[n2];
                            boolean bl7 = bl5 = c < '\u0100' && blArray[c];
                        }
                        if (!(bl4 ^ bl5 ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 13: {
                        char c;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        boolean[][] blArray = term.bitset2;
                        int n16 = n2 - 1;
                        if (n16 >= n4) {
                            c = cArray[n16];
                            boolean[] blArray2 = blArray[c >> 8];
                            boolean bl10 = bl8 = blArray2 != null && blArray2[c & 0xFF];
                        }
                        if (n2 < n3) {
                            c = cArray[n2];
                            boolean[] blArray3 = blArray[c >> 8];
                            boolean bl11 = bl9 = blArray3 != null && blArray3[c & 0xFF];
                        }
                        if (!(bl8 ^ bl9 ^ term.inverse)) break;
                        term = term.next;
                        continue block57;
                    }
                    case 12: {
                        char c;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        boolean[] blArray = term.bitset;
                        boolean bl14 = term.inverse;
                        int n17 = n2 - 1;
                        if (n17 >= n4) {
                            c = cArray[n17];
                            boolean bl15 = bl12 = c < '\u0100' && blArray[c];
                        }
                        if (bl12 ^ bl14) break;
                        if (n2 < n3) {
                            c = cArray[n2];
                            bl13 = c < '\u0100' && blArray[c];
                        }
                        if (!bl13 ^ bl14) break;
                        term = term.next;
                        continue block57;
                    }
                    case 14: {
                        boolean[] blArray;
                        char c;
                        boolean bl16 = false;
                        boolean bl17 = false;
                        boolean[][] blArray4 = term.bitset2;
                        boolean bl18 = term.inverse;
                        int n18 = n2 - 1;
                        if (n18 >= n4) {
                            c = cArray[n18];
                            blArray = blArray4[c >> 8];
                            boolean bl19 = bl16 = blArray != null && blArray[c & 0xFF];
                        }
                        if (bl16 ^ bl18) break;
                        if (n2 < n3) {
                            c = cArray[n2];
                            blArray = blArray4[c >> 8];
                            bl17 = blArray != null && blArray[c & 0xFF];
                        }
                        if (!bl17 ^ bl18) break;
                        term = term.next;
                        continue block57;
                    }
                    case 6: {
                        int n19;
                        MemReg memReg = memRegArray[term.memreg];
                        int n20 = memReg.in;
                        int n21 = memReg.out;
                        if (n20 < 0 || (n19 = n21 - n20) < 0) break;
                        if (n19 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (n2 + n19 > n3 || !Matcher.compareRegions(cArray, n20, n2, n19, n3)) break;
                        n2 += n19;
                        term = term.next;
                        continue block57;
                    }
                    case 7: {
                        int n22;
                        MemReg memReg = memRegArray[term.memreg];
                        int n23 = memReg.in;
                        int n24 = memReg.out;
                        if (n23 < 0 || (n22 = n24 - n23) < 0) break;
                        if (n22 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        if (n2 + n22 > n3 || !Matcher.compareRegionsI(cArray, n23, n2, n22, n3)) break;
                        n2 += n22;
                        term = term.next;
                        continue block57;
                    }
                    case 45: {
                        n9 = Matcher.repeat(cArray, n2, n3, term.target);
                        if (n9 <= 0) {
                            term = term.next;
                            continue block57;
                        }
                        searchEntry4.cnt = n9;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2 += n9;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 46: {
                        n9 = Matcher.repeat(cArray, n2, n3, term.target);
                        if (n9 < term.minCount) break;
                        searchEntry4.cnt = n9;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2 += n9;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 47: {
                        int n25 = n3;
                        int n26 = n2 + term.maxCount;
                        n9 = Matcher.repeat(cArray, n2, n25 < n26 ? n25 : n26, term.target);
                        if (n9 < term.minCount) break;
                        searchEntry4.cnt = n9;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2 += n9;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 48: {
                        int n27;
                        MemReg memReg = memRegArray[term.memreg];
                        int n28 = memReg.in;
                        int n29 = memReg.out;
                        if (n28 < 0 || (n27 = n29 - n28) < 0) break;
                        if (n27 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        n9 = 0;
                        while (Matcher.compareRegions(cArray, n2, n28, n27, n3)) {
                            ++n9;
                            n2 += n27;
                        }
                        if (n9 < term.minCount) break;
                        searchEntry4.cnt = n9;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry4.regLen = n27;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 49: {
                        int n30;
                        MemReg memReg = memRegArray[term.memreg];
                        int n31 = memReg.in;
                        int n32 = memReg.out;
                        if (n31 < 0 || (n30 = n32 - n31) < 0) break;
                        if (n30 == 0) {
                            term = term.next;
                            continue block57;
                        }
                        n9 = 0;
                        int n33 = term.maxCount;
                        while (n33 > 0 && Matcher.compareRegions(cArray, n2, n31, n30, n3)) {
                            ++n9;
                            n2 += n30;
                            --n33;
                        }
                        if (n9 < term.minCount) break;
                        searchEntry4.cnt = n9;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry4.regLen = n30;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 50: {
                        n9 = searchEntry4.cnt;
                        if (n9 <= 0) break;
                        searchEntry4.cnt = --n9;
                        searchEntry4.index = --n2;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 51: {
                        n9 = searchEntry4.cnt;
                        if (n9 <= term.minCount) break;
                        searchEntry4.cnt = --n9;
                        searchEntry4.index = --n2;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 52: {
                        int n34;
                        n9 = searchEntry4.cnt;
                        int n35 = term.minCount;
                        if (n9 <= n35) break;
                        int n36 = n2 + term.distance;
                        if (n36 > n3) {
                            int n37 = n36 - n3;
                            if ((n9 -= n37) <= n35) break;
                            n2 -= n37;
                            n36 = n3;
                        }
                        if ((n34 = Matcher.findBack(cArray, n2 + term.distance, n9 - n35, term.target)) < 0) break;
                        if ((n9 -= n34) <= n35) {
                            n2 -= n34;
                            if (term.eat) {
                                ++n2;
                            }
                            term = term.next;
                            continue block57;
                        }
                        n2 -= n34;
                        searchEntry4.cnt = n9;
                        searchEntry4.index = n2++;
                        if (term.eat) {
                            // empty if block
                        }
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 53: {
                        int n38;
                        n9 = searchEntry4.cnt;
                        int n39 = term.minCount;
                        if (n9 <= n39) break;
                        int n40 = n2 + term.distance;
                        if (n40 > n3) {
                            int n41 = n40 - n3;
                            if ((n9 -= n41) <= n39) break;
                            n2 -= n41;
                            n40 = n3;
                        }
                        MemReg memReg = memRegArray[term.target.memreg];
                        int n42 = memReg.in;
                        int n43 = memReg.out - n42;
                        if (n42 < 0 || n43 < 0) {
                            searchEntry4.cnt = --n9;
                            searchEntry4.index = --n2;
                            searchEntry4.term = term;
                            searchEntry3 = searchEntry4;
                            searchEntry4 = searchEntry3.on;
                            if (searchEntry4 == null) {
                                searchEntry3.on = searchEntry4 = new SearchEntry();
                                searchEntry4.sub = searchEntry3;
                            }
                            term = term.next;
                            continue block57;
                        }
                        if (n43 == 0) {
                            n38 = -1;
                        } else {
                            n38 = Matcher.findBackReg(cArray, n2 + term.distance, n42, n43, n9 - n39, term.target, n3);
                            if (n38 < 0) break;
                        }
                        searchEntry4.cnt = n9 -= n38;
                        searchEntry4.index = n2 -= n38;
                        if (term.eat) {
                            n2 += n43;
                        }
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 54: {
                        n9 = searchEntry4.cnt;
                        if (n9 <= term.minCount) break;
                        n10 = searchEntry4.regLen;
                        searchEntry4.cnt = --n9;
                        searchEntry4.index = n2 -= n10;
                        searchEntry4.term = term;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 15: {
                        int n44 = term.memreg;
                        if (n44 > 0) {
                            memRegArray[n44].tmp = n2;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 16: {
                        int n44 = term.memreg;
                        if (n44 > 0) {
                            MemReg memReg = memRegArray[n44];
                            SearchEntry.saveMemregState(searchEntry3 != null ? searchEntry3 : searchEntry, n44, memReg);
                            memReg.in = memReg.tmp;
                            memReg.out = n2;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 39: {
                        int n45 = n2 - term.distance;
                        if (n45 < n4) break;
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n2;
                        n2 = n45;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        term = term.next;
                        continue block57;
                    }
                    case 35: 
                    case 43: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n2;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        term = term.next;
                        continue block57;
                    }
                    case 36: 
                    case 40: 
                    case 57: 
                    case 59: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        n2 = lAEntry.index;
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        term = term.next;
                        continue block57;
                    }
                    case 44: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        term = term.next;
                        continue block57;
                    }
                    case 41: {
                        int n46 = n2 - term.distance;
                        if (n46 < n4) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        n2 = n46;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 37: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 38: 
                    case 42: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        searchEntry4 = lAEntry.actual;
                        searchEntry3 = lAEntry.top;
                        break;
                    }
                    case 58: {
                        int n47 = n2 - term.distance;
                        if (n47 < n4) {
                            term = term.failNext;
                            continue block57;
                        }
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n2;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        n2 = n47;
                        term = term.next;
                        continue block57;
                    }
                    case 56: {
                        LAEntry lAEntry = lAEntryArray[term.lookaheadId];
                        lAEntry.index = n2;
                        lAEntry.actual = searchEntry4;
                        lAEntry.top = searchEntry3;
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 55: {
                        MemReg memReg = memRegArray[term.memreg];
                        int n48 = memReg.in;
                        int n49 = memReg.out;
                        if (n48 >= 0 && n49 >= 0 && n49 >= n48) {
                            term = term.next;
                            continue block57;
                        }
                        term = term.failNext;
                        continue block57;
                    }
                    case 34: {
                        searchEntry4.regLen = n10;
                    }
                    case 33: {
                        searchEntry4.cnt = n9;
                    }
                    case 32: {
                        searchEntry4.term = term.failNext;
                        searchEntry4.index = n2;
                        searchEntry3 = searchEntry4;
                        searchEntry4 = searchEntry3.on;
                        if (searchEntry4 == null) {
                            searchEntry3.on = searchEntry4 = new SearchEntry();
                            searchEntry4.sub = searchEntry3;
                        }
                        term = term.next;
                        continue block57;
                    }
                    case 10: {
                        if (bl && n2 != n3) break;
                        this.wOffset = memRegArray[0].in = n5;
                        this.wEnd = memRegArray[0].out = n2;
                        this.top = searchEntry3;
                        return true;
                    }
                    case 24: {
                        n9 = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 25: {
                        ++n9;
                        term = term.next;
                        continue block57;
                    }
                    case 26: {
                        if (n9 < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 27: {
                        n9 = searchEntry4.cnt;
                        if (n9 >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 28: {
                        int n50 = term.cntreg;
                        int n51 = nArray[n50];
                        SearchEntry.saveCntState(searchEntry3 != null ? searchEntry3 : searchEntry, n50, n51);
                        nArray[n50] = ++n51;
                        term = term.next;
                        continue block57;
                    }
                    case 29: {
                        nArray[term.cntreg] = 0;
                        term = term.next;
                        continue block57;
                    }
                    case 30: {
                        if (nArray[term.cntreg] >= term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    case 31: {
                        if (nArray[term.cntreg] < term.maxCount) break;
                        term = term.next;
                        continue block57;
                    }
                    default: {
                        throw new Error("unknown term type: " + term.type);
                    }
                }
                if (bl2 && n2 == n3) {
                    return true;
                }
                if (searchEntry3 == null) break;
                searchEntry4 = searchEntry3;
                searchEntry3 = searchEntry4.sub;
                term = searchEntry4.term;
                n2 = searchEntry4.index;
                if (!searchEntry4.isState) continue;
                SearchEntry.popState(searchEntry4, memRegArray, nArray);
            }
            if (searchEntry.isState) {
                SearchEntry.popState(searchEntry, memRegArray, nArray);
            }
            term = term2;
            n2 = ++n5;
        }
        this.wOffset = n5;
        this.top = searchEntry3;
        return false;
    }

    private static final boolean compareRegions(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n3 - 1;
        if (n5 >= n4 || n6 >= n4) {
            return false;
        }
        int n7 = n3;
        while (n7 > 0) {
            if (cArray[n5] != cArray[n6]) {
                return false;
            }
            --n7;
            --n5;
            --n6;
        }
        return true;
    }

    private static final boolean compareRegionsI(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n3 - 1;
        if (n5 >= n4 || n6 >= n4) {
            return false;
        }
        int n7 = n3;
        while (n7 > 0) {
            char c = cArray[n5];
            char c2 = cArray[n6];
            if (c != Character.toLowerCase(c2) && c != Character.toUpperCase(c2) && c != Character.toTitleCase(c2)) {
                return false;
            }
            --n7;
            --n5;
            --n6;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final int repeat(char[] var0, int var1_1, int var2_2, Term var3_3) {
        switch (var3_3.type) {
            case 0: {
                var4_4 = var3_3.c;
                var5_8 = var1_1;
                while (var5_8 < var2_2) {
                    if (var0[var5_8] != var4_4) break;
                    ++var5_8;
                }
                return var5_8 - var1_1;
            }
            case 4: {
                return var2_2 - var1_1;
            }
            case 5: {
                var4_5 = var1_1;
                while (var4_5 < var2_2) {
                    var5_9 = var0[var4_5];
                    if (var5_9 == '\r' || var5_9 == '\n') break;
                    ++var4_5;
                }
                return var4_5 - var1_1;
            }
            case 1: {
                var4_6 = var3_3.bitset;
                var5_10 = var1_1;
                if (!var3_3.inverse) ** GOTO lbl33
                while (var5_10 < var2_2) {
                    var6_12 = var0[var5_10];
                    if (var6_12 > '\u00ff' || !var4_6[var6_12]) {
                        ++var5_10;
                        continue;
                    }
                    ** GOTO lbl34
                }
                ** GOTO lbl34
                while ((var6_13 = var0[var5_10]) <= '\u00ff' && var4_6[var6_13]) {
                    ++var5_10;
lbl33:
                    // 2 sources

                    if (var5_10 < var2_2) continue;
                }
lbl34:
                // 4 sources

                return var5_10 - var1_1;
            }
            case 2: {
                var4_7 = var1_1;
                var5_11 = var3_3.bitset2;
                if (!var3_3.inverse) ** GOTO lbl49
                while (var4_7 < var2_2) {
                    var6_14 = var0[var4_7];
                    var7_16 = var5_11[var6_14 >> 8];
                    if (var7_16 == null || !var7_16[var6_14 & 255]) {
                        ++var4_7;
                        continue;
                    }
                    ** GOTO lbl50
                }
                ** GOTO lbl50
                while ((var7_17 = var5_11[(var6_15 = var0[var4_7]) >> 8]) != null && var7_17[var6_15 & 255]) {
                    ++var4_7;
lbl49:
                    // 2 sources

                    if (var4_7 < var2_2) continue;
                }
lbl50:
                // 4 sources

                return var4_7 - var1_1;
            }
        }
        throw new Error("this kind of term can't be quantified:" + var3_3.type);
    }

    /*
     * Unable to fully structure code
     */
    private static final int find(char[] var0, int var1_1, int var2_2, Term var3_3) {
        if (var1_1 >= var2_2) {
            return -1;
        }
        switch (var3_3.type) {
            case 0: {
                var4_4 = var3_3.c;
                var5_7 = var1_1;
                while (var5_7 < var2_2) {
                    if (var0[var5_7] == var4_4) break;
                    ++var5_7;
                }
                return var5_7 - var1_1;
            }
            case 1: {
                var4_5 = var3_3.bitset;
                var5_8 = var1_1;
                if (var3_3.inverse) ** GOTO lbl25
                while (var5_8 < var2_2) {
                    var6_10 = var0[var5_8];
                    if (var6_10 > '\u00ff' || !var4_5[var6_10]) {
                        ++var5_8;
                        continue;
                    }
                    ** GOTO lbl26
                }
                ** GOTO lbl26
                while ((var6_11 = var0[var5_8]) <= '\u00ff' && var4_5[var6_11]) {
                    ++var5_8;
lbl25:
                    // 2 sources

                    if (var5_8 < var2_2) continue;
                }
lbl26:
                // 4 sources

                return var5_8 - var1_1;
            }
            case 2: {
                var4_6 = var1_1;
                var5_9 = var3_3.bitset2;
                if (var3_3.inverse) ** GOTO lbl41
                while (var4_6 < var2_2) {
                    var6_12 = var0[var4_6];
                    var7_14 = var5_9[var6_12 >> 8];
                    if (var7_14 == null || !var7_14[var6_12 & 255]) {
                        ++var4_6;
                        continue;
                    }
                    ** GOTO lbl42
                }
                ** GOTO lbl42
                while ((var7_15 = var5_9[(var6_13 = var0[var4_6]) >> 8]) != null && var7_15[var6_13 & 255]) {
                    ++var4_6;
lbl41:
                    // 2 sources

                    if (var4_6 < var2_2) continue;
                }
lbl42:
                // 4 sources

                return var4_6 - var1_1;
            }
        }
        throw new IllegalArgumentException("can't seek this kind of term:" + var3_3.type);
    }

    private static final int findReg(char[] cArray, int n, int n2, int n3, Term term, int n4) {
        if (n >= n4) {
            return -1;
        }
        int n5 = n;
        if (term.type == 6) {
            while (n5 < n4) {
                if (!Matcher.compareRegions(cArray, n5, n2, n3, n4)) {
                    ++n5;
                    continue;
                }
                break;
            }
        } else if (term.type == 7) {
            while (n5 < n4) {
                if (!Matcher.compareRegionsI(cArray, n5, n2, n3, n4)) {
                    ++n5;
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("wrong findReg() target:" + term.type);
        }
        return n - n5;
    }

    private static final int findBack(char[] cArray, int n, int n2, Term term) {
        switch (term.type) {
            case 0: {
                char c = term.c;
                int n3 = n;
                int n4 = n - n2;
                while (cArray[--n3] != c) {
                    if (n3 > n4) continue;
                    return -1;
                }
                return n - n3;
            }
            case 1: {
                boolean[] blArray = term.bitset;
                int n5 = n;
                int n6 = n - n2;
                if (!term.inverse) {
                    char c;
                    while ((c = cArray[--n5]) > '\u00ff' || !blArray[c]) {
                        if (n5 > n6) continue;
                        return -1;
                    }
                } else {
                    char c;
                    while ((c = cArray[--n5]) <= '\u00ff' && blArray[c]) {
                        if (n5 > n6) continue;
                        return -1;
                    }
                }
                return n - n5;
            }
            case 2: {
                boolean[][] blArray = term.bitset2;
                int n7 = n;
                int n8 = n - n2;
                if (!term.inverse) {
                    char c;
                    boolean[] blArray2;
                    while ((blArray2 = blArray[(c = cArray[--n7]) >> 8]) == null || !blArray2[c & 0xFF]) {
                        if (n7 > n8) continue;
                        return -1;
                    }
                } else {
                    char c;
                    boolean[] blArray3;
                    while ((blArray3 = blArray[(c = cArray[--n7]) >> 8]) != null && !blArray3[c & 0xFF]) {
                        if (n7 > n8) continue;
                        return -1;
                    }
                }
                return n - n7;
            }
        }
        throw new IllegalArgumentException("can't find this kind of term:" + term.type);
    }

    private static final int findBackReg(char[] cArray, int n, int n2, int n3, int n4, Term term, int n5) {
        int n6 = n;
        int n7 = n - n4;
        if (term.type == 6) {
            char c = cArray[n2];
            ++n2;
            --n3;
            while (cArray[--n6] != c || !Matcher.compareRegions(cArray, n6 + 1, n2, n3, n5)) {
                if (n6 > n7) continue;
                return -1;
            }
        } else {
            if (term.type == 7) {
                char c = cArray[n2];
                char c2 = Character.toLowerCase(c);
                char c3 = Character.toUpperCase(c);
                char c4 = Character.toTitleCase(c);
                ++n2;
                --n3;
                while ((c = cArray[--n6]) != c2 && c != c3 && c != c4 || !Matcher.compareRegionsI(cArray, n6 + 1, n2, n3, n5)) {
                    if (n6 > n7) continue;
                    return -1;
                }
                return n - n6;
            }
            throw new IllegalArgumentException("wrong findBackReg() target type :" + term.type);
        }
        return n - n6;
    }

    public String toString_d() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("counters: ");
        stringBuffer.append(this.counters == null ? 0 : this.counters.length);
        stringBuffer.append("\r\nmemregs: ");
        stringBuffer.append(this.memregs.length);
        int n = 0;
        while (n < this.memregs.length) {
            stringBuffer.append("\r\n #" + n + ": [" + this.memregs[n].in + "," + this.memregs[n].out + "](\"" + this.getString(this.memregs[n].in, this.memregs[n].out) + "\")");
            ++n;
        }
        stringBuffer.append("\r\ndata: ");
        if (this.data != null) {
            stringBuffer.append(this.data.length);
        } else {
            stringBuffer.append("[none]");
        }
        stringBuffer.append("\r\noffset: ");
        stringBuffer.append(this.offset);
        stringBuffer.append("\r\nend: ");
        stringBuffer.append(this.end);
        stringBuffer.append("\r\nwOffset: ");
        stringBuffer.append(this.wOffset);
        stringBuffer.append("\r\nwEnd: ");
        stringBuffer.append(this.wEnd);
        stringBuffer.append("\r\nregex: ");
        stringBuffer.append(this.re);
        return stringBuffer.toString();
    }
}

