/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.jdbc.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import jp.co.connectone.eai.jdbc.log.LogAspect;
import jp.co.connectone.eai.jdbc.store.IJdbcDBStore;
import jp.co.connectone.eai.jdbc.store.IRecordElement;
import jp.co.connectone.eai.jdbc.store.JdbcDriverServiceInfo;
import jp.co.connectone.eai.jdbc.store.JdbcJNDIServiceInfo;
import jp.co.connectone.eai.jdbc.store.JdbcObjectIndex;
import jp.co.connectone.eai.jdbc.store.JdbcRecordObject;
import jp.co.connectone.eai.jdbc.store.JdbcTableIndex;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.service.ServiceInfo;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchCondition;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStore;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SearchFormulaBaseImpl;
import jp.co.connectone.store.db.ColumnDescriptor;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class EAIJdbcBase
implements IStore {
    protected boolean useJNDI = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public IRecordObject getTableIndexFromString(String tableName) throws IncorrectData {
        return this.getFolderIndexFromString(tableName);
    }

    protected Connection getConnection(IAccountData acc, ISearchDestination dest) throws HandleException {
        Connection rc = null;
        if (this.useJNDI) {
            rc = this.getConnectionFromJNDI(acc);
        } else {
            if (dest == null) {
                throw new NullPointerException("ISearchDestination must not be null.");
            }
            IDatabaseIndex db = dest.getDatabase();
            rc = this.getConnectionFromJDBCDriver(acc, db);
        }
        return rc;
    }

    protected Connection getConnectionFromJDBCDriver(IAccountData acc, IDatabaseIndex db) throws HandleException {
        Connection rs = null;
        if (acc == null) {
            return null;
        }
        if (!(acc instanceof PasswordBasedAccountDataImpl)) {
            throw new HandleException("IAccountData must be an instance of PasswordBasedAccountDataImpl");
        }
        JdbcDriverServiceInfo si = (JdbcDriverServiceInfo)acc.getServiceInfo();
        if (si == null) {
            Log.fatal((String)"getConnectionFromJDBCDriver:JdbcDriverServiceInfo is null");
            throw new NullPointerException("getConnectionFromJDBCDriver:JdbcDriverServiceInfo is null");
        }
        PasswordBasedAccountDataImpl jacc = (PasswordBasedAccountDataImpl)acc;
        try {
            String string = "usin JDBC Driver:" + si.getDriverName();
            EAIJdbcBase.trace_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            Class.forName(si.getDriverName());
        }
        catch (ClassNotFoundException e) {
            Log.fatal((String)("Cannot load JDBC Driver Class:" + si.getDriverName()), (Throwable)e);
        }
        try {
            rs = DriverManager.getConnection(si.getDbUrl(db), jacc.getUserID(), jacc.getPassword());
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("socket") >= 0) {
                Log.fatal((String)"SQLException on creating connection.Assume DB is down.", (Throwable)e);
                throw new ServerDown(e.getMessage());
            }
            String string = "SQLException on creating connection.Assume Authentication error.";
            EAIJdbcBase.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
            throw new NoSuchRights(e.getMessage());
        }
        return rs;
    }

    protected Connection getConnectionFromJNDI(IAccountData acc) throws HandleException {
        Connection rs = null;
        if (acc == null) {
            return null;
        }
        JdbcJNDIServiceInfo js = (JdbcJNDIServiceInfo)acc.getServiceInfo();
        DataSource ds = js.getDataSource();
        try {
            rs = ds.getConnection();
        }
        catch (SQLException se) {
            Log.error((String)"error on connectiong jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return rs;
    }

    public IRecordObject getFolderIndexFromString(String folderName) throws IncorrectData {
        if (folderName == null) {
            throw new NullPointerException("folder/table name must not be null");
        }
        JdbcRecordObject rc = new JdbcRecordObject();
        rc.setOid((IObjectIndex)new JdbcTableIndex(folderName));
        return rc;
    }

    protected IRecordObject populateRecordSet(HashMap<String, Object> h) throws HandleException {
        JdbcRecordObject o = new JdbcRecordObject();
        try {
            o.setFieldSet(h);
        }
        catch (IllegalAccessException iae) {
            Log.error((String)"error on JdbcRecordObject.setFieldSet.", (Throwable)iae);
            throw new HandleException(iae.getMessage());
        }
        o.setOid((IObjectIndex)new JdbcObjectIndex(h.get("OID")));
        o.setNew(false);
        return o;
    }

    protected FolderMetadata populateTableMetadata(HashMap<String, Object> h) throws HandleException {
        FolderMetadata o = new FolderMetadata();
        o.setFieldSet(h);
        o.setOid((IObjectIndex)new JdbcTableIndex(h.get("OID")));
        return o;
    }

    protected HashMap<String, Object> populateHashMap(ResultSet rs) throws HandleException {
        HashMap<String, Object> h = new HashMap<String, Object>();
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int len = meta.getColumnCount();
            int i = 1;
            while (i <= len) {
                String name = meta.getColumnName(i);
                h.put(name, rs.getObject(i));
                ++i;
            }
        }
        catch (SQLException se) {
            Log.error((String)"error on getting data from jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return h;
    }

    protected HashMap<String, Object> populateTableMap(ResultSet rs) throws HandleException {
        HashMap<String, Object> h = new HashMap<String, Object>();
        String tableName = null;
        try {
            tableName = rs.getString("TABLE_NAME");
        }
        catch (SQLException se) {
            Log.error((String)"error on getString(\"TABLE_NAME\").", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        h.put("folderName", tableName);
        h.put("OID", tableName);
        return h;
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        Connection con = this.getConnection(acc, dest);
        PreparedStatement getAllDatasStatement = con.prepareStatement("select * from " + dest.getFolder().getIndex().toString().toUpperCase());
        ResultSet rs = getAllDatasStatement.executeQuery();
        ArrayList<IRecordObject> list = new ArrayList<IRecordObject>();
        while (rs.next()) {
            list.add(this.populateRecordSet(this.populateHashMap(rs)));
        }
        rs.close();
        con.close();
        BasicRecordObject[] rc = new BasicRecordObject[]{};
        rc = (IRecordObject[])list.toArray(rc);
        return rc;
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest, List<String> columnsToGet) throws Exception {
        String columnList = this.getColumnListString(columnsToGet);
        Connection con = this.getConnection(acc, dest);
        PreparedStatement getAllDatasStatement = con.prepareStatement("select " + columnList + " from " + dest.getFolder().getIndex().toString().toUpperCase());
        ResultSet rs = getAllDatasStatement.executeQuery();
        ArrayList<IRecordObject> list = new ArrayList<IRecordObject>();
        while (rs.next()) {
            list.add(this.populateRecordSet(this.populateHashMap(rs)));
        }
        rs.close();
        con.close();
        BasicRecordObject[] rc = new BasicRecordObject[]{};
        rc = (IRecordObject[])list.toArray(rc);
        return rc;
    }

    protected String getColumnListString(List<String> columnsToGet) {
        if (columnsToGet == null) {
            return "*";
        }
        if (columnsToGet.size() == 0) {
            return "*";
        }
        String columnList = "";
        int i = 0;
        while (i < columnsToGet.size()) {
            columnList = String.valueOf(columnList) + columnsToGet.get(i) + ",";
            ++i;
        }
        columnList = columnList.substring(0, columnList.length() - 1);
        return columnList;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Connection con = this.getConnection(acc, dest);
        PreparedStatement deleteStatement = null;
        try {
            deleteStatement = con.prepareStatement("delete from " + dest.getFolder().getIndex().toString().toUpperCase() + " where OID=?");
            deleteStatement.setInt(1, (Integer)oid.getIndex());
        }
        catch (SQLException se) {
            Log.error((String)"error during preparing statement on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        try {
            deleteStatement.execute();
        }
        catch (SQLException se) {
            Log.error((String)"error during executeQuery on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Connection con = this.getConnection(acc, dest);
        FolderMetadata[] rc = new FolderMetadata[]{};
        try {
            DatabaseMetaData db = con.getMetaData();
            ResultSet rs = db.getTables(null, null, null, null);
            ArrayList<FolderMetadata> list = new ArrayList<FolderMetadata>();
            while (rs.next()) {
                list.add(this.populateTableMetadata(this.populateTableMap(rs)));
            }
            rs.close();
            rc = list.toArray(rc);
            con.close();
        }
        catch (SQLException se) {
            Log.error((String)"error during getting Metadatas on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return rc;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        Connection con = this.getConnection(acc, dest);
        PreparedStatement readStatement = null;
        ResultSet rs = null;
        try {
            readStatement = con.prepareStatement("select * from " + dest.getFolder().getIndex().toString().toUpperCase() + " where OID=?");
            readStatement.setInt(1, (Integer)oid.getIndex());
        }
        catch (SQLException se) {
            Log.error((String)"error during preparing statement on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        try {
            rs = readStatement.executeQuery();
        }
        catch (SQLException se) {
            Log.error((String)"error during executeQuery on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        IRecordObject rc = null;
        try {
            if (rs.next()) {
                rc = this.populateRecordSet(this.populateHashMap(rs));
            }
        }
        catch (SQLException se) {
            Log.error((String)"error on ResultSet.next().", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        try {
            rs.close();
            con.close();
        }
        catch (SQLException se) {
            Log.error((String)"error on closing jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return rc;
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula fm) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        if (fm == null) {
            throw new NullPointerException("ISearchFormula must not be null.");
        }
        ISearchDestination dest = fm.getDest();
        List columnsToGet = fm.getFieldsToGet();
        SearchConditionCollection col = fm.getSearchConditions();
        if (col == null) {
            try {
                return this.getAllDatas(acc, dest, columnsToGet);
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
                throw new HandleException(e.getMessage());
            }
        }
        String columnList = this.getColumnListString(columnsToGet);
        String whereClause = this.getWhereClause(col);
        ArrayList<IRecordObject> list = new ArrayList<IRecordObject>();
        try {
            Connection con = this.getConnection(acc, dest);
            PreparedStatement seacrhStatement = con.prepareStatement("select " + columnList + " from " + dest.getFolder().getIndex().toString().toUpperCase() + " where " + whereClause);
            ResultSet rs = seacrhStatement.executeQuery();
            while (rs.next()) {
                list.add(this.populateRecordSet(this.populateHashMap(rs)));
            }
            rs.close();
            con.close();
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
        BasicRecordObject[] rc = new BasicRecordObject[]{};
        rc = (IRecordObject[])list.toArray(rc);
        return rc;
    }

    protected String getWhereClause(SearchConditionCollection col) {
        if (col == null) {
            return null;
        }
        String whereClause = "";
        for (ISearchCondition con : col) {
            ColumnDescriptor desc = (ColumnDescriptor)con.getValue();
            whereClause = String.valueOf(whereClause) + desc.getPrefix() + desc.getName() + desc.getOperator() + "'" + desc.getValue() + "'";
        }
        whereClause = whereClause.substring(5);
        return whereClause;
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        return null;
    }

    public IObjectIndex write(IAccountData acc, ISearchFormula form, IRecordObject data) throws Exception {
        if (data == null) {
            return null;
        }
        IObjectIndex rc = null;
        ISearchDestination dest = form.getDest();
        SearchConditionCollection conds = form.getSearchConditions();
        HashMap<String, String> h = this.getColumnMapFromDatabaseTable(acc, dest);
        rc = data.isNew() ? this.createNew(acc, dest, data, h) : (data.getOid() == null && conds == null ? this.createNew(acc, dest, data, h) : this.update(acc, form, data, h));
        return rc;
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IObjectIndex rc = null;
        SearchFormulaBaseImpl form = new SearchFormulaBaseImpl(dest, null, null);
        try {
            rc = this.write(acc, (ISearchFormula)form, data);
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            throw new HandleException(e.getMessage());
        }
        return rc;
    }

    protected HashMap<String, String> getColumnMapFromDatabaseTable(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        HashMap<String, String> h = new HashMap<String, String>();
        Connection con = this.getConnection(acc, dest);
        try {
            DatabaseMetaData db = con.getMetaData();
            String dbalias = null;
            if (dest.getDatabase() != null) {
                dbalias = dest.getDatabase().getIndex().toString().toUpperCase();
            }
            String tablealias = null;
            if (dest.getFolder() != null) {
                tablealias = dest.getFolder().getIndex().toString().toUpperCase();
            }
            ResultSet rs = db.getColumns(dbalias, null, tablealias, "%");
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String typeName = rs.getString("TYPE_NAME");
                h.put(columnName, typeName);
            }
            rs.close();
            con.close();
        }
        catch (SQLException se) {
            Log.error((String)"error during getting Metadatas on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IObjectIndex createNew(IAccountData acc, ISearchDestination dest, IRecordObject data, HashMap<String, String> dbColumnList) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        BasicRecordObject bo = (BasicRecordObject)data;
        IObjectIndex rc = null;
        HashMap columns = null;
        try {
            columns = bo.getFieldSet();
        }
        catch (Exception e) {
            Log.error((String)"error on getting fieldSet", (Throwable)e);
        }
        String tableName = dest.getFolder().getIndex().toString().toUpperCase();
        ArrayList values = new ArrayList();
        Iterator it = columns.keySet().iterator();
        String sql_1 = "INSERT INTO " + tableName + " (";
        String sql_2 = "";
        String sql_3 = ") VALUES (";
        String sql_4 = "";
        String sql_5 = ");";
        while (it.hasNext()) {
            Object e;
            String columnName = (String)it.next();
            Object value = columns.get(columnName);
            String type = dbColumnList.get(columnName = columnName.toUpperCase());
            if (type == null) continue;
            if (type.equalsIgnoreCase("VARCHAR")) {
                if (value != null && !(value instanceof String)) {
                    if (value instanceof IRecordElement) {
                        e = (IRecordElement[])value;
                        if (e.getRecordElementType() != 0) continue;
                        value = e.getRecordElementValue();
                    } else {
                        if (!(value instanceof IRecordElement[]) || (e = (IRecordElement[])value)[0].getRecordElementType() != 0) continue;
                        value = e[0].getArrayOutput((IRecordElement[])e);
                    }
                }
            } else if (type.equalsIgnoreCase("TIMESTAMP")) {
                if (value != null && !(value instanceof Date)) {
                    if (value instanceof IRecordElement) {
                        e = (IRecordElement)value;
                        if (e.getRecordElementType() != 2) continue;
                        value = e.getRecordElementValue();
                    } else {
                        if (!(value instanceof IRecordElement[])) continue;
                        continue;
                    }
                }
            } else {
                if (!type.equalsIgnoreCase("INTEGER")) continue;
                if (value != null && !(value instanceof Integer)) {
                    if (value instanceof String) {
                        Integer i = null;
                        try {
                            String tmp = (String)value;
                            i = new Integer(tmp);
                        }
                        catch (Exception tmp) {
                            // empty catch block
                        }
                        if (i == null) {
                            continue;
                        }
                    } else if (!(value instanceof Long)) {
                        if (value instanceof IRecordElement) {
                            e = (IRecordElement)value;
                            if (e.getRecordElementType() != 1) continue;
                            value = e.getRecordElementValue();
                        } else {
                            if (!(value instanceof IRecordElement[]) || (e = (IRecordElement[])value)[0].getRecordElementType() != 1) continue;
                            value = e[0].getArrayOutput((IRecordElement[])e);
                        }
                    }
                }
            }
            sql_2 = String.valueOf(sql_2) + columnName + ",";
            sql_4 = String.valueOf(sql_4) + "?,";
            values.add(value);
        }
        if (values.size() == 0) {
            return rc;
        }
        sql_2 = sql_2.substring(0, sql_2.length() - 1);
        sql_4 = sql_4.substring(0, sql_4.length() - 1);
        String sql = String.valueOf(sql_1) + sql_2 + sql_3 + sql_4 + sql_5;
        PreparedStatement ps = null;
        Connection con = this.getConnection(acc, dest);
        try {
            ps = con.prepareStatement(sql);
            int i = 0;
            while (i < values.size()) {
                Object value = values.get(i);
                if (value == null) {
                    ps.setString(i + 1, null);
                } else if (value instanceof String) {
                    ps.setString(i + 1, (String)value);
                } else if (value instanceof Integer) {
                    Integer in = (Integer)value;
                    ps.setInt(i + 1, in);
                } else if (value instanceof Long) {
                    Long ln = (Long)value;
                    ps.setLong(i + 1, ln.intValue());
                } else if (value instanceof Date) {
                    Date dt = (Date)value;
                    ps.setTimestamp(i + 1, new Timestamp(dt.getTime()));
                }
                ++i;
            }
        }
        catch (SQLException se) {
            Log.error((String)"error during preparing statement on jdbc.", (Throwable)se);
            try {
                con.close();
            }
            catch (SQLException se2) {
                Log.error((String)"error on closing jdbc.", (Throwable)se2);
                throw new HandleException(se2.getMessage());
            }
            con = null;
            throw new HandleException(se.getMessage());
        }
        try {
            try {
                ps.execute();
                return rc;
            }
            catch (SQLException se) {
                if (se.getMessage().indexOf("duplicate") >= 0) {
                    Log.error((String)"duplicate data on unique field error.", (Throwable)se);
                    throw new IncorrectData(se.getMessage());
                }
                Log.error((String)"error on PreparedStatent.execute() jdbc.", (Throwable)se);
                throw new HandleException(se.getMessage());
            }
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException se2) {
                Log.error((String)"error on closing jdbc.", (Throwable)se2);
                throw new HandleException(se2.getMessage());
            }
            con = null;
            System.gc();
        }
    }

    protected IObjectIndex update(IAccountData acc, ISearchFormula form, IRecordObject data, HashMap<String, String> dbColumnList) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        ISearchDestination dest = form.getDest();
        SearchConditionCollection col = form.getSearchConditions();
        String whereClause = this.getWhereClause(col);
        BasicRecordObject bd = (BasicRecordObject)data;
        Connection con = this.getConnection(acc, dest);
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException se) {
            Log.error((String)"error during setAutoCommit(false) on jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        try {
            HashMap h = bd.getFieldSet();
            Iterator it = h.keySet().iterator();
            PreparedStatement updateStatement = null;
            String tableName = dest.getFolder().getIndex().toString().toUpperCase();
            while (it.hasNext()) {
                String columnName = (String)it.next();
                Object value = h.get(columnName);
                columnName = columnName.toUpperCase();
                String type = dbColumnList.get(columnName);
                String string = String.valueOf(columnName) + "(" + type + ")=" + value;
                EAIJdbcBase.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
                if (columnName.equals("OID") || type == null) continue;
                String updateSQL = null;
                Integer objID = null;
                if (whereClause == null) {
                    objID = (Integer)data.getOid().getIndex();
                    updateSQL = "update " + tableName + " set " + columnName + "=? where OID=?";
                } else {
                    updateSQL = "update " + tableName + " set " + columnName + "=? where " + whereClause;
                }
                try {
                    updateStatement = con.prepareStatement(updateSQL);
                }
                catch (SQLException se) {
                    Log.error((String)"error during preparing statement on jdbc.", (Throwable)se);
                    throw new HandleException(se.getMessage());
                }
                if (type.equalsIgnoreCase("VARCHAR")) {
                    if (value instanceof String) {
                        updateStatement.setString(1, (String)value);
                    } else if (value instanceof IRecordElement) {
                        IRecordElement v = (IRecordElement)value;
                        if (v.getRecordElementType() != 0) continue;
                        updateStatement.setString(1, (String)v.getRecordElementValue());
                    } else {
                        IRecordElement[] v;
                        if (!(value instanceof IRecordElement[]) || (v = (IRecordElement[])value)[0].getRecordElementType() != 0) continue;
                        String av = (String)v[0].getArrayOutput(v);
                        updateStatement.setString(1, av);
                    }
                } else if (type.equalsIgnoreCase("TIMESTAMP")) {
                    if (value instanceof Date) {
                        Date d = (Date)value;
                        updateStatement.setTimestamp(1, new Timestamp(d.getTime()));
                    } else {
                        IRecordElement v;
                        if (!(value instanceof IRecordElement) || (v = (IRecordElement)value).getRecordElementType() != 2) continue;
                        Date d = (Date)v.getRecordElementValue();
                        updateStatement.setTimestamp(1, new Timestamp(d.getTime()));
                    }
                } else if (type.equalsIgnoreCase("INTEGER")) {
                    if (value instanceof Integer) {
                        Integer i = (Integer)value;
                        updateStatement.setInt(1, i);
                    } else if (value instanceof IRecordElement) {
                        IRecordElement v = (IRecordElement)value;
                        if (v.getRecordElementType() == 1) {
                            Integer i = (Integer)v.getRecordElementValue();
                            updateStatement.setInt(1, i);
                        } else {
                            if (v.getRecordElementType() != 0) continue;
                            int i = 0;
                            try {
                                i = Integer.parseInt((String)v.getRecordElementValue());
                            }
                            catch (Exception e) {
                                continue;
                            }
                            updateStatement.setInt(1, i);
                        }
                    } else {
                        if (!(value instanceof String)) continue;
                        int i = 0;
                        try {
                            i = Integer.parseInt((String)value);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        updateStatement.setInt(1, i);
                    }
                } else {
                    throw new HandleException("unsupported database column type:" + type);
                }
                if (objID != null) {
                    updateStatement.setInt(2, objID);
                }
                updateStatement.execute();
            }
        }
        catch (Exception e) {
            block40: {
                Log.error((String)"exception during update transaction.rollback...", (Throwable)e);
                try {
                    try {
                        con.rollback();
                        con.close();
                    }
                    catch (SQLException re) {
                        Log.fatal((String)"FATAL ERROR:error on rollback connection. on exception.", (Throwable)re);
                        con = null;
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    con = null;
                    throw throwable;
                }
                con = null;
            }
            if (e.getMessage().indexOf("duplicate") >= 0) {
                Log.error((String)"duplicate data on unique field error.", (Throwable)e);
                throw new IncorrectData(e.getMessage());
            }
            throw new HandleException((Throwable)e);
        }
        try {
            con.commit();
            con.close();
            con = null;
            System.gc();
        }
        catch (SQLException se) {
            Log.error((String)"error on closing jdbc.", (Throwable)se);
            throw new HandleException(se.getMessage());
        }
        return data.getOid();
    }

    protected FolderMetadata populateFolder(IFolderIndex idx) {
        FolderMetadata folder = new FolderMetadata();
        folder.setOid((IObjectIndex)idx);
        folder.setFolderName(idx.getIndex().toString());
        return folder;
    }

    public boolean isUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(boolean useJNDI) {
        this.useJNDI = useJNDI;
    }

    public abstract IServiceInfo getServiceInfo() throws Exception;

    public abstract IServiceInfo getServiceInfo(IJdbcDBStore.EnumEngineType var1) throws Exception;

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        IJdbcDBStore.EnumEngineType engine = IJdbcDBStore.EnumEngineType.valueOf((String)h.get("engine"));
        ServiceInfo info = null;
        info = engine == null ? (ServiceInfo)this.getServiceInfo() : (ServiceInfo)this.getServiceInfo(engine);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        return info;
    }

    static {
        EAIJdbcBase.ajc$preClinit();
    }

    private static final /* synthetic */ void trace_aroundBody0(EAIJdbcBase eAIJdbcBase, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody1$advice(EAIJdbcBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(EAIJdbcBase eAIJdbcBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(EAIJdbcBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(EAIJdbcBase eAIJdbcBase, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(EAIJdbcBase ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_jdbc_log_LogAspect$jp_co_connectone_eai_jdbc_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EAIJdbcBase.java", Class.forName("jp.co.connectone.eai.jdbc.store.EAIJdbcBase"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 67);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 646);
    }
}

