import java.util.*;

import jp.co.connectone.eai.pop3.store.*;
import jp.co.connectone.eai.pop3.user.*;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
/**
 * @author patni
 * 
 */
public class SmtpMailStoreImplTest extends TestCase
{
	Pop3MailStoreImpl aEAIPop3ImplObj;
	Pop3AccountData acc;
	private static final String strSvr="mail.connectone.co.jp";
	private static final String strUser="test";
	private static final String strPassword="********";
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception
	{
		aEAIPop3ImplObj = new Pop3MailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		Pop3ServiceInfo si = (Pop3ServiceInfo)aEAIPop3ImplObj.getServiceInfo();
		si.setServerAddress(strSvr);
		acc = new Pop3AccountData(uid,si);
		acc.setUserID(strUser);
		acc.setPassword(strPassword);
	}
	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception 
	{
		super.tearDown();
	}
	
	public void testGetName() throws Exception
	{
		assertEquals(aEAIPop3ImplObj.getName(),Pop3MailStoreImpl.storeName);
	}
	
	public void testGetStoreID() throws Exception
	{
		Log.debug(aEAIPop3ImplObj.getStoreID().getStoreID());
		assertEquals(aEAIPop3ImplObj.getStoreID().getStoreID(),"jp.co.connectone.eai.pop3.store.Pop3MailStoreClient");
	}
	
	public void testGetInstance()
	{
		assertNotNull(Pop3MailStoreImpl.getInstance());
	}
	
	public void testGetMailFolders() throws Exception
	{
		/* fetches array of string from the testGetMailFolders */
		FolderMetadata strFolderlist2[]; 
	    strFolderlist2 = aEAIPop3ImplObj.getMailFolders(acc,null);
		assertNotNull(strFolderlist2);
		FolderMetadata f = strFolderlist2[0];
		assertNotNull(f);
		String name = f.getFolderName();
		assertEquals("Inbox", name);
		
	}
	public void teXstgetHeaders() throws Exception
	{
		IMailDTO TstrHeader[] = null;
		
		TstrHeader = aEAIPop3ImplObj.getHeaders(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER));
		
		assertNotNull(TstrHeader);
		assertTrue(TstrHeader.length>0);// at least one mail shold be in ($Inbox) with test-date.

	}
	public void teXstgetHeadersByDate() throws Exception
	{
		IMailDTO strHeader3[] = null;
		Calendar c = Calendar.getInstance();
		c.set(2009, 10, 6, 0, 0 ,0);//month -> 0-11
		Date date = c.getTime();
		strHeader3 = aEAIPop3ImplObj.getHeadersByDate(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date); 
		assertNotNull(strHeader3);
		assertTrue(strHeader3.length>0);// mails shold be in ($Inbox) with test-date.
		for (int i=0;i<strHeader3.length;i++) {
			dumpDTO2(strHeader3[i]);
		}
		strHeader3=null;
		c.set(2008, 0, 1, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		strHeader3 = aEAIPop3ImplObj.getHeadersByDate(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date); 
		assertNotNull(strHeader3);
		assertEquals(strHeader3.length,0);// no mail shold be in ($Inbox) with test-date.
	}
	
	public void testDeleteMail() throws Exception
	{
		String uidl="0DB68FD3310CC3794925702600290841";
		if (uidl==null) return;
		BasicObjectIndex oid = new BasicObjectIndex(uidl);
		aEAIPop3ImplObj.deleteMail(acc,oid);
	}
	
	public void testGetUIDLs() throws Exception
	{
		IRecordObject[] uidlArray1;
		uidlArray1 = aEAIPop3ImplObj.getUIDLs(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER));
		for (int i=0;i<uidlArray1.length;i++) {
			try {
				Log.debug("uidlArray1["+i+"]=" + (String)uidlArray1[i].getOid().getIndex());
			}
			catch (NullPointerException e) {};
		}
		assertNotNull(uidlArray1);
		assertTrue(uidlArray1.length>0);// at least one mail data should be in ($Inbox) at 20 Aug.
		
	}
	public void testGetMailsByDate() throws Exception
	{
		Date date;
		Calendar c = Calendar.getInstance();
		c.set(2009, 10, 6, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		IMailDTO[] mails = aEAIPop3ImplObj.getMailsByDate(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(mails);
		assertTrue(mails.length>0);
		for (int i=0;i<mails.length;i++) {
			dumpDTO2(mails[i]);
		}
		c.set(2005, 11, 1, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		mails = aEAIPop3ImplObj.getMailsByDate(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(mails);
		assertEquals(mails.length,0);
		for (int i=0;i<mails.length;i++) {
			dumpDTO2(mails[i]);
		}
	}

	public void testSentMailsByDate() throws Exception
	{
		Date date;
		Calendar c = Calendar.getInstance();
		c.set(2006, 1, 22, 0, 0 ,0);//month -> 0-11
		date = c.getTime();
		try {
			aEAIPop3ImplObj.getSentMailsByDate(acc,date);
		}
		catch(HandleException he) {
			return;
		}
		fail();// pop3 must not support sent-mail folder.
	}
	public void testSendPop3Mail() throws Exception
	{
		HeaderDTO header = new HeaderDTO();
		String[] to = {"amanot@amax.co.jp"};
		header.setHeaderTo(to);
		String[] cc = {""};
		header.setHeaderCC(cc);
		header.setHeaderBCC(cc);
		header.setHeaderSubject("EAIPop3ImplTest̃[");
		IMailDTO mail = new BasicMailDTO();
		mail.setHeaderDTO(header);
		mail.setBody("̓{fB[");
		try {
			aEAIPop3ImplObj.sendMail(acc,mail);
		}
		catch (HandleException he) {
			return;
		}
		fail();//pop3 must not support send mail.
	}
	public void testGetMail() throws Exception
	{
		IObjectIndex oid = new BasicObjectIndex("<OFE08EAC0D.ECB3CEF3-ON49257666.0024E6F0-49257666.00251E56@mta.fijifirm.co.jp>");
		IMailDTO mail = aEAIPop3ImplObj.getMail(acc,aEAIPop3ImplObj.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),oid);
		assertNotNull(mail);
		dumpDTO2(mail);
	}
	
	private void dumpDTO2(IMailDTO dto)
	{
		HeaderDTO h = dto.getHeader();
		Log.debug("=======================================");
		Log.debug(h.getHeaderSubject());
		Log.debug(h.getHeaderFrom().getRawAddress());
		Log.debug(h.getHeaderSendDate().toString());
		Log.debug(h.getHeaderUIDL());
		Log.debug(array2String(h.getHeaderTo()));
		Log.debug(array2String(h.getHeaderCC()));
		Log.debug(dto.getBody());
		Log.debug("=======================================");
	}
	
	private String array2String(MailAddress[] ar)
	{
		if (ar==null) return null;
		return "" + Arrays.asList(ar);
	}
}
