/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;
import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.eai.exchews.user.ExchewsAccountData;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.client.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
import java.util.*;
import java.text.*;

import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
/**
 * @author amanot
 *
 */
public class TestExchewsScheduleImpl extends TestCase {
	private ExchewsScheduleStoreImpl scheduleStore;
	private ExchewsAccountData acc;
	private ExchewsServiceInfo info;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		scheduleStore = new ExchewsScheduleStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		info = (ExchewsServiceInfo)scheduleStore.getServiceInfo();
		info.setServerAddress("exchange");
		info.setProtocolPrefix("http://");
		acc = new ExchewsAccountData(uid, info);
		acc.setUserID("test");
		acc.setPassword("********");
		acc.setDomain("TEST");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		scheduleStore = null;
	}
	
	public void testGetSchedulesByDate() throws Exception
	{
		assertNotNull(scheduleStore);
		Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-06-12 00:00:00");
		ExchewsScheduleDTO[] s = (ExchewsScheduleDTO[])scheduleStore.getSchedulesByDate(acc,date);
		assertNotNull(s);
		for (int i=0;i<s.length;i++) {
			dumpDTO(s[i]);
			Log.debug("sensitivity="+s[i].getFieldSet().get("sensitivity"));
		}
	}
	
	public void teXstSearch() throws Exception
	{
		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date =sdf.parse("2010-04-12 10:00:00");
		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,new BasicObjectIndex("test"));
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE,date);
		conds.add(cond);
		ISearchDestination dest = scheduleStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		ExchewsScheduleDTO[] scheList = (ExchewsScheduleDTO[])scheduleStore.searchSchedules(acc,formula);
		assertNotNull(scheList);
		for (int i=0;i<scheList.length;i++) {
			dumpDTO(scheList[i]);
		}
		
	}
	
	public void teXstCreateNewSchedule() throws Exception
	{
		assertNotNull(scheduleStore);
		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date =sdf.parse("2010-06-12 10:00:00");
		Date date2 = sdf.parse("2010-06-12 13:00:00");
		ExchewsScheduleDTO schedule = new ExchewsScheduleDTO();
		schedule.setStartDate(date);
		schedule.setEndDate(date2);
		schedule.setSubject("eXg");
		schedule.setBody("e");
		schedule.setLocation("ꏊ");
		schedule.setOrganizer(new MailAddress("test@connectone.co.jp"));
		MailAddress TOs[] = new MailAddress[1];
		TOs[0] = new MailAddress("test@amax.co.jp");
		schedule.setTo(TOs);
//		schedule.setResponserequested(true);
//		schedule.setMeetingstatus("CONFIRMED");
		IObjectIndex idx = scheduleStore.createNewSchedule(acc,schedule);
		assertNotNull(idx);
	}
	
	public void testUpdateSchedule() throws Exception
	{
		assertNotNull(scheduleStore);
		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date =sdf.parse("2010-06-12 10:00:00");
		Date date2 = sdf.parse("2010-06-12 13:00:00");
		ExchewsScheduleDTO schedule = new ExchewsScheduleDTO();
		schedule.setStartDate(date);
		schedule.setEndDate(date2);
		schedule.setBody("ڂł[B");
		schedule.setSubject("updateeXgp");
		schedule.setLocation("ꏊ");
		schedule.setOrganizer(new MailAddress("test@connectone.co.jp"));
		MailAddress TOs[] = new MailAddress[1];
		TOs[0] = new MailAddress("test@amax.co.jp");
		schedule.setTo(TOs);
		
		boolean catchException=false;
		try {
			scheduleStore.updateSchedule(acc,schedule);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertTrue(catchException);
		}
		catchException=false;
		
		IObjectIndex oid = scheduleStore.createNewSchedule(acc,schedule);
		assertNotNull(oid);
		schedule.setOid(oid);
		
		schedule.setBody("updateꂽ{fB[łB");
		
		try {
			scheduleStore.updateSchedule(acc, schedule);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertFalse(catchException);
		}
		
		IScheduleDTO schedule2 = scheduleStore.getSchedule(acc, oid);
		assertEquals(schedule2.getSubject(), "updateeXgp");
		assertEquals(schedule2.getBody(), "updateꂽ{fB[łB");
	}
	
	public void teXstDeleteSchedule() throws Exception
	{
		assertNotNull(scheduleStore);
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsNvAAAOvrSTFzPIQ5PjycGgMJFGAGwwRGmeAAA=";
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		scheduleStore.deleteSchedule(acc, oid);
	}
	
	public void teXstGetSchedule() throws Exception
	{
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsNvAAC994qxD0rdTLqAc+xnPTyTAAANdgWPAAA=";
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		assertNotNull(scheduleStore);
		ExchewsScheduleDTO sche = (ExchewsScheduleDTO)scheduleStore.getSchedule(acc, oid);
		assertNotNull(sche);
		assertNotNull(sche.getBody());
		assertTrue(sche.getBody().length()>0);
		assertFalse(sche.isNew());
		assertTrue(sche instanceof ExchewsScheduleDTO);
		dumpDTO(sche);
	}
	
	private void dumpDTO(ExchewsScheduleDTO dto)
	{
		Log.debug("=======================================");
		Log.debug("oid:"+((ItemIdType)dto.getOid().getIndex()).getId());
		Log.debug("Subject="+dto.getSubject());
		Log.debug("Location="+dto.getLocation());
		Log.debug("Body="+dto.getBody());
		Log.debug("StartDate="+dto.getStartDate());
		Log.debug("EndDate="+dto.getEndDate());
/*
		Log.debug("Alldayevent="+dto.isAlldayevent());
		Log.debug("Busystatus="+dto.getBusystatus());
		Log.debug("Created="+dto.getCreated());
		Log.debug("Duration="+dto.getDuration());
		Log.debug("Exdate="+Arrays.asList(dto.getExdate()));
		Log.debug("Exrule="+dto.getExrule());
		Log.debug("Instancetype="+dto.getInstancetype());
		Log.debug("Isorganizer="+dto.isIsorganizer());
		Log.debug("Lastmodified="+dto.getLastmodified());
		Log.debug("Lastmodifiedtime="+dto.getLastmodifiedtime());
		Log.debug("Meetingstatus="+dto.getMeetingstatus());
		Log.debug("Organizer="+dto.getOrganizer());
		Log.debug("Rdate="+dto.getRdate());
		Log.debug("Recurrenceid="+dto.getRecurrenceid());
		Log.debug("Reminderoffset="+dto.getReminderoffset());
		Log.debug("Resources="+dto.getResources());
		Log.debug("Sequence="+dto.getSequence());
		Log.debug("Timezone="+dto.getTimezone());
		Log.debug("Timezoneid="+dto.getTimezoneid());
		Log.debug("Uid="+dto.getUid());
		Log.debug("Version="+dto.getVersion());
		Log.debug("To="+Arrays.asList(dto.getTo()));
		Log.debug("Cc="+Arrays.asList(dto.getCc()));
		Log.debug("Bcc="+Arrays.asList(dto.getBcc()));
		Log.debug("Responserequested="+dto.isResponserequested());
		Log.debug("=======================================");
*/
	}
}
