/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.util;

import java.text.ParseException;
import java.util.*;

import javax.xml.bind.JAXBElement;
import javax.xml.datatype.*;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.EWSDateFormat;
import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.*;

public class ExchEWSTranslator
{
	protected static final com.microsoft.schemas.exchange.services._2006.types.ObjectFactory typesObjectFactory = new com.microsoft.schemas.exchange.services._2006.types.ObjectFactory();
	protected static final com.microsoft.schemas.exchange.services._2006.messages.ObjectFactory messagesObjectFactory = new com.microsoft.schemas.exchange.services._2006.messages.ObjectFactory();
	public enum FOLDER_TYPE {
		INBOX,
		SENTBOX
	}

	public static NonEmptyArrayOfAttachmentsType createArrayOfAttachmentsType(AttachmentDTO[] attach)
	{
		NonEmptyArrayOfAttachmentsType rc = typesObjectFactory.createNonEmptyArrayOfAttachmentsType();
		List<AttachmentType> list = rc.getItemAttachmentOrFileAttachment();

		for (AttachmentDTO src : attach) {
			FileAttachmentType item = new FileAttachmentType();
			item.setContent(src.getFileBody());
			item.setName(src.getFileName());

			list.add(item);
		}

		return rc;
	}

	public static ExchewsFolderMetadata createDistinguishedFolder(FOLDER_TYPE type)
	{
		ExchewsFolderMetadata rc = new ExchewsFolderMetadata();
		ExchewsFolderIndex idx = new ExchewsFolderIndex();
		switch (type) {
		case INBOX:
			idx.setIndex(DistinguishedFolderIdNameType.INBOX);
			break;
		case SENTBOX:
			idx.setIndex(DistinguishedFolderIdNameType.OUTBOX);
			break;
		}

		return rc;
	}

	public static ExchewsObjectIndex createIndex(String id)
	{
		ItemIdType index = new ItemIdType();
		index.setId(id);
		return new ExchewsObjectIndex(index);
	}

	public static Date convertEWSDateTime2JavaDate(XMLGregorianCalendar src)
	{
		if (src==null)return null;
		return src.toGregorianCalendar().getTime();
	}

	public static XMLGregorianCalendar convertJavaDate2EWSDateTime(Date src)
	{
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(src);
		XMLGregorianCalendar rc=null;
		try {
			rc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
		}
		catch (Exception e) {
			Log.error("Error on convert date to XMLGregorianCalendar.", e);
		}
		return rc;
	}

	public static String javaDate2EWSDateStr(Date date)
	{
		if (date == null) return null;
		EWSDateFormat sdf = new EWSDateFormat();
		sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
		return sdf.format(date);
	}

	public static String javaDate2EWSDateStr_DateTop(Date date)
	{
		if (date == null) return null;
		EWSDateFormat sdf = new EWSDateFormat(EWSDateFormat.FORMAT_DAV_T_SEC_WITH00HOUR);
		String dateStr = sdf.format(date);
		try {
			sdf.setFormatType(EWSDateFormat.FORMAT_DAV_T_SEC);
			Date topDate = sdf.parse(dateStr);
			sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
			dateStr = sdf.format(topDate);
		}
		catch (ParseException pe) {}
		return dateStr;
	}

	public static String javaDate2EWSDateStr_DateEnd(Date date)
	{
		if (date == null) return null;
		EWSDateFormat sdf = new EWSDateFormat(EWSDateFormat.FORMAT_DAV_T_SEC_WITH23HOUR);
		String dateStr = sdf.format(date);
		try {
			sdf.setFormatType(EWSDateFormat.FORMAT_DAV_T_SEC);
			Date endDate = sdf.parse(dateStr);
			sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
			dateStr = sdf.format(endDate);
		}
		catch (ParseException pe) {}
		return dateStr;
	}

	public static MailAddress[] convertEWSArrayOfRecipientsType2MailBoxes(ArrayOfRecipientsType ar)
	{
		if (ar==null) return null;
		List<EmailAddressType> src = ar.getMailbox();
		List<MailAddress> l = new ArrayList<MailAddress>();
		for (EmailAddressType add : src) {
			l.add(convertEWSMailBox2MailAddress(add));
		}
		return l.toArray(new MailAddress[0]);
	}

	public static MailAddress convertEWSMailBox2MailAddress(EmailAddressType mailbox)
	{
		if (mailbox==null) return null;
		return new MailAddress(mailbox.getName(),mailbox.getEmailAddress());
	}

	public static EmailAddressType convertMailAddress2EWSMailBox(MailAddress addr)
	{
		if (addr==null) return null;
		EmailAddressType mailbox = new EmailAddressType();
		mailbox.setName(addr.getNamePart());
		mailbox.setEmailAddress(addr.getAddressPart());
		return mailbox;
	}

	public static ExchEWSImportance convertEWSImportantType2C1Importance(ImportanceChoicesType importance)
	{
		if (importance==null) return null;
		switch (importance) {
		case HIGH:
			 return ExchEWSImportance.HIGH;
		case LOW:
			 return ExchEWSImportance.LOW;
		default:
			return ExchEWSImportance.NORMAL;
		}
	}


	public static ImportanceChoicesType convertC1Importance2EWSImportantType(ExchEWSImportance importance)
	{
		if (importance==null) return null;
		switch (importance) {
		case HIGH:
			 return ImportanceChoicesType.HIGH;
		case LOW:
			 return ImportanceChoicesType.LOW;
		default:
			return ImportanceChoicesType.NORMAL;
		}
	}

	public static JAXBElement<? extends SearchExpressionType> createIsLessThanOrEqualTo(UnindexedFieldURIType itemType, String itemValue)
	{
		IsLessThanOrEqualToType iltett = new IsLessThanOrEqualToType();
		iltett.setPath(createFieldURI(itemType));
		iltett.setFieldURIOrConstant(createFieldConstant(itemValue));
		return typesObjectFactory.createIsLessThanOrEqualTo(iltett);
	}

	public static JAXBElement<? extends SearchExpressionType> createIsGreaterThanOrEqualTo(UnindexedFieldURIType itemType, String itemValue)
	{
		IsGreaterThanOrEqualToType igtett = new IsGreaterThanOrEqualToType();
		igtett.setPath(createFieldURI(itemType));
		igtett.setFieldURIOrConstant(createFieldConstant(itemValue));
		return typesObjectFactory.createIsGreaterThanOrEqualTo(igtett);
	}

	public static SearchExpressionType createContains(UnindexedFieldURIType itemType, String itemValue)
	{
		ContainsExpressionType iett = new ContainsExpressionType();
		iett.setPath(createFieldURI(itemType));
		ConstantValueType constant = new ConstantValueType();
		constant.setValue(itemValue);
		iett.setConstant(constant);
		iett.setContainmentComparison(ContainmentComparisonType.LOOSE_AND_IGNORE_CASE_AND_IGNORE_NON_SPACE);
		iett.setContainmentMode(ContainmentModeType.SUBSTRING);
		return iett;
	}

	public static JAXBElement<? extends SearchExpressionType> createIsEqualTo(UnindexedFieldURIType itemType, String itemValue)
	{
		IsEqualToType iett = new IsEqualToType();
		iett.setPath(createFieldURI(itemType));
		iett.setFieldURIOrConstant(createFieldConstant(itemValue));
		return typesObjectFactory.createIsEqualTo(iett);
	}

	public static FieldURIOrConstantType createFieldConstant(String itemDefValue)
	{
		ConstantValueType itemToGet = new ConstantValueType();
		itemToGet.setValue(itemDefValue);
		FieldURIOrConstantType itemConst = new FieldURIOrConstantType();
		itemConst.setConstant(itemToGet);
		return itemConst;
	}

	public static JAXBElement<? extends BasePathToElementType> createFieldURI(UnindexedFieldURIType fieldDefValue)
	{
		PathToUnindexedFieldType itemClass = new PathToUnindexedFieldType();
		itemClass.setFieldURI(fieldDefValue);
		JAXBElement<? extends BasePathToElementType> itemClassPath = typesObjectFactory.createFieldURI(itemClass);
		return itemClassPath;
	}


	public static AndType createAnd(JAXBElement<? extends SearchExpressionType>... elem)
	{
		AndType at = new AndType();

		for (JAXBElement<? extends SearchExpressionType> e : elem) {
			at.getSearchExpression().add(e);
		}
		return at;
	}


	public static RestrictionType createRestriction(SearchExpressionType ex)
	{
		RestrictionType rt = new RestrictionType();
		JAXBElement<? extends SearchExpressionType> rat = null;
		if (ex instanceof AndType) {
			AndType at = (AndType) ex;
			rat = typesObjectFactory.createAnd(at);
		}
		else if  (ex instanceof OrType) {
			OrType ot = (OrType) ex;
			rat = typesObjectFactory.createOr(ot);
		}
		else if (ex instanceof ContainsExpressionType) {
			ContainsExpressionType ct = (ContainsExpressionType)ex;
			rat = typesObjectFactory.createContains(ct);
		}
		rt.setSearchExpression(rat);
		return rt;
	}

	public static NonEmptyArrayOfPathsToElementType createAdditionalProperties(UnindexedFieldURIType... fieldTypes)
	{
		NonEmptyArrayOfPathsToElementType props = new NonEmptyArrayOfPathsToElementType();
		for (UnindexedFieldURIType fieldType : fieldTypes) {
			PathToUnindexedFieldType ptufta = new PathToUnindexedFieldType();
			ptufta.setFieldURI(fieldType);
			JAXBElement<? extends BasePathToElementType> p = typesObjectFactory.createFieldURI(ptufta);
			props.getPath().add(p);
		}

		return props;
	}

	public static NonEmptyArrayOfRequestAttachmentIdsType createAttachIdList(List<AttachmentType> attachItems)
	{
		NonEmptyArrayOfRequestAttachmentIdsType ids = new NonEmptyArrayOfRequestAttachmentIdsType();
		List<RequestAttachmentIdType> idl = ids.getAttachmentId();
		for (AttachmentType item : attachItems) {
			idl.add(item.getAttachmentId());
		}

		return ids;
	}

	public static NonEmptyArrayOfBaseItemIdsType createItemIdList(ItemIdType... idTypes)
	{
		NonEmptyArrayOfBaseItemIdsType ids = new NonEmptyArrayOfBaseItemIdsType();
		List<BaseItemIdType>idl = ids.getItemIdOrOccurrenceItemIdOrRecurringMasterItemId();
		for (ItemIdType idType : idTypes) {
			idl.add(idType);
		}

		return ids;
	}

	public static NonEmptyArrayOfBaseFolderIdsType createFolderIds(BaseFolderIdType... ids)
	{
		NonEmptyArrayOfBaseFolderIdsType folderIds = new NonEmptyArrayOfBaseFolderIdsType();
		List<BaseFolderIdType> idList = folderIds.getFolderIdOrDistinguishedFolderId();
		for (BaseFolderIdType id : ids) {
			idList.add(id);
		}
		return folderIds;
	}

	public static IndexedPageViewType createEWSParamPaging(int indexOffset, int pagingSize)
	{
		IndexedPageViewType index = new IndexedPageViewType();
		index.setBasePoint(IndexBasePointType.BEGINNING);
		index.setOffset(indexOffset);
		index.setMaxEntriesReturned(pagingSize);
		return index;
	}

	public static MailAddress convertEWSArrayOfRecipientsType2SingleMailAddress(ArrayOfRecipientsType ar)
	{
		if (ar==null) return null;
		List<EmailAddressType> src = ar.getMailbox();
		if (src==null) return null;
		EmailAddressType add = src.get(0);
		if (add==null) return null;
		String displayName = add.getName();
		String addressPart = add.getEmailAddress();
		return new MailAddress(displayName,addressPart);
	}

	public static CalendarViewType createCalendarViewType(Date date)
	{
		CalendarViewType cal = new CalendarViewType();

		EWSDateFormat sdf1 = new EWSDateFormat(EWSDateFormat.FORMAT_DAV_T_SEC_WITH00HOUR);
		String dateStr = sdf1.format(date);
		sdf1.setFormatType(EWSDateFormat.FORMAT_DAV_T_SEC);
		try {
			cal.setStartDate(ExchEWSTranslator.convertJavaDate2EWSDateTime(sdf1.parse(dateStr)));
		}
		catch(ParseException e){}

		EWSDateFormat sdf2 = new EWSDateFormat(EWSDateFormat.FORMAT_DAV_T_SEC_WITH23HOUR);
		dateStr = sdf2.format(date);
		sdf2.setFormatType(EWSDateFormat.FORMAT_DAV_T_SEC);
		try{
			cal.setEndDate(ExchEWSTranslator.convertJavaDate2EWSDateTime(sdf2.parse(dateStr)));
		}
		catch(ParseException e){}

		return cal;
	}
}
