/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.Date;
import java.util.List;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.MailAddress;

public class ExchewsScheduleDTO extends ExchewsItemBase implements IScheduleDTO
{
	private static final long serialVersionUID = 1L;
	protected String location;
	protected Date start;
	protected Date end;
	
	protected MailAddress[] requiredAttendees;
	protected MailAddress[] optionalAttendees;
	protected MailAddress[] resources;
	protected MailAddress organizer;

	protected int adjacentMeetingCount;
	public int getAdjacentMeetingCount()
	{
		return adjacentMeetingCount;
	}

	public void setAdjacentMeetingCount(int adjacentMeetingCount)
	{
		this.adjacentMeetingCount = adjacentMeetingCount;
	}

	public boolean isAllowNewTimeProposal()
	{
		return allowNewTimeProposal;
	}

	public void setAllowNewTimeProposal(boolean allowNewTimeProposal)
	{
		this.allowNewTimeProposal = allowNewTimeProposal;
	}

	public Date getAppointmentReplyTime()
	{
		return appointmentReplyTime;
	}

	public void setAppointmentReplyTime(Date appointmentReplyTime)
	{
		this.appointmentReplyTime = appointmentReplyTime;
	}

	public int getAppointmentSequenceNumber()
	{
		return appointmentSequenceNumber;
	}

	public void setAppointmentSequenceNumber(int appointmentSequenceNumber)
	{
		this.appointmentSequenceNumber = appointmentSequenceNumber;
	}

	public int getAppointmentState()
	{
		return appointmentState;
	}

	public void setAppointmentState(int appointmentState)
	{
		this.appointmentState = appointmentState;
	}

	public String getCalendarItemType()
	{
		return calendarItemType;
	}

	public void setCalendarItemType(String calendarItemType)
	{
		this.calendarItemType = calendarItemType;
	}

	public List<String> getCategories()
	{
		return categories;
	}

	public void setCategories(List<String> categories)
	{
		this.categories = categories;
	}

	public int getConferenceType()
	{
		return conferenceType;
	}

	public void setConferenceType(int conferenceType)
	{
		this.conferenceType = conferenceType;
	}

	public int getConflictingMeetingCount()
	{
		return conflictingMeetingCount;
	}

	public void setConflictingMeetingCount(int conflictingMeetingCount)
	{
		this.conflictingMeetingCount = conflictingMeetingCount;
	}

	public Date getDateTimeStamp()
	{
		return dateTimeStamp;
	}

	public void setDateTimeStamp(Date dateTimeStamp)
	{
		this.dateTimeStamp = dateTimeStamp;
	}

	public String getDuration()
	{
		return duration;
	}

	public void setDuration(String duration)
	{
		this.duration = duration;
	}

	public String getInReplyTo()
	{
		return inReplyTo;
	}

	public void setInReplyTo(String inReplyTo)
	{
		this.inReplyTo = inReplyTo;
	}

	public boolean isAllDayEvent()
	{
		return isAllDayEvent;
	}

	public void setAllDayEvent(boolean isAllDayEvent)
	{
		this.isAllDayEvent = isAllDayEvent;
	}

	public boolean isCancelled()
	{
		return isCancelled;
	}

	public void setCancelled(boolean isCancelled)
	{
		this.isCancelled = isCancelled;
	}

	public boolean isMeeting()
	{
		return isMeeting;
	}

	public void setMeeting(boolean isMeeting)
	{
		this.isMeeting = isMeeting;
	}

	public boolean isOnlineMeeting()
	{
		return isOnlineMeeting;
	}

	public void setOnlineMeeting(boolean isOnlineMeeting)
	{
		this.isOnlineMeeting = isOnlineMeeting;
	}

	public boolean isRecurring()
	{
		return isRecurring;
	}

	public void setRecurring(boolean isRecurring)
	{
		this.isRecurring = isRecurring;
	}

	public boolean isResponseRequested()
	{
		return isResponseRequested;
	}

	public void setResponseRequested(boolean isResponseRequested)
	{
		this.isResponseRequested = isResponseRequested;
	}

	public String getLastModifiedName()
	{
		return lastModifiedName;
	}

	public void setLastModifiedName(String lastModifiedName)
	{
		this.lastModifiedName = lastModifiedName;
	}

	public String getLegacyFreeBusyStatus()
	{
		return legacyFreeBusyStatus;
	}

	public void setLegacyFreeBusyStatus(String legacyFreeBusyStatus)
	{
		this.legacyFreeBusyStatus = legacyFreeBusyStatus;
	}

	public boolean isMeetingRequestWasSent()
	{
		return meetingRequestWasSent;
	}

	public void setMeetingRequestWasSent(boolean meetingRequestWasSent)
	{
		this.meetingRequestWasSent = meetingRequestWasSent;
	}

	public String getMeetingTimeZone()
	{
		return meetingTimeZone;
	}

	public void setMeetingTimeZone(String meetingTimeZone)
	{
		this.meetingTimeZone = meetingTimeZone;
	}

	public String getMeetingWorkspaceUrl()
	{
		return meetingWorkspaceUrl;
	}

	public void setMeetingWorkspaceUrl(String meetingWorkspaceUrl)
	{
		this.meetingWorkspaceUrl = meetingWorkspaceUrl;
	}

	public String getMimeContent()
	{
		return mimeContent;
	}

	public void setMimeContent(String mimeContent)
	{
		this.mimeContent = mimeContent;
	}

	public String getMyResponseType()
	{
		return myResponseType;
	}

	public void setMyResponseType(String myResponseType)
	{
		this.myResponseType = myResponseType;
	}

	public String getNetShowUrl()
	{
		return netShowUrl;
	}

	public void setNetShowUrl(String netShowUrl)
	{
		this.netShowUrl = netShowUrl;
	}

	public Date getOriginalStart()
	{
		return originalStart;
	}

	public void setOriginalStart(Date originalStart)
	{
		this.originalStart = originalStart;
	}

	public String getParentFolderId()
	{
		return parentFolderId;
	}

	public void setParentFolderId(String parentFolderId)
	{
		this.parentFolderId = parentFolderId;
	}

	public Date getRecurrenceId()
	{
		return recurrenceId;
	}

	public void setRecurrenceId(Date recurrenceId)
	{
		this.recurrenceId = recurrenceId;
	}

	public Date getReminderDueBy()
	{
		return reminderDueBy;
	}

	public void setReminderDueBy(Date reminderDueBy)
	{
		this.reminderDueBy = reminderDueBy;
	}

	public String getTimeZone()
	{
		return timeZone;
	}

	public void setTimeZone(String timeZone)
	{
		this.timeZone = timeZone;
	}

	public String getUid()
	{
		return uid;
	}

	public void setUid(String uid)
	{
		this.uid = uid;
	}

	public String getWhen()
	{
		return when;
	}

	public void setWhen(String when)
	{
		this.when = when;
	}

	public String[] getScheduleItemNameList()
	{
		return ScheduleItemNameList;
	}

	public void setScheduleItemNameList(String[] scheduleItemNameList)
	{
		ScheduleItemNameList = scheduleItemNameList;
	}

	protected boolean allowNewTimeProposal;
	protected Date appointmentReplyTime;
	protected int appointmentSequenceNumber;
	protected int appointmentState;
	protected String calendarItemType;
	protected List<String> categories;
	protected int conferenceType;
	protected int conflictingMeetingCount;
	protected Date dateTimeStamp;
	protected String duration;
	protected String inReplyTo;
	protected boolean isAllDayEvent;
	protected boolean isCancelled;
	protected boolean isMeeting;
	protected boolean isOnlineMeeting;
	protected boolean isRecurring;
	protected boolean  isResponseRequested;
	protected String lastModifiedName;
	protected String legacyFreeBusyStatus;
	protected boolean meetingRequestWasSent;
	protected String meetingTimeZone="Tokyo Standard Time";
	protected String meetingWorkspaceUrl;
	protected String mimeContent;
	protected String myResponseType;
	protected String netShowUrl;
	protected Date originalStart;
	protected String parentFolderId;
	protected Date recurrenceId;
	protected Date reminderDueBy;
	protected String timeZone;
	protected String startTimeZone;
	protected String endTimeZone;
	public String getStartTimeZone()
	{
		return startTimeZone;
	}

	public void setStartTimeZone(String startTimeZone)
	{
		this.startTimeZone = startTimeZone;
	}

	public String getEndTimeZone()
	{
		return endTimeZone;
	}

	public void setEndTimeZone(String endTimeZone)
	{
		this.endTimeZone = endTimeZone;
	}

	protected String uid;
	protected String when;
	
	public MailAddress getOrganizer()
	{
		return organizer;
	}

	public void setOrganizer(MailAddress organizer)
	{
		this.organizer = organizer;
	}

	public Date getStart()
	{
		return start;
	}

	public void setStart(Date start)
	{
		this.start = start;
	}

	public Date getEnd()
	{
		return end;
	}

	public void setEnd(Date end)
	{
		this.end = end;
	}

	public MailAddress[] getRequiredAttendees()
	{
		return requiredAttendees;
	}

	public void setRequiredAttendees(MailAddress[] requiredAttendees)
	{
		this.requiredAttendees = requiredAttendees;
	}

	public MailAddress[] getTo()
	{
		return requiredAttendees;
	}

	public void setTo(MailAddress[] requiredAttendees)
	{
		this.requiredAttendees = requiredAttendees;
	}

	public MailAddress[] getOptionalAttendees()
	{
		return optionalAttendees;
	}

	public void setOptionalAttendees(MailAddress[] optionalAttendees)
	{
		this.optionalAttendees = optionalAttendees;
	}

	public long getReminderoffset()
	{
		if (reminderMinutesBeforeStart==null) return -1;
		return Long.parseLong(reminderMinutesBeforeStart);
	}

	public void setReminderoffset(long reminderoffset)
	{
		this.reminderMinutesBeforeStart = ""+reminderoffset;
	}

	public MailAddress[] getCc()
	{
		return optionalAttendees;
	}

	public void setCc(MailAddress[] optionalAttendees)
	{
		this.optionalAttendees = optionalAttendees;
	}

	public MailAddress[] getResources()
	{
		return resources;
	}

	public void setResources(MailAddress[] resources)
	{
		this.resources = resources;
	}

	public MailAddress[] getBcc()
	{
		return resources;
	}

	public void setBcc(MailAddress[] resources)
	{
		this.resources = resources;
	}

	protected String[] ScheduleItemNameList = {
		    "uid",
		    "recurrenceId",
		    "dateTimeStamp",
		    "start",
		    "end",
		    "originalStart",
		    "isAllDayEvent",
		    "legacyFreeBusyStatus",
		    "location",
		    "when",
		    "isMeeting",
		    "isCancelled",
		    "isRecurring",
		    "meetingRequestWasSent",
		    "isResponseRequested",
		    "calendarItemType",
		    "myResponseType",
		    "organizer",
		    "requiredAttendees",
		    "optionalAttendees",
		    "resources",
		    "conflictingMeetingCount",
		    "adjacentMeetingCount",
		    "conflictingMeetings",
		    "adjacentMeetings",
		    "duration",
		    "timeZone",
		    "appointmentReplyTime",
		    "appointmentSequenceNumber",
		    "appointmentState",
		    "recurrence",
		    "firstOccurrence",
		    "lastOccurrence",
		    "modifiedOccurrences",
		    "deletedOccurrences",
		    "meetingTimeZone",
		    "conferenceType",
		    "allowNewTimeProposal",
		    "isOnlineMeeting",
		    "meetingWorkspaceUrl",
		    "netShowUrl"
	};
	

	public static ExchewsScheduleDTO convertFromCalendarItemType(CalendarItemType item) throws Exception
	{
		if (item == null) return null;
		ExchewsScheduleDTO rc = new ExchewsScheduleDTO();
		
		convertFromItemType(rc,item);
		if (item.getBody()!=null) Log.trace("item.getBody().getValue():"+item.getBody().getValue());
		
		if (item.getTimeZone()!=null) rc.timeZone = item.getTimeZone();
		if (item.getStartTimeZone() !=null) rc.startTimeZone = item.getStartTimeZone().getId();
		if (item.getEndTimeZone() !=null) rc.endTimeZone = item.getEndTimeZone().getId();
		rc.location = item.getLocation();
		rc.start = ExchEWSTranslator.convertEWSDateTime2JavaDate(item.getStart());
		rc.end = ExchEWSTranslator.convertEWSDateTime2JavaDate(item.getEnd());
		try {
			rc.setMeetingTimeZone(null);
			rc.setMeetingTimeZone(item.getMeetingTimeZone().getTimeZoneName());
		}
		catch (NullPointerException e){};
		try {
			rc.setOrganizer(ExchEWSTranslator.convertEWSMailBox2MailAddress(item.getOrganizer().getMailbox()));
		}
		catch (NullPointerException e){};
		try {
			List<AttendeeType> to_ar = item.getRequiredAttendees().getAttendee();
			MailAddress[] add = new MailAddress[to_ar.size()];
			int i=0;
			for (AttendeeType to : to_ar) {
				add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(to.getMailbox());
			}
			rc.setTo(add);
		}
		catch (NullPointerException e){};
		try {
			List<AttendeeType> cc_ar = item.getOptionalAttendees().getAttendee();
			MailAddress[] add = new MailAddress[cc_ar.size()];
			int i=0;
			for (AttendeeType cc : cc_ar) {
				add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(cc.getMailbox());
			}
			rc.setCc(add);
		}
		catch (NullPointerException e){};
		try {
			List<AttendeeType> bcc_ar = item.getResources().getAttendee();
			MailAddress[] add = new MailAddress[bcc_ar.size()];
			int i=0;
			for (AttendeeType bcc : bcc_ar) {
				add[i++] = ExchEWSTranslator.convertEWSMailBox2MailAddress(bcc.getMailbox());
			}
			rc.setBcc(add);
		}
		catch (NullPointerException e){};
		
		return rc;
		
	}
	
	public static CalendarItemType convertToCalendarItemType(IScheduleDTO dto) throws Exception
	{
		if (dto == null) return null;
		CalendarItemType rc = new CalendarItemType();
		if (!(dto instanceof ExchewsScheduleDTO)) {
			throw new IllegalArgumentException("dto must be instance of ExchewsScheduleDTO");
		}
		ExchewsScheduleDTO schedule = (ExchewsScheduleDTO)dto;
		
		convertToItemType(rc,schedule);
		
		if (schedule.getBody()!=null) Log.debug("item.getBody().getValue():"+schedule.getBody());
		
		rc.setLocation(schedule.getLocation());
		rc.setStart(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getStart()));
		rc.setEnd(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getEnd()));
		try {
			SingleRecipientType organizer = new SingleRecipientType();
			organizer.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(schedule.getOrganizer()));
//			rc.setOrganizer(organizer);
		}
		catch (NullPointerException e){};
		
		try {
			MailAddress[] to_ar = schedule.getTo();
			NonEmptyArrayOfAttendeesType attype = new NonEmptyArrayOfAttendeesType();
			List<AttendeeType> atl = attype.getAttendee();
			for (MailAddress to : to_ar) {
				AttendeeType attendeeType = new AttendeeType();
				attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(to));
				atl.add(attendeeType);
			}
			rc.setRequiredAttendees(attype);
		}catch (NullPointerException e){};
		
		try {
			MailAddress[] cc_ar = schedule.getCc();
			NonEmptyArrayOfAttendeesType attype = new NonEmptyArrayOfAttendeesType();
			List<AttendeeType> atl = attype.getAttendee();
			for (MailAddress cc : cc_ar) {
				AttendeeType attendeeType = new AttendeeType();
				attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(cc));
				atl.add(attendeeType);
			}
			rc.setOptionalAttendees(attype);
		}
		catch (NullPointerException e){};
		try {
			MailAddress[] bcc_ar = schedule.getBcc();
			NonEmptyArrayOfAttendeesType attype = new NonEmptyArrayOfAttendeesType();
			List<AttendeeType> atl = attype.getAttendee();
			for (MailAddress bcc : bcc_ar) {
				AttendeeType attendeeType = new AttendeeType();
				attendeeType.setMailbox(ExchEWSTranslator.convertMailAddress2EWSMailBox(bcc));
				atl.add(attendeeType);
			}
			rc.setResources(attype);
		}
		catch (NullPointerException e){};


//		rc.setAdjacentMeetingCount(schedule.getAdjacentMeetingCount());
		//if (item.getAdjacentMeetings()!=null)rc.setAdjacentMeetings(item.getAdjacentMeetings());
//		rc.setAllowNewTimeProposal(schedule.isAllowNewTimeProposal());
//		if (schedule.getAppointmentReplyTime()!=null)rc.setAppointmentReplyTime(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getAppointmentReplyTime())); 
//		rc.setAppointmentSequenceNumber(schedule.getAppointmentSequenceNumber()); 
//		rc.setAppointmentState(schedule.getAppointmentState());

//		try{
//			String c = schedule.getCalendarItemType();
//			if (c.equalsIgnoreCase("SINGLE"))rc.setCalendarItemType(CalendarItemTypeType.SINGLE);
//			if (c.equalsIgnoreCase("OCCURRENCE"))rc.setCalendarItemType(CalendarItemTypeType.OCCURRENCE);
//			if (c.equalsIgnoreCase("EXCEPTION"))rc.setCalendarItemType(CalendarItemTypeType.EXCEPTION);
//			if (c.equalsIgnoreCase("RECURRING_MASTER"))rc.setCalendarItemType(CalendarItemTypeType.RECURRING_MASTER);
//		}catch (NullPointerException e){};

		try{
			ArrayOfStringsType array = new ArrayOfStringsType();
			List<String> a = array.getString();
			for (String cat : schedule.getCategories()) {
				a.add(cat);
			}
//			rc.setCategories(array);
		}catch (NullPointerException e){};

//		rc.setConferenceType(schedule.getConferenceType());
//		rc.setConflictingMeetingCount(schedule.getConflictingMeetingCount());
		//if (item.getConflictingMeetings()!=null)rc.setConflictingMeetings(item.getConflictingMeetings());
//		if (schedule.getDateTimeStamp()!=null)rc.setDateTimeStamp(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getDateTimeStamp()));
		//if (item.getDeletedOccurrences()!=null)rc.setDeletedOccurrences(item.getDeletedOccurrences());
//		if (schedule.getDuration()!=null)rc.setDuration(schedule.getDuration());
		//rc.setEffectiveRights(item.getEffectiveRights());
		//if (item.getExtendedProperty()!=null)rc.setExtendedProperty(item.getExtendedProperty());
		//if (item.getFirstOccurrence()!=null)rc.setFirstOccurrence(item.getFirstOccurrence().);
//		if (schedule.getInReplyTo()!=null)rc.setInReplyTo(schedule.getInReplyTo());
		//if (item.getInternetMessageHeaders()!=null)rc.setInternetMessageHeaders(item.getInternetMessageHeaders());
		rc.setIsAllDayEvent(schedule.isAllDayEvent());
//		rc.setIsCancelled(schedule.isCancelled());
//		rc.setIsMeeting(schedule.isMeeting());
//		rc.setIsOnlineMeeting(schedule.isOnlineMeeting());
//		rc.setIsRecurring(schedule.isRecurring());
//		rc.setIsResponseRequested(schedule.isResponseRequested());
//		if (schedule.getLastModifiedName()!=null)rc.setLastModifiedName(schedule.getLastModifiedName());
		//if (item.getLastOccurrence()!=null)rc.setLastOccurrence(item.getLastOccurrence().);
		
//		try{
//			String l = schedule.getLegacyFreeBusyStatus();
//			if (l.equalsIgnoreCase("FREE"))rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.FREE);
//			if (l.equalsIgnoreCase("TENTATIVE"))rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.TENTATIVE);
//			if (l.equalsIgnoreCase("BUSY"))rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.BUSY);
//			if (l.equalsIgnoreCase("OOF"))rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.OOF);
//			if (l.equalsIgnoreCase("NO_DATA"))rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.NO_DATA);
			rc.setLegacyFreeBusyStatus(LegacyFreeBusyType.BUSY);
//		}catch (NullPointerException e){};

//		rc.setMeetingRequestWasSent(schedule.isMeetingRequestWasSent());
		
		if (schedule.getMeetingTimeZone()!=null){
			TimeZoneType tz = new TimeZoneType();
			tz.setTimeZoneName(schedule.getMeetingTimeZone());
			rc.setMeetingTimeZone(tz);
		}
		if (schedule.getMeetingWorkspaceUrl()!=null)rc.setMeetingWorkspaceUrl(schedule.getMeetingWorkspaceUrl());
		
		if (schedule.getMimeContent()!=null){
			MimeContentType mimeContentType = new MimeContentType();
			mimeContentType.setValue(schedule.getMimeContent());
//			rc.setMimeContent(mimeContentType);
		}

		//if (item.getModifiedOccurrences()!=null)rc.setModifiedOccurrences(item.getModifiedOccurrences());
		
//		try{
//			String r = schedule.getMyResponseType();
//			if (r.equalsIgnoreCase("ACCEPT"))rc.setMyResponseType(ResponseTypeType.ACCEPT);
//			if (r.equalsIgnoreCase("DECLINE"))rc.setMyResponseType(ResponseTypeType.DECLINE);
//			if (r.equalsIgnoreCase("NO_RESPONSE_RECEIVED"))rc.setMyResponseType(ResponseTypeType.NO_RESPONSE_RECEIVED);
//			if (r.equalsIgnoreCase("ORGANIZER"))rc.setMyResponseType(ResponseTypeType.ORGANIZER);
//			if (r.equalsIgnoreCase("TENTATIVE"))rc.setMyResponseType(ResponseTypeType.TENTATIVE);
//			if (r.equalsIgnoreCase("UNKNOWN"))rc.setMyResponseType(ResponseTypeType.UNKNOWN);
//		}catch (NullPointerException e){};
		
//		if (schedule.getNetShowUrl()!=null)rc.setNetShowUrl(schedule.getNetShowUrl());
//		if (schedule.getOriginalStart()!=null)rc.setOriginalStart(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getOriginalStart()));
		
		if (schedule.getParentFolderId()!=null){
			FolderIdType folderIdType = new FolderIdType();
			folderIdType.setId(schedule.getParentFolderId());
//			rc.setParentFolderId(folderIdType);
		}		
		//if (item.getRecurrence()!=null)rc.setRecurrence(item.getRecurrence());
//		if (schedule.getRecurrenceId()!=null)rc.setRecurrenceId(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getRecurrenceId()));
//		if (schedule.getReminderDueBy()!=null)rc.setReminderDueBy(ExchEWSTranslator.convertJavaDate2EWSDateTime(schedule.getReminderDueBy()));
		//if (item.getResponseObjects()!=null)rc.setResponseObjects(item.getResponseObjects());
//		if (schedule.getTimeZone()!=null)rc.setTimeZone(schedule.getTimeZone());
//		if (schedule.getUid()!=null)rc.setUID(schedule.getUid());
//		if (schedule.getWhen()!=null)rc.setWhen(schedule.getWhen());
		
		return rc;
		
	}
	
	@Override
	public Date getEndDate()
	{
		return this.end;
	}

	@Override
	public String getLocation()
	{
		return this.location;
	}

	@Override
	public Date getStartDate()
	{
		return this.start;
	}

	@Override
	public String getUserId()
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public void setEndDate(Date endDate)
	{
		this.end = endDate;
	}

	@Override
	public void setLocation(String location)
	{
		this.location = location;
	}

	@Override
	public void setStartDate(Date startDate)
	{
		this.start = startDate;
	}

	@Override
	public void setUserId(String userId)
	{
		// TODO ꂽ\bhEX^u

	}

}
