/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.*;

import javax.xml.bind.JAXBElement;
import javax.xml.ws.*;

import com.microsoft.schemas.exchange.services._2006.messages.*;
import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.EWSSearchFormula;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;

public class ExchewsMailStoreImpl extends EAIExchewsBase implements IMailStore
{
	public static final List<String> SEARCH_FIELDS_HEADERS = IEwsSearchFormula.ALL_PROPERTIES;
	public static final IStoreID storeID = new SimpleStoreID(ExchewsMailStoreImpl.class.getName());
	protected static final String itemType="IPM.Note";

	public static final String storeName = "Exchange EWS mail store";

	@Override
	public void deleteMail(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		try {
			this.delete(acc,null,oid);
		}
		catch (Exception e) {
			if (e instanceof HandleException) {
				throw (HandleException)e;
			}
			else {
				throw new HandleException(e);
			}
		}
	}

	@Override
	public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);

		ExchewsFolderIndex idx = (ExchewsFolderIndex) dest.getFolder();

		BaseFolderIdType src = (BaseFolderIdType) idx.getIndex();

		FindItemType finder = new FindItemType();

		FolderResponseShapeType folderShape = new FolderResponseShapeType();
		folderShape.setBaseShape(DefaultShapeNamesType.ALL_PROPERTIES);

		IndexedPageViewType index = new IndexedPageViewType();
		index.setBasePoint(IndexBasePointType.BEGINNING);
		index.setOffset(0);

		finder.setIndexedPageItemView(index);

		NonEmptyArrayOfBaseFolderIdsType folderIds = new NonEmptyArrayOfBaseFolderIdsType();
		List<BaseFolderIdType> ids = folderIds.getFolderIdOrDistinguishedFolderId();
		ids.add(src);
		finder.setParentFolderIds(folderIds);

		FindFolderResponseType findFolderResponse = new FindFolderResponseType();
		Holder<FindFolderResponseType> responseHolder = new Holder<FindFolderResponseType>(findFolderResponse);

		ExchangeServicePortType proxy = null;
		List<BaseFolderType> mailFolders = new ArrayList<BaseFolderType>();
		List<JAXBElement<? extends ResponseMessageType>> responses = null;

		try {
			ExchangeServices service = new ExchangeServices();
			proxy = service.getExchangeServicePort();
			BindingProvider bp = (BindingProvider) proxy;
			Map<String, Object> map = bp.getRequestContext();
			map.put(BindingProvider.USERNAME_PROPERTY, domain + "\\" + userID);
			map.put(BindingProvider.PASSWORD_PROPERTY, password);
			map.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPointUri);

			// proxy.findItem(arg0, arg1, arg2, arg3);
			// proxy.findFolder(finder, version, responseHolder,
			// serverVersionHolder);

			responses = responseHolder.value.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();

			for (JAXBElement<? extends ResponseMessageType> jaxResponse : responses) {
				ResponseMessageType response = jaxResponse.getValue();
				if (response.getResponseClass().equals(ResponseClassType.ERROR)) {
					Log.warn("Get Child Folders Response Error: " + response.getMessageText());
				}
				else if (response.getResponseClass().equals(ResponseClassType.WARNING)) {
					Log.warn("Get Child Folders Response Warning: " + response.getMessageText());
				}
				else if (response.getResponseClass().equals(ResponseClassType.SUCCESS)) {
					FindFolderResponseMessageType findResponse = (FindFolderResponseMessageType) response;
					List<BaseFolderType> allFolders = findResponse.getRootFolder().getFolders().getFolderOrCalendarFolderOrContactsFolder();
					for (BaseFolderType folder : allFolders) {
						Log.debug("folder name:" + folder.getDisplayName());
						Log.debug("number of child folders" + folder.getChildFolderCount());
						mailFolders.add(folder);
					}
				}
			}

		}
		catch (Exception e) {
			throw new RuntimeException("Exception Performing getChildFolders", e);
		}

		return null;
	}

	@Override
	public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		MessageType message = (MessageType) getItem(dest,(ItemIdType) oid.getIndex());
		ExchewsMailDTO rc = null;
		try {
			rc = ExchewsMailDTO.convertFromMessageType(message);
			if (rc!=null) {
				if (message.isHasAttachments().booleanValue()) {
					rc.convertAndSetEWSAttachments(getAttachments(message));
				}
			}
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("mail convert error", e);
			throw new HandleException(e);
		}
		return rc;
	}

	@Override
	public FolderMetadata[] getMailFolders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		FolderMetadata[] folders = null;
		try {
			folders = this.getFolderList(acc, dest);
		}
		catch (Exception e) {
			throw new HandleException(e);
		}
		return folders;
	}

	public IMailDTO[] getMailsByDate(IAccountData acc, ISearchFormula search, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		IMailDTO[] dtos=new ExchewsMailDTO[1];

		List<? extends ItemType> messages = new ArrayList<MessageType>();
		try {
			messages = super.searchByDate(search.getDest(), (List<String>)search.getFieldsToGet(), search.getSearchConditions(),date,itemType);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("", e);
			throw new HandleException(e);
		}
		ArrayList<ExchewsMailDTO> rc = new ArrayList<ExchewsMailDTO>();

		for (ItemType message : messages) {
			try {
				ExchewsMailDTO dto = ExchewsMailDTO.convertFromMessageType((MessageType)message);
				rc.add(dto);
				if (message.isHasAttachments().booleanValue()) {
					dto.convertAndSetEWSAttachments(getAttachments(message));
				}
			}
			catch (Exception e) {
				Log.debug("error on converting MessageType to ExchewsMailDTO. skip one data..", e);
			}
		}

		return rc.toArray(dtos);
	}
	
	@Override
	public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		SearchConditionCollection cond = getDateSearchCondition(UnindexedFieldURIType.ITEM_DATE_TIME_RECEIVED, date);
		List<String> fieldsToGet = SEARCH_FIELDS_HEADERS;
		EWSSearchFormula form = null;
		try {
			form = new EWSSearchFormula(dest, fieldsToGet, cond);
		}
		catch (Exception e) {
			Log.error("", e);
			throw new HandleException();
		}
		
		return this.getMailsByDate(acc, form, date);
	}

	@Override
	public IMailDTO[] getSentMails(IAccountData acc) throws ServerDown, HandleException
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IMailDTO[] getSentMailsByDate(IAccountData acc, Date date) throws ServerDown, HandleException
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex sendMail(IAccountData acc, IMailDTO dto) throws NoSuchRights, ServerDown, IncorrectData, HandleException
	{
		IObjectIndex rc = null;
		ISearchDestination dst = getPresetDestination(acc, DEST_TYPE_DRAFT_FOLDER);
		try {
			rc = this.write(acc,dst,dto);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			throw new HandleException(e);
		}
		return rc;
	}

	@Override
	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);
		super.delete(oid);
	}

	@Override
	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception
	{
		super.setAccountData(acc);
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject getFolderIndexFromString(String idx) throws IncorrectData
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception
	{
		super.setAccountData(acc);

		ExchewsFolderIndex idx = (ExchewsFolderIndex) dest.getFolder();

		BaseFolderIdType src = (BaseFolderIdType) idx.getIndex();

		List<BaseFolderType> folders = super.getAllSubFolders(src,0);

		ArrayList<ExchewsFolderMetadata> rc = new ArrayList<ExchewsFolderMetadata>();

		ExchewsFolderMetadata a[] = new ExchewsFolderMetadata[0];
		for (BaseFolderType folder : folders) {
			rc.add(ExchewsFolderMetadata.convertFromEWSFolderType((FolderType) folder));
		}

		return rc.toArray(a);
	}

	@Override
	public String getName() throws Exception
	{
		return storeName;
	}

	@Override
	public ISearchDestination getPresetDestination(IAccountData acc, int dest) throws IncorrectData, HandleException
	{
		super.setAccountData((PasswordBasedAccountDataImpl) acc);
		IFolderIndex folder = null;
		IDatabaseIndex db = null;
		DistinguishedFolderIdType src = new DistinguishedFolderIdType();
		switch (dest) {
		case DEST_TYPE_DEFAULT_MAIL_FOLDER:
			src.setId(inboxElement);
			break;
		case DEST_TYPE_SENT_FOLDER:
			src.setId(sentboxElement);
			break;
		case DEST_TYPE_DRAFT_FOLDER:
			src.setId(draftElement);
			break;
		default:
			throw new IncorrectData("illegal folderType");
		}
		folder = (IFolderIndex) populateFolder(new ExchewsFolderIndex(src)).getOid();
		return (ISearchDestination) new BasicSearchDestination(db, folder);
	}

	public IServiceInfo getServiceInfo() throws Exception
	{
		return new ExchewsServiceInfo(storeID, storeName);
	}

	@Override
	public IServiceInfo getServiceInfo(IServiceInfoRawData data) throws Exception
	{
		return super.getServiceInfo(storeID, storeName, data);
	}

	@Override
	public IStoreID getStoreID() throws Exception
	{
		return storeID;
	}

	@Override
	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		return getMail(acc, dest, oid);
	}

	@Override
	public IRecordObject[] search(IAccountData acc, ISearchFormula frm) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception
	{
		return getMailsByDate(acc, dest, date);
	}

	@Override
	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject dto) throws Exception
	{
		IObjectIndex rc = null;
		if (dto==null) throw new NullPointerException("dto must not be null.");
		if (dest==null) throw new NullPointerException("dest must not be null.");
		IFolderIndex folder = dest.getFolder();
		if (folder==null) throw new NullPointerException("destination folder must not be null.");
		DistinguishedFolderIdType element = (DistinguishedFolderIdType) folder.getIndex();
		if (acc==null) throw new NullPointerException("acc must not be null.");
		super.setAccountData(acc);
		IMailDTO mail = (IMailDTO) dto;
		ItemType item;
		
		try {
			item = ExchewsMailDTO.convertToMessageType(mail);
		}
		catch (Exception e) {
			Log.error("MailDTO convert error.", e);
			throw new IncorrectData(e.getMessage());
		}
		item = super.createItem(element.getId(), item);
		ItemIdType itemId = item.getItemId();
		ExchewsObjectIndex oid = new ExchewsObjectIndex(itemId);
		
		AttachmentDTO[] atts = mail.getAttachments();
		if ((atts!=null) && (atts.length>0)) {
			super.addAttach(itemId,atts);
		}
		if (oid==null) {
			throw new HandleException("failed to save mail to the server.");
		}
		
		boolean success = super.sendSavedMsg(itemId,(DistinguishedFolderIdType) getPresetDestination(acc, DEST_TYPE_SENT_FOLDER).getFolder().getIndex());
		if (success) {
			rc = oid;
		}
		return rc;
	}

	@Override
	protected UnindexedFieldURIType getDateField()
	{
		return UnindexedFieldURIType.ITEM_DATE_TIME_RECEIVED;
	}

	@Override
	protected TargetFolderIdType getTargetFolder()
	{
		TargetFolderIdType target = new TargetFolderIdType();
		DistinguishedFolderIdType id = new DistinguishedFolderIdType();
		id.setId(inboxElement);
		target.setDistinguishedFolderId(id);
		return target;
	}

	
}
