/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.IEwsDTOType;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.IAddressDTO;

public class ExchewsAddressDTO extends ExchewsItemBase implements IAddressDTO, IEwsDTOType
{
	private static final long serialVersionUID = 1L;
	/*
	id				tid				DAV:id
	oid				oid				DAV:href
				displayName		sn+givenname
	[AhX	email			email1
	Tel			companyphone	telephoneNumber
	Tel			homePhone		homePhone
	gTel			mobilePhone		mobile
	Ж			companyName		o
	ЏZ		companyAddress	workaddress
	 */
	protected String displayName;
	protected String companyName;
	protected String surName;
	protected String givenName;
	protected String middleName;
	protected String email;
	protected String companyPhone;
	protected String homePhone;
	protected String mobilePhone;
	protected String companyAddress;

	public static ExchewsAddressDTO convertFromContactItemType(ContactItemType msg) throws Exception
	{
		if (msg == null) return null;
		ExchewsAddressDTO rc = new ExchewsAddressDTO();
		
		convertFromItemType(rc,msg);
		
		PhoneNumberDictionaryType phones = msg.getPhoneNumbers();
		if (phones!=null) {
			for ( PhoneNumberDictionaryEntryType ph : phones.getEntry()) {
				switch (ph.getKey()) {
				case HOME_PHONE:
					rc.homePhone = ph.getValue();
					break;
				case BUSINESS_PHONE:
					rc.companyPhone = ph.getValue();
					break;
				case MOBILE_PHONE:
					rc.mobilePhone = ph.getValue();
					break;
				}
			}
		}
		PhysicalAddressDictionaryType phAddr = msg.getPhysicalAddresses();
		if (phAddr!=null) {
			for (PhysicalAddressDictionaryEntryType entry : phAddr.getEntry()) {
				switch (entry.getKey()) {
				case BUSINESS:
					rc.companyAddress = entry.getPostalCode()+" "+entry.getState()+" "+entry.getCity()+" "+entry.getStreet()+","+entry.getCountryOrRegion();
				}
			}
		}
//		msg.getAssistantName();
//		msg.getAttachments();
//		msg.getBirthday();
//		msg.getBusinessHomePage();
		ArrayOfStringsType companies = msg.getCompanies();
		if (companies!=null) {
			for (String company : companies.getString()) {
				Log.trace(company);
			}
		}
		rc.companyName = msg.getCompanyName();
//		msg.getDepartment();
		rc.displayName = msg.getFileAs();
		if (rc.displayName==null) {
			rc.displayName = msg.getDisplayName();// in case do not have fileas field.
		}
		EmailAddressDictionaryType addrs = msg.getEmailAddresses();
		if (addrs!=null) {
			for (EmailAddressDictionaryEntryType addr: addrs.getEntry()) {
				String value = addr.getValue();
				if (value!=null) {
					rc.email = value;
					break;
				}
			}
		}
		rc.givenName = msg.getGivenName();
//		msg.getJobTitle();
		rc.middleName = msg.getMiddleName();
//		msg.getSubject();
		rc.surName = msg.getSurname();
		rc.setBeanData();
		return rc;
	}

	@Override
	public void copy(IAddressDTO src)
	{
		// TODO ꂽ\bhEX^u

	}

	@Override
	public String getCompanyName()
	{
		return companyName;
	}

	public String getCompanyPhone()
	{
		return companyPhone;
	}

	public void setCompanyPhone(String companyPhone)
	{
		this.companyPhone = companyPhone;
	}

	public String getHomePhone()
	{
		return homePhone;
	}

	public void setHomePhone(String homePhone)
	{
		this.homePhone = homePhone;
	}

	public String getMobilePhone()
	{
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone)
	{
		this.mobilePhone = mobilePhone;
	}

	public String getCompanyAddress()
	{
		return companyAddress;
	}

	public void setCompanyAddress(String companyAddress)
	{
		this.companyAddress = companyAddress;
	}

	@Override
	public String getDisplayName()
	{
		return displayName;
	}

	@Override
	public String getEmail()
	{
		return email;
	}

	@Override
	public String getFamilyName()
	{
		return surName;
	}

	@Override
	public String getFirstName()
	{
		return givenName;
	}

	@Override
	public String getTid()
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public void setCompanyName(String companyName)
	{
		this.companyName = companyName;
	}

	@Override
	public void setDisplayName(String displayName)
	{
		this.displayName = displayName;
	}

	@Override
	public void setEmail(String email)
	{
		this.email = email;
	}

	@Override
	public void setFamilyName(String familyName)
	{
		this.surName = familyName;
	}

	@Override
	public void setFirstName(String firstName)
	{
		this.givenName = firstName;
	}

	@Override
	public void setTid(String tid)
	{
		// TODO ꂽ\bhEX^u

	}

}
