/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ews;

import java.util.ArrayList;

import javax.xml.bind.JAXBElement;

import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.ISearchCondition;
import jp.co.connectone.store.ISearchConditionElement;

import com.microsoft.schemas.exchange.services._2006.types.AndType;
import com.microsoft.schemas.exchange.services._2006.types.SearchExpressionType;

public class EWS_AND_SearchConditionCollection extends EWSSearchConditionCollection
{
	public SearchExpressionType generateSearchExpression() throws HandleException
	{
		AndType at = new AndType();
		ArrayList<JAXBElement<? extends SearchExpressionType>> list = new ArrayList<JAXBElement<? extends SearchExpressionType>>();
		for (ISearchConditionElement o : this) {
			JAXBElement<? extends SearchExpressionType> ex=null;
			if (o instanceof ISearchCondition) {
				EWSSearchCondition cond = (EWSSearchCondition)o;
				ex = cond.generateSearchExpression();
			}
//			else {
//				EWSSearchConditionCollection col = (EWSSearchConditionCollection)o;
//				ex = col.generateSearchExpression();
//			}
			list.add(ex);
		}
		@SuppressWarnings("unchecked")
		JAXBElement<? extends SearchExpressionType>[] a = new JAXBElement[0];
		at = ExchEWSTranslator.createAnd(list.toArray(a));
		return at;
	}

}
