import jp.co.connectone.eai.exch2k.store.*;
import jp.co.connectone.eai.exch2k.user.*;
import jp.co.connectone.log.Log;
import junit.framework.TestCase;
import jp.co.connectone.store.client.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;

/**
 * @author amanot
 *
 */
public class TestExch2kAddressBookImpl extends TestCase {
	private Exch2kAddressBookStoreImpl AddressBookStore;
	private PasswordBasedAccountDataImpl acc;
	private Exch2kServiceInfo si;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		AddressBookStore = new Exch2kAddressBookStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		si = (Exch2kServiceInfo)AddressBookStore.getServiceInfo();
		si.setServerAddress("172.16.3.1");
		acc = new Exch2kAccountData(uid,si);
		acc.setUserID("test");
		acc.setPassword("********");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		AddressBookStore = null;
	}

	public void testGetAddressBookItems() throws Exception
	{
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
		IAddressDTO[] rc = AddressBookStore.getAddressBookItems(acc,dest);
		assertNotNull(rc);
		for (int i=0;i<rc.length;i++) {
			dumpDTO(rc[i]);
		}
	}
	
	public void teXstSearchAddressBookG() throws Exception
	{
		SearchConditionCollection conds = new SearchConditionCollection();
Log.debug("global address book");
		AddressBookSearchCondition cond = new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME,"eXg");
		conds.add(cond);
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = AddressBookStore.searchAddressBook(acc,formula);
		assertNotNull(rc);
		for (int i=0;i<rc.length;i++) {
			dumpDTO(rc[i]);
		}
	}
	
	public void testSearchAddressBookL() throws Exception
	{
Log.debug("local address book");
		SearchConditionCollection conds = new SearchConditionCollection();
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = AddressBookStore.searchAddressBook(acc,formula);
		assertNotNull(rc);
		for (int i=0;i<rc.length;i++) {
			dumpDTO(rc[i]);
		}
	}

	public void testGetAddressBookItemG() throws Exception
	{
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
		IAddressDTO rc = AddressBookStore.getAddressBookItem(acc,dest,new BasicObjectIndex("takasaki"));
		assertNotNull(rc);
		dumpDTO(rc);
	}

	public void testGetAddressBookItemL() throws Exception
	{
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
		IAddressDTO rc = AddressBookStore.getAddressBookItem(acc,dest,new BasicObjectIndex("http://172.16.3.1/exchange/test@connectone.co.jp/%E9%80%A3%E7%B5%A1%E5%85%88/%E5%B0%8F%E9%B9%BF%20%E4%B8%8D%E4%BA%8C%E4%BA%BA.EML"));
		assertNotNull(rc);
		dumpDTO(rc);
	}
	
	private void dumpDTO(IAddressDTO dto)
	{
		Log.debug("=======================================");
		Log.debug(dto.getOid().getIndex().toString());
		Log.debug(dto.getDisplayName());
		Log.debug(dto.getFirstName());
		Log.debug(dto.getFamilyName());
		Log.debug(dto.getMobilePhone());
		Log.debug(dto.getEmail());
		Log.debug("=======================================");
	}
}
